/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.test;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.Arrays;
import org.makagiga.commons.Args;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileScanner;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.test.Ignore;
import org.makagiga.test.Test;
import org.makagiga.test.TestConstructor;
import org.makagiga.test.TestException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class Tester
extends MApplication {
    private static File baseDir;
    private static Flags testFlags;
    private static int failures;
    private static int testCount;
    private static int warnings;
    private static MArrayList<Class<?>> testedClasses;
    private static MArrayList<Element> elementList;
    private static MArrayList<Element> missingTests;
    private static String pathToTest;

    public static void main(String ... stringArray) {
        Tester.init(stringArray, "makagiga-tester");
        Tester.launch(Tester.class);
    }

    @Deprecated
    public static void testEquals(Object object) {
        Tester.testEquals(object, null, null);
    }

    @SuppressWarnings(value="EC")
    public static void testEquals(Object object, Object object2, Object object3) {
        if (object.equals(new Object())) {
            Tester.fail("x.equals(new Object())");
        }
        int[] nArray = new int[10];
        for (int i = 0; i < 10; ++i) {
            nArray[i] = object.hashCode();
            if (!object.equals(object)) {
                Tester.fail("x.equals(x)");
            }
            if (object2 != null) {
                if (!object.equals(object2)) {
                    Tester.fail("x.equals(y)");
                }
                if (!object2.equals(object)) {
                    Tester.fail("y.equals(x)");
                }
            }
            if (object2 != null && object3 != null) {
                if (!object.equals(object2)) {
                    Tester.fail("x.equals(y)");
                }
                if (!object2.equals(object3)) {
                    Tester.fail("y.equals(z)");
                }
                if (!object.equals(object3)) {
                    Tester.fail("x.equals(z)");
                }
            }
            if (object.equals(null)) {
                Tester.fail("x.equals(null)");
            }
            if (object2 == null || object.hashCode() == object2.hashCode()) continue;
            Tester.fail("x.hashCode() != y.hashCode()");
        }
        int[] nArray2 = new int[10];
        Arrays.fill(nArray2, nArray[0]);
        if (!Arrays.equals(nArray, nArray2)) {
            Tester.fail("Invalid hashCode() result");
        }
    }

    public static <T extends Throwable> void testException(Class<T> clazz, Code code) {
        TK.checkNull(clazz, "expected");
        TK.checkNull(code, "code");
        AssertionError assertionError = new AssertionError((Object)("\"" + clazz.getName() + "\" expected but nothing interesting happened"));
        try {
            code.run();
            throw assertionError;
        }
        catch (Throwable throwable) {
            if (throwable == assertionError) {
                throw assertionError;
            }
            if (throwable.getClass() != clazz) {
                throwable.printStackTrace();
                Tester.fail("\"" + clazz.getName() + "\" expected but got \"" + throwable.getClass().getName() + "\"");
            }
            return;
        }
    }

    public static void testIllegalArgumentException(Code code) {
        Tester.testException(IllegalArgumentException.class, code);
    }

    public static void testNullPointerException(Code code) {
        Tester.testException(NullPointerException.class, code);
    }

    public static void testParseException(Code code) {
        Tester.testException(ParseException.class, code);
    }

    public static void testSerializable(Object object) {
        Tester.testSerialization(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T testSerialization(T t) {
        Object object;
        block19: {
            object = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            try {
                ObjectInputStream objectInputStream;
                block18: {
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(t);
                    }
                    catch (NotSerializableException notSerializableException) {
                        try {
                            Tester.warning("Class \"%s\" is not serializable", t.getClass().getName());
                            ++failures;
                        }
                        catch (Throwable throwable) {
                            FS.close(objectOutputStream);
                            throw throwable;
                        }
                        FS.close(objectOutputStream);
                    }
                    FS.close(objectOutputStream);
                    objectInputStream = null;
                    try {
                        objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                        object = objectInputStream.readObject();
                        if (!testFlags.isClear(1L)) break block18;
                        try {
                            Method method = object.getClass().getMethod("equals", Object.class);
                            if (method.getDeclaringClass() != t.getClass()) {
                                if (!t.getClass().isEnum()) {
                                    Tester.note("Object \"%s\" uses default \"equals\" method", t.getClass().getName());
                                }
                            } else {
                                Tester.testEquals(object, t, null);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            MLogger.exception(noSuchMethodException);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            Tester.warning("Could not deserialize \"%s\"", t.getClass().getName());
                            MLogger.exception(classNotFoundException);
                            ++failures;
                        }
                        catch (Throwable throwable) {
                            FS.close(objectInputStream);
                            throw throwable;
                        }
                        FS.close(objectInputStream);
                        break block19;
                    }
                }
                FS.close(objectInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                ++failures;
            }
            finally {
                FS.close(byteArrayOutputStream);
            }
        }
        return (T)object;
    }

    public static void testXMLDir(String string) {
        for (File file : FS.listFiles(new File(string.replace('/', File.separatorChar)), new FS.FileExtensionFilter("xml"))) {
            Tester.testXMLFile(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testXMLFile(String string) {
        Tester.info("\t\tTesting XML file: %s", string);
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            bufferedFileInput = new FS.BufferedFileInput(string.replace('/', File.separatorChar));
            xMLReader.parse(new InputSource(bufferedFileInput));
        }
        catch (Exception exception) {
            try {
                Tester.warning(exception.toString(), new Object[0]);
                ++failures;
            }
            catch (Throwable throwable) {
                FS.close(bufferedFileInput);
                throw throwable;
            }
            FS.close(bufferedFileInput);
        }
        FS.close(bufferedFileInput);
    }

    @Override
    protected void startup() {
        if (Args.count() == 0) {
            Tester.fatal("Please specify a full path to compiled test classes", new Object[0]);
        }
        Tester.info("Using JRE: %s", System.getProperty("java.runtime.version"));
        Tester.initLookAndFeel();
        MLogger.developer.set(true);
        pathToTest = System.getenv("MAKAGIGA_TEST_PATH");
        baseDir = new File(Args.get(Args.count() - 1));
        if (!baseDir.exists()) {
            Tester.fatal("\"%s\" directory does not exits", baseDir);
        }
        Tester.info("Testing directory: %s", baseDir);
        try {
            new FileScanner.Simple(baseDir){

                @Override
                public void processFile(File file) throws Exception {
                    if ("class".equals(FS.getExtension(file))) {
                        Tester.testClass(file);
                    }
                }
            };
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Tester.fatal(exception.toString(), new Object[0]);
        }
        if (!missingTests.isEmpty()) {
            System.err.println();
            System.err.println("WARNING: Missing tests:");
            int n = 0;
            for (Element element : missingTests) {
                if (element.innerClass != null && testedClasses.contains(element.innerClass)) continue;
                System.err.println("\t" + element);
                if (++n != 10 || n >= missingTests.size()) continue;
                System.err.printf("\t(%s more)\n", missingTests.size() - n);
                break;
            }
        }
        if (pathToTest == null) {
            System.err.println();
            Tester.info("HINT: Set \"MAKAGIGA_TEST_PATH\" environment variable to filter tests.", new Object[0]);
            Tester.info("      Example command: MAKAGIGA_TEST_PATH=commons/TestBoolean ant test", new Object[0]);
        }
        System.err.println();
        Tester.info("TOTAL TESTS: %d", testCount);
        Tester.info("   WARNINGS: %d", warnings);
        Tester.info("   FAILURES: %d", failures);
        Tester.quit();
    }

    private static void createElementList(Class<?> clazz) throws NoSuchMethodException {
        for (Class<?> annotatedElement : clazz.getDeclaredClasses()) {
            if (!Tester.isTestable(annotatedElement.getModifiers())) continue;
            elementList.add(new Element(annotatedElement));
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredConstructors()) {
            if (!Tester.isTestable(((Constructor)genericDeclaration).getModifiers())) continue;
            elementList.add(new Element((Constructor)genericDeclaration));
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (!Tester.isTestable(((Field)annotatedElement).getModifiers())) continue;
            elementList.add(new Element((Field)annotatedElement));
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredMethods()) {
            if (!Tester.isTestable(((Method)annotatedElement).getModifiers()) || clazz.isEnum() && (((Method)annotatedElement).getName().equals("values") && ((Method)annotatedElement).getParameterTypes().length == 0 || ((Method)annotatedElement).getName().equals("valueOf") && Arrays.equals(((Method)annotatedElement).getParameterTypes(), new Object[]{String.class}))) continue;
            elementList.add(new Element((Method)annotatedElement));
        }
    }

    private static boolean equals(String string, Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : classArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz.getSimpleName());
        }
        return string.equals(stringBuilder.toString());
    }

    private static void fail(String string) {
        throw new AssertionError((Object)string);
    }

    private static void fatal(String string, Object ... objectArray) {
        System.err.println("FATAL: " + String.format(string, objectArray));
        System.exit(1);
    }

    private static String getTestName(Method method, Test test) {
        String string = method.getName();
        if (string.startsWith("test_")) {
            string = string.substring("test_".length());
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = test.description();
        if (!string2.isEmpty()) {
            stringBuilder.append(" (").append(string2).append(')');
        }
        return stringBuilder.toString();
    }

    private static void info(String string, Object ... objectArray) {
        System.err.println("INFO: " + String.format(string, objectArray));
    }

    private static boolean isTestable(int n) {
        return Modifier.isProtected(n) || Modifier.isPublic(n);
    }

    private static void note(String string, Object ... objectArray) {
        System.err.println("NOTE: " + String.format(string, objectArray));
    }

    private static void printFilteredStackTrace(Throwable throwable) {
        StackTraceElement stackTraceElement;
        StringBuilder stringBuilder = new StringBuilder();
        System.err.println(throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && !(stackTraceElement = stackTraceElementArray[i]).getClassName().startsWith("sun.reflect.NativeMethodAccessorImpl"); ++i) {
            stringBuilder.append(' ');
            System.err.println(stringBuilder + stackTraceElement.toString());
        }
    }

    private static void testClass(File file) {
        elementList.clear();
        String string = file.getPath().substring(baseDir.getPath().length() + 1);
        if (pathToTest != null && !string.startsWith(pathToTest)) {
            return;
        }
        string = FS.getBaseName(string);
        if ((string = string.replace(File.separator, ".")).contains("$")) {
            return;
        }
        if (!string.contains("Test")) {
            Tester.info("Skipping %s...", string);
            return;
        }
        Tester.info("Testing %s...", string);
        URL[] uRLArray = new URL[]{FS.toURL(baseDir)};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        uRLClassLoader.setDefaultAssertionStatus(true);
        Object object = null;
        try {
            Method[] methodArray;
            Class<?> clazz = uRLClassLoader.loadClass(string);
            object = clazz.newInstance();
            Class<?> clazz2 = object.getClass();
            Test test = clazz2.getAnnotation(Test.class);
            if (test == null) {
                Tester.warning("Add \"Test\" annotation: %s", clazz.getName());
                testFlags = new Flags();
            } else {
                methodArray = test.className();
                testedClasses.add((Class<?>)methodArray);
                testFlags = new Flags(test.flags());
                if (methodArray == Object.class) {
                    Tester.warning("Please specify \"className\" attribute in \"Test\" annotation: %s", clazz.getName());
                } else {
                    if (methodArray != Ignore.class) {
                        Tester.info("\tClass: %s", methodArray.getName());
                    }
                    Tester.createElementList(methodArray);
                }
                Tester.updateMissingTests(test);
            }
            methodArray = clazz2.getDeclaredMethods();
            if (methodArray.length == 0) {
                Tester.warning("Nothing to test in \"%s\" class", clazz.getName());
            } else {
                for (Method method : methodArray) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    boolean bl = method.isAnnotationPresent(Ignore.class);
                    boolean bl2 = method.isAnnotationPresent(Test.class);
                    Test test2 = method.getAnnotation(Test.class);
                    if (bl && bl2) {
                        Tester.info("\t[Ignore] %s", Tester.getTestName(method, test2));
                        continue;
                    }
                    if (bl2) {
                        Class<?>[] classArray = method.getParameterTypes();
                        if (classArray.length > 0) {
                            Tester.warning("Method with \"Test\" annotation cannot have parameters (ignoring): %s", method.toGenericString());
                            continue;
                        }
                        try {
                            Tester.updateMissingTests(test2);
                            Tester.testMethod(object, method, test2);
                        }
                        catch (TestException testException) {
                            ++failures;
                            StackTraceElement[] stackTraceElementArray = testException.getCause().getStackTrace();
                            System.out.println();
                            System.out.println("*** FAILURE *** [" + stackTraceElementArray[0] + "]");
                            Tester.printFilteredStackTrace(testException.getCause());
                            System.out.println();
                            System.exit(1);
                        }
                        continue;
                    }
                    if (bl) continue;
                    Tester.warning("Missing \"Test\" annotation: %s.\nHint: Use \"Ignore\" annotation to suppress this warning.", method.toGenericString());
                }
                for (Element element : elementList) {
                    if (element.done) continue;
                    missingTests.add(element);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void testMethod(Object object, Method method, Test test) throws TestException {
        ++testCount;
        Tester.info("\t" + Tester.getTestName(method, test), new Object[0]);
        try {
            method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TestException(invocationTargetException.getCause(), method);
        }
        catch (Exception exception) {
            throw new TestException(exception, method);
        }
    }

    private static void updateMissingTests(Test test) {
        block0: for (TestConstructor annotation : test.constructors()) {
            for (Element element : elementList) {
                if (element.done || element.constructor == null || !Tester.equals(annotation.parameters(), element.constructor.getParameterTypes())) continue;
                element.done = true;
                continue block0;
            }
        }
        block2: for (Annotation annotation : test.fields()) {
            for (Element element : elementList) {
                if (element.done || element.field == null || !element.field.getName().equals(annotation.name())) continue;
                element.done = true;
                continue block2;
            }
        }
        block4: for (Annotation annotation : test.methods()) {
            for (Element element : elementList) {
                if (element.done || element.method == null || !element.method.getName().equals(annotation.name()) || !Tester.equals(annotation.parameters(), element.method.getParameterTypes())) continue;
                element.done = true;
                continue block4;
            }
        }
    }

    private static void warning(String string, Object ... objectArray) {
        ++warnings;
        System.err.println("WARNING: " + String.format(string, objectArray));
    }

    static {
        testFlags = new Flags();
        testedClasses = MArrayList.create();
        elementList = new MArrayList();
        missingTests = new MArrayList();
    }

    private static final class Element {
        private boolean done;
        private Class<?> innerClass;
        private Constructor<?> constructor;
        private Field field;
        private Method method;

        public String toString() {
            if (this.constructor != null) {
                return this.constructor.toString();
            }
            if (this.field != null) {
                return this.field.toString();
            }
            if (this.innerClass != null) {
                return this.innerClass.toString();
            }
            if (this.method != null) {
                return this.method.toString();
            }
            throw new WTFError("All null");
        }

        private Element(Class<?> clazz) {
            this.innerClass = clazz;
        }

        private Element(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        private Element(Field field) {
            this.field = field;
        }

        private Element(Method method) {
            this.method = method;
        }
    }

    public static interface Code {
        public void run() throws Throwable;
    }
}

