/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tabs;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.Config;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.AbstractTextEditor;
import org.makagiga.web.wiki.WikiPanel;

public class WikiTab
extends AbstractTextEditor<JTextComponent> {
    private PropertyChangeListener pcl;
    private WikiPanel wikiPanel;

    public WikiTab(WikiPanel wikiPanel) {
        super(wikiPanel.getViewer(), false);
        Serializable serializable;
        this.wikiPanel = wikiPanel;
        Config config = Config.getDefault();
        this.fontSize = config.readInt(Config.getPlatformKey("Wiki.font.size"), -1, 8, 128);
        if (this.fontSize != -1) {
            serializable = UI.getFont(this.core);
            ((JTextComponent)this.core).setFont(((Font)serializable).deriveFont((float)this.fontSize));
        }
        this.setMetaInfo("Wiki", MIcon.stock("ui/internet"));
        wikiPanel.getToolBar().setVisible(false);
        serializable = MScrollPane.getScrollPane((JComponent)this.core);
        if (serializable != null) {
            ((JComponent)serializable).setBorder(null);
        }
        this.addCenter(wikiPanel);
        wikiPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("pageTitle".equals(propertyChangeEvent.getPropertyName())) {
                    WikiTab.this.setTabTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    @Override
    public void focus() {
        ((JTextComponent)this.core).requestFocusInWindow();
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    public WikiPanel getWikiPanel() {
        return this.wikiPanel;
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.wikiPanel != null) {
            this.wikiPanel.removePropertyChangeListener(this.pcl);
            this.pcl = null;
            this.wikiPanel = TK.dispose(this.wikiPanel);
        }
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("EDIT_MENU")) {
            mMenu.add(MText.getAction((JTextComponent)this.core, "org.makagiga.commons.MText.copy"));
        } else if (string.equals("VIEW_MENU_EDITOR")) {
            this.wikiPanel.getActionGroup().updateMenu(mMenu);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if (string.equals("EDITOR_TOOL_BAR")) {
            this.wikiPanel.getActionGroup().updateToolBar(mToolBar);
            mToolBar.addSeparator();
            mToolBar.add(MText.getAction((JTextComponent)this.core, "org.makagiga.commons.MText.copy"));
        }
    }

    @Override
    protected void writeFontSize(Config config) {
        if (this.fontSize != -1) {
            config.write(Config.getPlatformKey("Wiki.font.size"), this.fontSize);
        }
    }
}

