/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLinkButton;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MTaskPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.VersionProperty;
import org.makagiga.ghns.GHNSDialog;
import org.makagiga.ghns.MirrorDialog;
import org.makagiga.ghns.Stuff;
import org.makagiga.ghns.StuffRenderer;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginInstaller;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginSettings;
import org.makagiga.plugins.PluginType;

public final class PluginDownloader
extends GHNSDialog {
    private boolean updateMode;
    private MAction hideInstalledAction;
    private MButton settingsButton;
    private static final Set<String> restartInfo = new HashSet<String>();
    private String mirror;
    private static URI defaultSource;

    public PluginDownloader(Window window, PluginType pluginType) {
        this(window, PluginDownloader.getDefaultSource(), pluginType);
    }

    public PluginDownloader(Window window, URI uRI, PluginType pluginType) {
        super(window, PluginManager.GET_MORE_PLUGINS_ACTION_INFO.getDialogTitle(), PluginManager.GET_MORE_PLUGINS_ACTION_INFO.getIcon(), 36, new Dimension(150, 100));
        Config config = Config.getDefault();
        this.mirror = config.read("Plugin.mirror", null);
        this.hideInstalledAction = new MAction(UI._("Hide Installed")){

            @Override
            public void onAction() {
                Config config = Config.getDefault();
                config.write("Plugin.hideInstalled", this.isSelected());
                config.sync();
                PluginDownloader.this.updateStuffList();
            }
        };
        this.hideInstalledAction.setSelected(config.read("Plugin.hideInstalled", false));
        for (PluginType pluginType2 : PluginType.values()) {
            this.setCategoryIcon(pluginType2.getType(), pluginType2.getSmallIcon());
            this.setCategoryText(pluginType2.getType(), pluginType2.toString());
        }
        this.getButtonsPanel().addContentGap();
        MLinkButton mLinkButton = new MLinkButton(URI.create("http://sourceforge.net/projects/makagiga"));
        mLinkButton.setIcon(MIcon.unscaled("sourceforgenet"));
        mLinkButton.setText(null);
        this.getButtonsPanel().add(mLinkButton);
        if (((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            this.getButtonsPanel().addContentGap();
            this.settingsButton = new MButton(MActionInfo.SETTINGS){

                @Override
                protected MMenu onPopupMenu() {
                    return PluginDownloader.this.onSettingsMenu();
                }
            };
            if (!((Boolean)UI.buttonIcons.get()).booleanValue()) {
                this.settingsButton.setIcon(null);
            }
            this.settingsButton.setPopupMenuEnabled(true);
            this.getButtonsPanel().add(this.settingsButton);
        }
        this.setSource(uRI);
        this.refresh(pluginType == null ? null : pluginType.getType());
    }

    public static URI getDefaultSource() {
        if (defaultSource == null) {
            return URI.create("http://makagiga.sourceforge.net/stuff.php?v3=1");
        }
        return defaultSource;
    }

    public static void setDefaultSource(URI uRI) {
        defaultSource = uRI;
    }

    public static void getMorePlugins(Window window, PluginType pluginType) {
        PluginDownloader pluginDownloader = new PluginDownloader(window, PluginDownloader.getDefaultSource(), pluginType);
        pluginDownloader.exec();
    }

    public static boolean install(Window window, URI uRI, final String string) {
        final BooleanProperty booleanProperty = new BooleanProperty(true);
        final PluginDownloader pluginDownloader = new PluginDownloader(window, uRI, null);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MTaskPanel mTaskPanel = (MTaskPanel)changeEvent.getSource();
                if (!mTaskPanel.isActive() && !mTaskPanel.isCancelled()) {
                    booleanProperty.set(pluginDownloader.startInstall(string));
                }
            }
        };
        pluginDownloader.taskPanel.addChangeListener(changeListener);
        pluginDownloader.exec();
        pluginDownloader.taskPanel.removeChangeListener(changeListener);
        return (Boolean)booleanProperty.get();
    }

    public static void update(Window window) {
        PluginDownloader.update(window, PluginDownloader.getDefaultSource());
    }

    public static void update(Window window, URI uRI) {
        final PluginDownloader pluginDownloader = new PluginDownloader(window, uRI, null);
        pluginDownloader.updateMode = true;
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MTaskPanel mTaskPanel = (MTaskPanel)changeEvent.getSource();
                if (!mTaskPanel.isActive() && !mTaskPanel.isCancelled()) {
                    pluginDownloader.startUpdate();
                }
            }
        };
        pluginDownloader.taskPanel.addChangeListener(changeListener);
        pluginDownloader.exec();
        pluginDownloader.taskPanel.removeChangeListener(changeListener);
    }

    @Override
    protected boolean filter(Stuff stuff) {
        if (!this.hideInstalledAction.isSelected()) {
            return true;
        }
        PluginInfo pluginInfo = PluginManager.getInstance().getByID("{" + stuff.getPluginID() + "}");
        if (pluginInfo == null) {
            return true;
        }
        return stuff.getPluginVersion() > (Integer)pluginInfo.version.get();
    }

    @Override
    protected String getDownloadURL(Stuff stuff) {
        String string = super.getDownloadURL(stuff);
        if (TK.isEmpty(this.mirror)) {
            MLogger.info("plugin", "Using \"%s\" download URL (no mirror)", string);
            return string;
        }
        if (string.startsWith("http://makagiga.sourceforge.net/download.php?")) {
            string = string + "&mirror=" + TK.escapeURL(this.mirror);
            MLogger.info("plugin", "Using \"%s\" download URL (mirror: %s)", string, this.mirror);
        }
        return string;
    }

    @Override
    protected boolean onConfirmInstall(Stuff stuff) {
        if (!this.isCompatible(stuff)) {
            String string = TK.escapeXML(stuff.getLocalizedName());
            String string2 = TK.escapeXML(MApplication.getFullName() + " " + new VersionProperty(stuff.getPluginRequires()) + "+");
            if (!MMessage.customConfirm(this, MIcon.stock("ui/warning"), MActionInfo.INSTALL, null, UI.makeHTML(UI._("It seems that the selected item is not compatible<br>with your Makagiga version.<br><br>{0} requires {1}", "<b>" + string + "</b>", "<b>" + string2 + "</b>")))) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onInstall(Stuff stuff, File file) {
        try {
            PluginInstaller.install(this, file, this.updateMode ? 2 : 0);
            if (!this.updateMode) {
                PluginSettings.showRestartInfo();
            }
            restartInfo.add(stuff.getLocalizedPayload());
        }
        catch (PluginException pluginException) {
            MMessage.error((Window)this, pluginException);
        }
        finally {
            file.delete();
        }
    }

    @Override
    protected void onRender(StuffRenderer<Stuff> stuffRenderer, Stuff stuff) {
        String string = "font-weight: bold";
        if (restartInfo.contains(stuff.getLocalizedPayload())) {
            stuffRenderer.setStatus(MApplication.getRestartMessage(), MColor.DARK_RED, string);
        } else {
            PluginInfo pluginInfo = PluginManager.getInstance().getByID("{" + stuff.getPluginID() + "}");
            if (pluginInfo == null) {
                if (this.isCompatible(stuff)) {
                    stuffRenderer.setStatus(UI._("Available"), MColor.GRAY, "font-weight: normal");
                } else {
                    stuffRenderer.setStatus(UI._("Incompatible"), MColor.DARK_RED, string);
                }
            } else if (stuff.getPluginVersion() > (Integer)pluginInfo.version.get()) {
                String string2 = pluginInfo.version.toString();
                String string3 = new VersionProperty(stuff.getPluginVersion()).toString();
                stuffRenderer.setStatus(UI._("Update available: {0}", string2 + " -> " + string3), MColor.DARK_RED, string);
            } else {
                stuffRenderer.setStatus(UI._("Installed"), MColor.DARK_GREEN, string);
            }
        }
    }

    @Override
    protected MMenu onSettingsMenu() {
        Config config = Config.getDefault();
        MMenu mMenu = super.onSettingsMenu();
        mMenu.addCheckBox(this.hideInstalledAction);
        MAction mAction = new MAction(UI._("Select a mirror server...")){

            @Override
            public void onAction() {
                PluginDownloader.this.showMirrorChooser();
            }
        };
        if (!config.read("Plugin.mirrorSelected", false)) {
            mAction.setIconName("ui/warning");
        }
        mMenu.add(mAction);
        return mMenu;
    }

    private void disableComponents() {
        this.category.setEnabled(false);
        this.searchPanel.getTextField().setEnabled(false);
        if (this.settingsButton != null) {
            this.settingsButton.setEnabled(false);
        }
        this.getUserButton().setEnabled(false);
    }

    private boolean isCompatible(Stuff stuff) {
        VersionProperty versionProperty = new VersionProperty(stuff.getPluginRequires());
        return (Integer)versionProperty.get() == 0 || PluginInfo.isCompatible(versionProperty);
    }

    private void showMirrorChooser() {
        MirrorDialog mirrorDialog = new MirrorDialog((Window)this);
        mirrorDialog.addGroup("Asia").add("Biznet Networks, Indonesia", "biznetnetworks").add("CDNetworks #1, Seoul, Korea", "cdnetworks-kr-1").add("CDNetworks #2, Seoul, Korea", "cdnetworks-kr-2").add("Japan Advanced Institute of Science and Technology, Ishikawa, Japan", "jaist").add("National Center for High-Performance Computing, Tainan, Taiwan", "nchc").add("National Central University, Taiwan", "ncu");
        mirrorDialog.addGroup("Central Asia").add("SPACE.KZ, Almaty, Kazakhstan", "space");
        mirrorDialog.addGroup("Australia").add("Internode, Adelaide", "internode").add("Transact, Canberra", "transact").add("WAIX, Perth", "waix");
        mirrorDialog.addGroup("Europe").add("DFN: German Research Network, Berlin, Germany", "dfn").add("Free France, France", "freefr").add("garr.it, Bologna, Italy", "garr").add("HEAnet, Dublin, Ireland", "heanet").add("Ignum, Prague, Czech Republic", "ignum").add("Mesh Solutions, Duesseldorf, Germany", "mesh").add("OVH, Paris, France", "ovh").add("SURFnet, Amsterdam, The Netherlands", "surfnet").add("Swedish University Computer Network, Sweden", "sunet").add("SWITCH, Lausanne, Switzerland", "switch").add("University of Kent, Kent, UK", "kent");
        mirrorDialog.addGroup("North America").add("CDNetworks #1, San Jose, CA, USA", "cdnetworks-us-1").add("CDNetworks #2, San Jose, CA, USA", "cdnetworks-us-2").add("Hivelocity, Tampa, FL, USA", "hivelocity").add("Internap Network Services, San Jose, CA, USA", "internap").add("iWeb Technologies, Quebec, Canada", "iweb").add("Softlayer, Plano, TX", "softlayer").add("Superb Internet, McLean, VA, USA", "superb-east").add("Superb Internet, Seattle, WA, USA", "superb-west").add("Voxel, New York, NY, USA", "voxel");
        mirrorDialog.addGroup("South America").add("Centro de Computacao Cientifica e Software Livre, Curitiba, Brazil", "ufpr");
        mirrorDialog.getModel().reload();
        if (this.mirror != null) {
            mirrorDialog.setSelectedServer(new MirrorDialog.Server(this.mirror));
        }
        if (mirrorDialog.exec()) {
            Config config = Config.getDefault();
            config.write("Plugin.mirrorSelected", true);
            MirrorDialog.Server server = mirrorDialog.getSelectedServer();
            if (server != null) {
                this.mirror = server.getPrefix();
                config.write("Plugin.mirror", this.mirror);
            }
            config.sync();
        }
    }

    private boolean startInstall(String string) {
        boolean bl = true;
        this.disableComponents();
        for (Stuff stuff : this.allStuff) {
            if (!this.isCompatible(stuff) || !string.equals("{" + stuff.getPluginID() + "}")) continue;
            try {
                MLogger.info("plugin", "Installing: %s", stuff.getLocalizedName());
                this.stuffList.setSelectedItem(stuff, true);
                this.install(stuff);
                this.stuffList.repaintItem(stuff);
            }
            catch (IOException iOException) {
                MMessage.error((Window)this, iOException);
                bl = false;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpdate() {
        MLogger.info("plugin", "Start update");
        MArrayList<String> mArrayList = new MArrayList<String>();
        this.disableComponents();
        try {
            UI.setWaitCursor(this, true);
            for (Serializable serializable : this.allStuff) {
                PluginInfo pluginInfo = PluginManager.getInstance().getByID("{" + ((Stuff)serializable).getPluginID() + "}");
                if (pluginInfo == null || !this.isCompatible((Stuff)serializable) || ((Stuff)serializable).getPluginVersion() <= (Integer)pluginInfo.version.get()) continue;
                try {
                    MLogger.info("plugin", "Updating: %s", pluginInfo);
                    this.stuffList.setSelectedItem(serializable, true);
                    if (!((Boolean)pluginInfo.enabled.get()).booleanValue()) {
                        MLogger.info("plugin", "Skipping disabled plugin: %s", pluginInfo);
                        continue;
                    }
                    this.install((Stuff)serializable);
                    this.stuffList.repaintItem(serializable);
                    mArrayList.add(((Stuff)serializable).getLocalizedName() + " " + pluginInfo.version + " -> " + ((Stuff)serializable).getVersion());
                }
                catch (IOException iOException) {
                    MMessage.error((Window)this, iOException);
                    UI.setWaitCursor(this, false);
                    MLogger.info("plugin", "End update");
                    return;
                }
            }
        }
        finally {
            UI.setWaitCursor(this, false);
            MLogger.info("plugin", "End update");
        }
        if (mArrayList.isEmpty()) {
            MMessage.info(this, UI._("No new updates"));
        } else {
            Serializable serializable;
            MList<Object> mList = MMessage.createListView(PluginManager.UPDATE_PLUGINS_ACTION_INFO.getIcon(), mArrayList.toArray());
            serializable = new MDialog((Window)this, MApplication.getRestartMessage(), PluginManager.UPDATE_PLUGINS_ACTION_INFO.getIconName(), 36);
            ((MDialog)serializable).addNorth(MLabel.createFor(mList, UI._("Updated Plugins:")));
            ((MDialog)serializable).addCenter(mList);
            ((MDialog)serializable).packFixed();
            ((MDialog)serializable).exec();
        }
        this.reject();
    }
}

