/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Image;
import java.awt.Window;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;
import org.makagiga.commons.Config;
import org.makagiga.commons.Item;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MainView;
import org.makagiga.commons.SafeMode;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.plugins.CustomColorSettings;
import org.makagiga.plugins.LookAndFeelPlugin;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.plugins.PluginSettings;
import org.makagiga.plugins.PluginType;

public final class LookAndFeelSettings
extends MSettingsPage {
    public static final String DEFAULT = "DEFAULT";
    public static final String JAVA = "JAVA";
    public static final String NIMBUS = "NIMBUS";
    public static final String SYSTEM = "SYSTEM";
    private LAFInfo lookAndFeelInfo;
    private int iconSizeOriginal;
    private MButton configureButton;
    private MComboBox<LAFInfo> installedLookAndFeels;
    private MComboBox<Item<Integer>> iconSize;

    public LookAndFeelSettings() {
        super(UI._("Look and Feel"), "labels/emotion/happy");
    }

    @SafeMode
    public static void applyLookAndFeel() {
        LookAndFeelSettings.applyLookAndFeel(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onInit() {
        Object object222;
        this.installedLookAndFeels = new MComboBox<LAFInfo>(){

            @Override
            protected void onSelect() {
                LookAndFeelSettings.this.updateLookAndFeelComponents();
            }
        };
        this.installedLookAndFeels.setRenderer(LAFInfo.createListCellRenderer());
        boolean bl = false;
        if (UI.isNimbusLookAndFeelAvailable()) {
            bl = true;
            this.installedLookAndFeels.addItem((LAFInfo)new LAFInfo("(Nimbus)", NIMBUS));
        }
        this.installedLookAndFeels.addItem((LAFInfo)new LAFInfo("(Metal - Ocean Theme)", JAVA));
        for (Object object222 : PluginType.LOOK_AND_FEEL.get()) {
            LookAndFeelPlugin lookAndFeelPlugin = (LookAndFeelPlugin)((PluginInfo)object222).getPluggable();
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelPlugin.getLookAndFeelInfo();
            if (lookAndFeelInfo == null) continue;
            LAFInfo lAFInfo = new LAFInfo(lookAndFeelInfo, true);
            lAFInfo.pluginInfo = (PluginInfo)object222;
            this.installedLookAndFeels.addItem((LAFInfo)lAFInfo);
        }
        this.installedLookAndFeels.addItem((LAFInfo)new LAFInfo("(" + UI._("System") + ")", SYSTEM));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (UIManager.LookAndFeelInfo object3 : lookAndFeelInfoArray) {
            if (UI.isBlacklisted(object3.getClassName()) || bl && "Nimbus".equals(object3.getName())) continue;
            this.installedLookAndFeels.addItem((LAFInfo)new LAFInfo(object3));
        }
        this.installedLookAndFeels.sort();
        this.configureButton = new MButton(MActionInfo.SETTINGS){

            @Override
            protected void onClick() {
                LookAndFeelSettings.this.configureLAF(this.getWindowAncestor());
            }
        };
        this.configureButton.setToolTipText(this.configureButton.getText());
        this.configureButton.setText(null);
        this.updateLookAndFeelComponents();
        object222 = MPanel.createHLabelPanel(this.installedLookAndFeels, UI._("Look and Feel:"));
        ((MPanel)object222).addEast(this.configureButton);
        this.add((JComponent)object222);
        this.addContentGap();
        this.iconSize = new MComboBox();
        this.iconSize.setRenderer(Item.createListCellRenderer());
        for (int i = 16; i < 56; i += 8) {
            Item<Integer> item = new Item<Integer>(i, i + "x" + i);
            item.setIcon(MIcon.stock("ui/folder", i));
            this.iconSize.addItem(item);
        }
        this.add(MPanel.createHLabelPanel(this.iconSize, UI._("Icon Size:")));
        this.addContentGap();
        MURLButton mURLButton = new MURLButton(){

            @Override
            protected void onClick() {
                PluginDownloader.getMorePlugins(LookAndFeelSettings.this.getParentWindow(), PluginType.LOOK_AND_FEEL);
            }
        };
        PluginManager.setupGetMorePluginsButton(mURLButton);
        this.add(mURLButton);
        this.lookAndFeelInfo = LookAndFeelSettings.readLAFInfo();
        if (!this.lookAndFeelInfo.isNull()) {
            for (LAFInfo lAFInfo : this.installedLookAndFeels) {
                if (!((String)lAFInfo.getValue()).equals(this.lookAndFeelInfo.getValue()) && (!UI.isNimbus() || !NIMBUS.equals(lAFInfo.getValue()))) continue;
                this.installedLookAndFeels.setSelectedItem(lAFInfo);
                break;
            }
        }
        int n = 0;
        Object var8_15 = null;
        for (Item<Integer> item : this.iconSize) {
            if (item.getValue().equals(UI.iconSize.get())) {
                this.iconSize.setSelectedItem(item);
                n = 1;
                continue;
            }
            if (item.getValue() != MIcon.getDefaultSize()) continue;
            Item<Integer> item2 = item;
        }
        if (n == 0) {
            void var8_16;
            this.iconSize.setSelectedItem(var8_16);
        }
        this.iconSizeOriginal = this.iconSize.getSelectedItem().getValue();
        this.addSeparator(UI._("Buttons"));
        this.bind(UI.buttonIcons, UI._("Show Button Icons"));
        this.bind(UI.okCancelLayout, UI._("\"OK/Cancel\" Buttons Layout:"));
    }

    @Override
    protected void onOK() {
        LAFInfo lAFInfo = this.installedLookAndFeels.getSelectedItem();
        if (!((String)lAFInfo.getValue()).equals(this.lookAndFeelInfo.getValue())) {
            Config config = Config.getDefault();
            LookAndFeelSettings.writeLAFConfig(config, (String)lAFInfo.getValue(), lAFInfo.plugin);
            this.setNeedRestart(true);
            if (MLogger.isDeveloper()) {
                LookAndFeelSettings.applyLookAndFeel(lAFInfo);
                UI.update();
            }
        }
        int n = this.iconSize.getSelectedItem().getValue();
        UI.iconSize.set(n);
        if (n != this.iconSizeOriginal) {
            MIcon.Cache.getInstance().clear();
            this.setNeedRestart(true);
        }
    }

    private static void applyLookAndFeel(LAFInfo lAFInfo) {
        LAFInfo lAFInfo2 = lAFInfo;
        if (lAFInfo2 == null) {
            lAFInfo2 = LookAndFeelSettings.readLAFInfo();
        }
        if (((String)lAFInfo2.getValue()).equals(DEFAULT)) {
            Config config = Config.getDefault();
            config.write(Config.getPlatformKey("UI.lookAndFeel"), (String)lAFInfo2.getValue());
            config.write(Config.getPlatformKey("UI.lookAndFeelPlugin"), lAFInfo2.plugin);
        } else {
            JDialog.setDefaultLookAndFeelDecorated(false);
            MFrame.setDefaultLookAndFeelDecorated(false);
            LAFInfo lAFInfo3 = lAFInfo2;
            try {
                if (TK.isEmpty((String)lAFInfo3.getValue()) || ((String)lAFInfo3.getValue()).equals(JAVA)) {
                    LookAndFeelSettings.setMetalLookAndFeel(new OceanTheme());
                } else if (((String)lAFInfo3.getValue()).equals(NIMBUS)) {
                    if (!UI.setNimbusLookAndFeel()) {
                        LookAndFeelSettings.setMetalLookAndFeel(new OceanTheme());
                    }
                } else if (((String)lAFInfo3.getValue()).equals(SYSTEM)) {
                    lAFInfo3.setValue(UI.getPreferredLookAndFeelClassName());
                    if (((String)lAFInfo3.getValue()).contains("MetalLookAndFeel")) {
                        LookAndFeelSettings.setMetalLookAndFeel(new OceanTheme());
                    } else {
                        UI.setLookAndFeel((String)lAFInfo3.getValue());
                    }
                } else if (((String)lAFInfo3.getValue()).contains("MetalLookAndFeel")) {
                    LookAndFeelSettings.setMetalLookAndFeel(new DefaultMetalTheme());
                } else if (lAFInfo3.plugin) {
                    LookAndFeelPlugin lookAndFeelPlugin = LookAndFeelSettings.findPluginForClassName((String)lAFInfo3.getValue());
                    if (lookAndFeelPlugin != null) {
                        UI.setLookAndFeel(lookAndFeelPlugin.create());
                    }
                } else {
                    UI.setLookAndFeel((String)lAFInfo3.getValue());
                }
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                MLogger.error("core", "Could not apply LAF: abstractInfo=\"%s\", realInfo=\"%s\"", lAFInfo2.getValue(), lAFInfo3.getValue());
                LookAndFeelSettings.setMetalLookAndFeel(new OceanTheme());
            }
        }
    }

    private void configureLAF(Window window) {
        LookAndFeelPlugin lookAndFeelPlugin = this.getSelectedPlugin();
        if (lookAndFeelPlugin != null) {
            PluginSettings.showPluginOptionsDialog(window, 1024, lookAndFeelPlugin.getInfo());
        } else if (NIMBUS.equals(this.installedLookAndFeels.getSelectedItem().getValue())) {
            this.configureNimbus(window);
        }
    }

    private void configureNimbus(Window window) {
        CustomColorSettings customColorSettings = new CustomColorSettings();
        if (customColorSettings.exec(window)) {
            if (!((Boolean)UI.useCustomColor.get()).booleanValue()) {
                UI.customColor.set(UI.customColor.getDefaultValue());
            }
            UI.initCustomColor(UIManager.getDefaults());
            UI.update();
            this.setNeedRestart(true);
        }
    }

    private static LookAndFeelPlugin findPluginForClassName(String string) {
        for (PluginInfo pluginInfo : PluginType.LOOK_AND_FEEL.get()) {
            LookAndFeelPlugin lookAndFeelPlugin = (LookAndFeelPlugin)pluginInfo.getPluggable();
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelPlugin.getLookAndFeelInfo();
            if (lookAndFeelInfo == null || !lookAndFeelInfo.getClassName().equals(string)) continue;
            return lookAndFeelPlugin;
        }
        return null;
    }

    private LookAndFeelPlugin getSelectedPlugin() {
        LAFInfo lAFInfo = this.installedLookAndFeels.getSelectedItem();
        return lAFInfo == null ? null : LookAndFeelSettings.findPluginForClassName((String)lAFInfo.getValue());
    }

    private PluginOptions<?> getSelectedPluginOptions() {
        LookAndFeelPlugin lookAndFeelPlugin = this.getSelectedPlugin();
        return lookAndFeelPlugin instanceof PluginOptions ? (PluginOptions)((Object)lookAndFeelPlugin) : null;
    }

    private static LAFInfo readLAFInfo() {
        String string = UI.getPreferredLookAndFeelClassName();
        if ("javax.swing.plaf.metal.MetalLookAndFeel".equals(string)) {
            string = JAVA;
        }
        Config config = Config.getDefault();
        String string2 = config.read(Config.getPlatformKey("UI.lookAndFeel"), string);
        boolean bl = config.read(Config.getPlatformKey("UI.lookAndFeelPlugin"), false);
        return new LAFInfo(null, string2, bl);
    }

    private static boolean setMetalLookAndFeel(MetalTheme metalTheme) {
        try {
            MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
            MetalLookAndFeel.setCurrentTheme(metalTheme);
            UI.setLookAndFeel(metalLookAndFeel);
            return true;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return false;
        }
    }

    private void updateLookAndFeelComponents() {
        if (this.configureButton != null) {
            this.configureButton.setEnabled((Boolean)Kiosk.actionSettings.get() != false && (this.getSelectedPluginOptions() != null || NIMBUS.equals(this.installedLookAndFeels.getSelectedItem().getValue())));
        }
    }

    static void writeLAFConfig(Config config, String string, boolean bl) {
        config.write(Config.getPlatformKey("UI.lookAndFeel"), string);
        config.write(Config.getPlatformKey("UI.lookAndFeelPlugin"), bl);
    }

    private static final class LAFInfo
    extends Item<String>
    implements Comparable<Item<String>> {
        private final boolean plugin;
        private PluginInfo pluginInfo;

        public LAFInfo(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName(), false);
        }

        public LAFInfo(UIManager.LookAndFeelInfo lookAndFeelInfo, boolean bl) {
            this(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName(), bl);
        }

        public LAFInfo(String string, String string2) {
            this(string, string2, false);
        }

        public LAFInfo(String string, String string2, boolean bl) {
            super(string2, string);
            this.plugin = bl;
        }

        @Override
        public int compareTo(Item<String> item) {
            return this.getText().compareTo(item.getText());
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Image image = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(this.getValue()) ? this.getInternalPreview("gtk") : (LookAndFeelSettings.JAVA.equals(this.getValue()) ? this.getInternalPreview("metal") : (LookAndFeelSettings.NIMBUS.equals(this.getValue()) ? this.getInternalPreview("nimbus") : (this.pluginInfo != null ? this.pluginInfo.getPreviewImage() : null)));
                if (image != null) {
                    image = UI.scaleImage(image, -1, 56, UI.Quality.MEDIUM);
                    this.icon = new MIcon(image);
                } else {
                    this.icon = MIcon.stock("ui/question");
                }
            }
            return this.icon;
        }

        private Image getInternalPreview(String string) {
            try {
                return ImageIO.read(this.getClass().getResourceAsStream("preview-" + string + ".png"));
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                return null;
            }
        }
    }

    public static final class Advanced
    extends MSettingsPage {
        public Advanced() {
            super(UI._("Look and Feel"), "labels/emotion/happy");
            this.bind(UI.animations, UI._("Animations"));
            this.bind(UI.mouseGestures, UI._("Mouse Gestures"));
            this.addSeparator(UI._("Font"));
            this.bind(UI.useCustomFont, UI._("Use Custom Font:"));
            this.addGap();
            this.bind(UI.customFont, null);
            this.bind(UI.useCustomFont, "selected", UI.customFont, "enabled");
        }

        @Override
        protected void onOK() {
            UI.OKCancelLayout.setupUI(UIManager.getDefaults());
            this.setNeedRestart(true);
            Window window = MainView.getWindow();
            if (window != null) {
                window.repaint();
            }
        }
    }
}

