/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Locale;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.plugins.AbstractPlugin;

public abstract class LocalePlugin
extends AbstractPlugin<Object> {
    private final Locale locale;

    public LocalePlugin(Locale locale) {
        this.locale = TK.checkNull(locale, "locale");
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized InputStream getSpellDictionary(Locale locale) {
        File file = this.getSpellDictionaryFile(locale);
        if (file == null || !file.exists()) {
            MLogger.warning("locale", "Spell dictionary not found: %s", file);
            return null;
        }
        try {
            return new FS.BufferedFileInput(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MLogger.warning("locale", "Spell dictionary not found: %s", file);
            return null;
        }
    }

    public synchronized File getSpellDictionaryFile(Locale locale) {
        File file = this.getResourceFile(locale.getLanguage() + "_" + locale.getCountry() + ".dic");
        if (file.exists()) {
            return file;
        }
        file = this.getResourceFile(locale.getLanguage() + ".dic");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

