/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMessage;
import org.makagiga.plugins.Pluggable;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginClassLoader;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginPermission;
import org.makagiga.plugins.PluginType;

public abstract class AbstractPlugin<T>
implements Config.GlobalEntry,
Pluggable {
    private Config config;
    private DefaultAction _defaultAction;
    private File dataDirectory;
    private File resourcesDirectory;
    private static HashSet<String> updatedSystemClassPath = new HashSet();
    private PluginInfo info;

    @Deprecated
    public boolean canImport(Transferable transferable, TransferHandler.DropLocation dropLocation) {
        return false;
    }

    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return false;
    }

    @Deprecated
    public boolean importData(Transferable transferable, TransferHandler.DropLocation dropLocation) {
        return false;
    }

    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        return false;
    }

    public T create() throws Exception {
        return null;
    }

    public static <T> T createByID(String string, PluginType pluginType) throws Exception {
        for (PluginInfo pluginInfo : pluginType.get()) {
            if (!pluginInfo.getID().equals(string)) continue;
            return (T)pluginInfo.getPlugin().create();
        }
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public synchronized File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = FS.makeConfigFile(this.getInfo().getID(), 1);
        }
        return this.dataDirectory;
    }

    @Override
    public String getGlobalEntry(String string) {
        return string + "." + this.info.getID();
    }

    public MIcon getIcon() {
        return this.info.getIcon();
    }

    public PluginInfo getInfo() {
        return this.info;
    }

    public final String getName() {
        return (String)this.info.name.get();
    }

    public File getResourceFile(String string) {
        return new File(this.getResourcesDirectory(), string);
    }

    public synchronized File getResourcesDirectory() {
        if (this.resourcesDirectory == null) {
            this.resourcesDirectory = new File(this.getInfo().getPath(), "resources");
        }
        return this.resourcesDirectory;
    }

    public MIcon getSmallIcon() {
        return this.info.getSmallIcon();
    }

    @Override
    public void onDestroy() throws PluginException {
    }

    @Override
    public void onInit(Config config, PluginInfo pluginInfo) throws PluginException {
        this.config = config;
        this.info = pluginInfo;
    }

    @Override
    public void onPostInit() throws PluginException {
    }

    @Deprecated
    protected void addSelfToSystemClassPath() throws Exception {
        if (this.getInfo().isInternal()) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader;
            for (URL uRL : pluginClassLoader.getURLs()) {
                File file = new File(uRL.toURI());
                if ("i18n.jar".equals(file.getName())) continue;
                AbstractPlugin.addToSystemClassPath(uRL);
            }
        }
    }

    protected synchronized PluginAction getDefaultAction() {
        if (this._defaultAction == null) {
            this._defaultAction = new DefaultAction(this.getInfo());
        }
        return this._defaultAction;
    }

    protected void initStandaloneWindow(MMainWindow mMainWindow, PluginInfo pluginInfo, JComponent jComponent) throws Exception {
    }

    protected static void launchStandaloneApplication(String[] stringArray, Class<? extends AbstractPlugin<?>> clazz) {
        try {
            if (MApplication.isInitialized()) {
                throw new IllegalStateException("Application already initialized");
            }
            StandaloneApplication.init(stringArray);
        }
        catch (Exception exception) {
            MMessage.error(null, exception);
        }
    }

    protected void onDefaultAction(PluginAction pluginAction) {
    }

    static synchronized void addToSystemClassPath(final URL uRL) throws Exception {
        String string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PluginPermission(uRL.toString(), "addToSystemClassPath"));
        }
        if (updatedSystemClassPath.contains(string = uRL.getPath())) {
            MLogger.info("core", "\"%s\" already in system class path", string);
            return;
        }
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)uRLClassLoader, uRL);
                return null;
            }
        });
        updatedSystemClassPath.add(string);
        MLogger.info("core", "Added \"%s\" to the system class path", string);
    }

    private static final class StandaloneApplication
    extends MApplication {
        private StandaloneApplication() {
        }

        @Override
        protected boolean onQuit() {
            if (super.onQuit()) {
                PluginManager.shutDown();
                return true;
            }
            return false;
        }

        @Override
        protected void startup() {
            StandaloneApplication.initLookAndFeel();
            try {
                PluginInfo pluginInfo = (PluginInfo)PluginManager.getTable().first();
                AbstractPlugin<?> abstractPlugin = pluginInfo.getPlugin();
                Object obj = abstractPlugin.create();
                if (!(obj instanceof JComponent)) {
                    throw new PluginException("Could not create plugin component");
                }
                StandaloneApplication.setLogo(pluginInfo.getIcon().getImage());
                MMainWindow mMainWindow = new MMainWindow();
                mMainWindow.setMinimumSize(new Dimension(32, 32));
                mMainWindow.setTitle(pluginInfo.toString());
                abstractPlugin.initStandaloneWindow(mMainWindow, pluginInfo, (JComponent)obj);
                abstractPlugin.onPostInit();
                mMainWindow.setVisible(true);
            }
            catch (Exception exception) {
                MMessage.error(null, exception);
                StandaloneApplication.quit();
            }
        }

        private static <P extends AbstractPlugin<?>> void init(String[] stringArray) {
            StandaloneApplication.init(stringArray, "makagiga-plugin", StandaloneApplication.class);
            if (!StandaloneApplication.checkOneInstance()) {
                return;
            }
            MLogger.developer.set(true);
            StandaloneApplication.initPlatform(EnumSet.of(MApplication.Init.AUTHENTICATOR, MApplication.Init.PROXY, MApplication.Init.USER_AGENT));
            PluginManager.init();
            PluginManager.getTable().clear();
            PluginManager.getInstance().registerExternal(FS.getBaseDir(), 4);
            new StandaloneApplication();
        }
    }

    private final class DefaultAction
    extends PluginAction {
        @Override
        public void onAction() {
            AbstractPlugin.this.onDefaultAction(this);
        }

        private DefaultAction(PluginInfo pluginInfo) {
            super(pluginInfo);
        }
    }
}

