/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.pim;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.makagiga.commons.FS;

public final class PIMUtils {
    public static final String EOL = "\r\n";

    public static String escapeText(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.5));
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case ';': {
                    stringBuilder.append("\\;");
                    continue block7;
                }
                case ',': {
                    stringBuilder.append("\\,");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private PIMUtils() {
    }

    static final class FoldedWriter
    extends FilterWriter {
        private boolean folded;
        private static final int MAX_LINE_LENGTH = 75;
        private int lineLength;

        @Override
        public void write(int n) throws IOException {
            if (this.folded && this.lineLength == 0) {
                this.out.write(32);
                ++this.lineLength;
            }
            this.out.write(n);
            if (n == 13 || n == 10) {
                this.folded = false;
                this.lineLength = 0;
            } else {
                ++this.lineLength;
            }
            if (this.lineLength == 75) {
                this.folded = true;
                this.out.write(PIMUtils.EOL);
                this.lineLength = 0;
            }
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = n; i < n2; ++i) {
                this.write(cArray[i]);
            }
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            for (int i = n; i < n2; ++i) {
                this.write(string.charAt(i));
            }
        }

        FoldedWriter(OutputStream outputStream) throws IOException {
            super(FS.getUTF8Writer(outputStream));
        }
    }
}

