/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.internetsearch;

import java.awt.Window;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.xml.bind.JAXBException;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Item;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDownloadDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MWebBrowserPanel;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.Net;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.internetsearch.InternetSearchPlugin;
import org.makagiga.internetsearch.OpenSearchDescription;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginType;

public final class InternetSearchPanel
extends MSearchPanel {
    private final KeyStroke showEngineMenuKeyStroke;
    private final MAction exactPhraseAction;
    private final MAction okAction;
    private final MAction saveCustomSearchAction;
    private final MArrayList<CustomSearch> customSearchCache = new MArrayList();
    private final MSmallButton engineButton;
    private final MSmallButton okButton;
    private PluginInfo engine;

    public InternetSearchPanel() {
        super(true, MSearchPanel.Type.SEARCH);
        int n;
        Object object;
        this.setAutoCompletion("internetsearch");
        this.getAutoCompletion().setShowPopupOnUpDownKeyPress(false);
        this.getMenuButton().setToolTipText(UI._("Options"));
        this.getMenuButton().setVisible(true);
        MHighlighter.install(this.getTextField(), new Highligther());
        MWhatsThis.set(this, UI._("Internet Search")).setKeyStroke(75, MAction.getMenuMask());
        this.showEngineMenuKeyStroke = KeyStroke.getKeyStroke(40, 8);
        MAction mAction = new MAction("InternetSearchPanel.showEngineMenuAction"){

            @Override
            public void onAction() {
                InternetSearchPanel.this.engineButton.doPopupMenu();
            }
        };
        mAction.setAcceleratorKey(this.showEngineMenuKeyStroke);
        mAction.connect((JComponent)this.getTextField(), 0);
        this.exactPhraseAction = new MAction(UI._("Exact Phrase"), 80, 2){

            @Override
            public void onAction() {
                InternetSearchPanel.this.toggleExactPhrase();
            }
        };
        this.exactPhraseAction.connect((JComponent)this.getTextField(), 0);
        this.saveCustomSearchAction = new MAction(MActionInfo.SAVE){

            @Override
            public void onAction() {
                InternetSearchPanel.this.addCustomSearch();
            }
        };
        this.saveCustomSearchAction.connect((JComponent)this.getTextField(), 0);
        this.engineButton = this.createEngineButton();
        this.addWest(this.engineButton);
        if (Beans.isDesignTime()) {
            this.setEngine((PluginInfo)null);
        } else {
            object = new String[]{"{1e28e34d-8b71-4f90-8a7d-fc6b37dc7adb}", "{85ba965b-b1ab-43a0-8dd3-9448f6c7d0a4}"};
            String string = object[new Random().nextInt(((String[])object).length)];
            this.setEngine(Config.getDefault().read("InternetSearch.last", string));
        }
        this.okAction = new MAction(UI._("Search"), "ui/ok"){

            @Override
            public void onAction() {
                try {
                    InternetSearchPanel.this.search(MWebBrowserPanel.getUseInternalBrowser());
                }
                catch (PluginException pluginException) {
                    MMessage.error(null, pluginException);
                }
            }
        };
        this.okButton = new MSmallButton(this.okAction, false);
        this.getButtonPanel().add(this.okButton);
        this.setEnterPressAction(this.okAction);
        this.updateActions();
        if (!Beans.isDesignTime() && (n = ((Config)(object = InternetSearchPlugin.getSharedConfig())).readInt("count", 0, 0, Integer.MAX_VALUE)) > 0) {
            for (int i = 0; i < n; ++i) {
                CustomSearch customSearch = new CustomSearch(((Config)object).read(i + ".engine", null), ((Config)object).read(i + ".text", null));
                if (customSearch.isNull()) continue;
                this.customSearchCache.add(customSearch);
            }
        }
    }

    public MButton getOKButton() {
        return this.okButton;
    }

    public void search(boolean bl) throws PluginException {
        this.saveAutoCompletion();
        if (this.engine == null) {
            throw new PluginException(UI._("No plugin"));
        }
        InternetSearchPanel.search(this.engine, this.getText(), bl);
    }

    public static void search(PluginInfo pluginInfo, String string, boolean bl) throws PluginException {
        InternetSearchPlugin internetSearchPlugin = (InternetSearchPlugin)pluginInfo.getPluggable();
        internetSearchPlugin.search(string, bl);
    }

    @Override
    protected void onChange(DocumentEvent documentEvent) {
        this.updateActions();
    }

    @Override
    protected MMenu onPopupMenu() {
        MMenu mMenu = new MMenu();
        mMenu.addTitle(UI._("Custom Search"));
        mMenu.add(this.saveCustomSearchAction);
        this.customSearchCache.sort();
        boolean bl = this.customSearchCache.isEmpty();
        MMenu mMenu2 = new MMenu(UI._("Select"));
        mMenu2.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                mMenu.setSplitMenu(true);
                for (CustomSearch customSearch : InternetSearchPanel.this.customSearchCache) {
                    mMenu.add(new CustomSearchAction(customSearch, false));
                }
            }
        });
        mMenu2.setEnabled(!bl);
        mMenu.add(mMenu2);
        MMenu mMenu3 = new MMenu(MActionInfo.DELETE_NO_KEY_STROKE);
        mMenu3.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                mMenu.setSplitMenu(true);
                mMenu.addTitle(MActionInfo.DELETE);
                for (CustomSearch customSearch : InternetSearchPanel.this.customSearchCache) {
                    mMenu.add(new CustomSearchAction(customSearch, true));
                }
            }
        });
        mMenu3.setEnabled(!bl);
        mMenu.add(mMenu3);
        mMenu.addSeparator();
        mMenu.add(this.exactPhraseAction);
        return mMenu;
    }

    @Override
    protected void updateClearButton(boolean bl) {
        super.updateClearButton(bl);
        this.getClearButton().setVisible(false);
    }

    private void addCustomSearch() {
        this.customSearchCache.add(new CustomSearch(this.engine.getID(), this.getText()));
        this.saveCustomSearch();
    }

    private MSmallButton createEngineButton() {
        MSmallButton mSmallButton = new MSmallButton(){

            @Override
            protected MMenu onPopupMenu() {
                return InternetSearchPanel.this.createEngineMenu();
            }
        };
        mSmallButton.setPopupMenuArrowPainted(true);
        mSmallButton.setPopupMenuEnabled(true);
        return mSmallButton;
    }

    private MMenu createEngineMenu() {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        mMenu.addTitle(UI._("Search Using"));
        for (PluginInfo pluginInfo : InternetSearchPlugin.findAll()) {
            PluginAction pluginAction = new PluginAction(pluginInfo){

                @Override
                public void onAction() {
                    PluginInfo pluginInfo = (PluginInfo)this.getData();
                    InternetSearchPanel.this.setEngine(pluginInfo);
                    InternetSearchPanel.this.makeDefault();
                    Config config = Config.getDefault();
                    config.write("InternetSearch.last", pluginInfo.getID());
                    config.sync();
                }
            };
            mMenu.addRadioButton(pluginAction, pluginInfo == this.engine);
        }
        mMenu.addSeparator();
        mMenu.add(new MAction(PluginManager.GET_MORE_PLUGINS_ACTION_INFO){

            @Override
            public void onAction() {
                PluginDownloader.getMorePlugins(MApplication.getMainWindow(), PluginType.INTERNET_SEARCH);
            }
        });
        mMenu.addTitle(UI._("\"OpenSearch\" Plugin"));
        mMenu.add(new MAction(MActionInfo.INSTALL){

            @Override
            public void onAction() {
                InternetSearchPanel.this.installOpenSearchPlugin();
            }
        });
        MMenu mMenu2 = new MMenu(MActionInfo.UNINSTALL);
        mMenu2.setSplitMenu(true);
        mMenu2.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                for (PluginInfo pluginInfo : InternetSearchPlugin.findAll()) {
                    if (!InternetSearchPlugin.OpenSearchPlugin.class.getName().equals(pluginInfo.getClassName())) continue;
                    mMenu.add(new UninstallOpenSearchPluginAction(pluginInfo));
                }
                if (mMenu.isEmpty()) {
                    mMenu.addTitle(UI._("No Items"));
                }
            }
        });
        mMenu.add(mMenu2);
        return mMenu;
    }

    private void deleteCustomSearch(CustomSearch customSearch) {
        this.customSearchCache.remove(customSearch);
        this.saveCustomSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installOpenSearchPlugin() {
        block8: {
            String string = MClipboard.getURL();
            final MTextFieldPanel mTextFieldPanel = new MTextFieldPanel(string);
            mTextFieldPanel.getMenuButton().setVisible(false);
            mTextFieldPanel.setAutoCompletion("opensearch");
            mTextFieldPanel.setLabel(UI._("Source:"));
            MDialog mDialog = new MDialog(this.getWindowAncestor(), MActionInfo.INSTALL, 31){

                @Override
                protected void onUserClick() {
                    File file = InternetSearchPanel.this.installOpenSearchPluginFromFile(this);
                    if (file != null) {
                        mTextFieldPanel.setText(file.getPath());
                    }
                }
            };
            mDialog.changeButton((AbstractButton)mDialog.getOKButton(), MActionInfo.INSTALL);
            mDialog.getURLButton().setURL("https://addons.mozilla.org/firefox/browse/type:4/cat:all?sort=name");
            mDialog.changeButton((AbstractButton)mDialog.getURLButton(), PluginManager.GET_MORE_PLUGINS_ACTION_INFO);
            mDialog.changeButton((AbstractButton)mDialog.getUserButton(), UI._("Install from file..."), "ui/newfile");
            mDialog.addCenter(mTextFieldPanel);
            mDialog.addSouth(MLabel.createSmall(UI._("Example: {0}", "https://addons.mozilla.org/pl/firefox/downloads/file/25757/del.icio.us.xml"), null));
            mDialog.packFixed(UI.WindowSize.MEDIUM);
            if (mDialog.exec(mTextFieldPanel)) {
                mTextFieldPanel.saveAutoCompletion();
                String string2 = mTextFieldPanel.getText().trim();
                if (string2.isEmpty()) {
                    return;
                }
                try {
                    if (Net.isHTTP(string2)) {
                        Net.DownloadInfo downloadInfo = new Net.DownloadInfo(new URL(string2), ".xml", 4);
                        MDownloadDialog.download(this.getWindowAncestor(), downloadInfo);
                        try {
                            this.installOpenSearchPluginFromFile(downloadInfo.getFile());
                            break block8;
                        }
                        finally {
                            downloadInfo.getFile().delete();
                        }
                    }
                    this.installOpenSearchPluginFromFile(new File(string2));
                }
                catch (Exception exception) {
                    MMessage.error(this.getWindowAncestor(), exception);
                }
            }
        }
    }

    private void installOpenSearchPluginFromFile(File file) throws IOException {
        OpenSearchDescription openSearchDescription;
        try {
            openSearchDescription = XMLHelper.unmarshal(OpenSearchDescription.class, file);
            if (!openSearchDescription.getUrl().isEmpty() && "POST".equals(openSearchDescription.getUrl().get(0).getMethod())) {
                throw new IOException(UI._("Unsupported plugin format"));
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOException(UI._("Unsupported plugin format"), jAXBException);
        }
        String string = TK.createRandomUUID();
        String string2 = string + ".xml";
        File file2 = new File(InternetSearchPlugin.getSharedDirectory(), string2);
        FS.copyFile(file, file2);
        Config config = InternetSearchPlugin.getSharedConfig();
        config.write("OpenSearch.file." + string2, string);
        config.sync();
        PluginInfo pluginInfo = InternetSearchPlugin.toPluginInfo(openSearchDescription, string, file2);
        InternetSearchPlugin.register(pluginInfo);
        this.setEngine(pluginInfo);
    }

    private File installOpenSearchPluginFromFile(Window window) {
        MFileChooser mFileChooser = MFileChooser.createFileChooser(window, UI._("Select an \"OpenSearch\" Plugin you want to install"));
        mFileChooser.addFilter("OpenSearch", "xml");
        mFileChooser.setApproveText(UI._("Install"));
        mFileChooser.setConfigKey("plugin");
        if (mFileChooser.openDialog()) {
            return mFileChooser.getSelectedFile();
        }
        return null;
    }

    private void saveCustomSearch() {
        Config config = InternetSearchPlugin.getSharedConfig();
        config.removeAllValues(new RegExp("String\\.\\d+\\.(engine|text)"));
        config.write("count", this.customSearchCache.size());
        int n = 0;
        for (CustomSearch customSearch : this.customSearchCache) {
            config.write(n + ".text", customSearch.getText());
            config.write(n + ".engine", (String)customSearch.getValue());
            ++n;
        }
        config.sync();
    }

    private void setEngine(PluginInfo pluginInfo) {
        this.engine = pluginInfo;
        if (this.engine == null) {
            this.engineButton.setIcon(MIcon.small("ui/error"));
            this.engineButton.setToolTipText(UI._("No plugin"));
            this.setHintText(this.engineButton.getToolTipText());
        } else {
            this.engineButton.setIcon(this.engine.getSmallIcon());
            this.engineButton.setToolTipText(UI._("Select search engine ({0})", TK.toString(this.showEngineMenuKeyStroke)));
            this.setHintText((String)this.engine.name.get());
        }
    }

    private void setEngine(String string) {
        this.setEngine(InternetSearchPlugin.findByID(string));
    }

    private void toggleExactPhrase() {
        boolean bl = false;
        String string = this.getText();
        if (string.isEmpty()) {
            return;
        }
        if (string.charAt(0) == '\"') {
            string = string.substring(1);
        } else {
            bl = true;
            if (string.charAt(0) != '\"') {
                string = '\"' + string;
            }
        }
        if (string.charAt(string.length() - 1) == '\"' && !bl) {
            string = string.substring(0, string.length() - 1);
        } else if (bl && string.charAt(string.length() - 1) != '\"') {
            string = string + '\"';
        }
        this.setText(string);
    }

    private void updateActions() {
        boolean bl = !this.isEmpty();
        this.exactPhraseAction.setEnabled(bl);
        this.okAction.setEnabled(bl);
        this.saveCustomSearchAction.setEnabled(bl);
    }

    private final class UninstallOpenSearchPluginAction
    extends PluginAction {
        @Override
        public void onAction() {
            if (!MMessage.confirmDelete(this.getSourceWindow(), MMessage.getSimpleConfirmMessage())) {
                return;
            }
            PluginInfo pluginInfo = (PluginInfo)this.getData();
            File file = new File(pluginInfo.getPath());
            if (file.delete()) {
                Config config = InternetSearchPlugin.getSharedConfig();
                config.removeString("OpenSearch.file." + file.getName());
                config.sync();
                List<PluginInfo> list = InternetSearchPlugin.findAll();
                list.remove(pluginInfo);
                if (InternetSearchPanel.this.engine == pluginInfo) {
                    if (list.isEmpty()) {
                        InternetSearchPanel.this.setEngine(null);
                    } else {
                        InternetSearchPanel.this.setEngine(list.get(0));
                    }
                }
            }
        }

        private UninstallOpenSearchPluginAction(PluginInfo pluginInfo) {
            super(pluginInfo);
        }
    }

    private final class CustomSearchAction
    extends MAction {
        private final boolean remove;
        private final CustomSearch customSearch;

        @Override
        public void onAction() {
            if (this.remove) {
                if (MMessage.confirmDelete(this.getSourceWindow(), MMessage.getSimpleConfirmMessage())) {
                    InternetSearchPanel.this.deleteCustomSearch(this.customSearch);
                }
            } else {
                InternetSearchPanel.this.setEngine((String)this.customSearch.getValue());
                InternetSearchPanel.this.setText(this.customSearch.getText());
            }
        }

        private CustomSearchAction(CustomSearch customSearch, boolean bl) {
            super(customSearch.getText(), customSearch.getIcon());
            this.customSearch = customSearch;
            this.remove = bl;
        }
    }

    private static final class CustomSearch
    extends Item<String>
    implements Comparable<Item<String>> {
        @Override
        public int compareTo(Item<String> item) {
            return this.getText().compareToIgnoreCase(item.getText());
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                PluginInfo pluginInfo = InternetSearchPlugin.findByID((String)this.value);
                this.icon = pluginInfo != null ? pluginInfo.getSmallIcon() : MIcon.small("ui/error");
            }
            return this.icon;
        }

        private CustomSearch(String string, String string2) {
            super(string, string2 == null ? "" : string2);
        }
    }

    public static final class Highligther
    implements MHighlighter.UserHighlight<MTextField> {
        @Override
        public void highlight(MHighlighter<MTextField> mHighlighter, MTextField mTextField, String string) {
            boolean bl = false;
            int n = 0;
            block5: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '+': 
                    case ':': {
                        if (bl) continue block5;
                        mHighlighter.addHighlight(i, MHighlighter.OK_COLOR, true);
                        continue block5;
                    }
                    case '-': {
                        if (bl) continue block5;
                        mHighlighter.addHighlight(i, MHighlighter.ERROR_COLOR, true);
                        continue block5;
                    }
                    case '\"': {
                        if (bl) {
                            bl = false;
                            mHighlighter.addHighlight(n, i + 1, MHighlighter.DEFAULT_COLOR, true);
                            continue block5;
                        }
                        bl = true;
                        n = i;
                    }
                }
            }
            if (bl) {
                mHighlighter.addHighlight(n, string.length(), MHighlighter.WARNING_COLOR, true);
            }
        }
    }

    public static class Action
    extends MAction {
        public Action() {
            super(UI._("Internet Search..."), "ui/internet", 75, Action.getMenuMask());
            if (!((Boolean)Kiosk.actionInternetSearch.get()).booleanValue()) {
                this.setEnabled(false);
            }
        }
    }
}

