/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.ghns;

import java.awt.Window;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MTree;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.MTreeScanner;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class MirrorDialog
extends MDialog {
    private MSearchPanel searchPanel;
    private final MTree<Server, Model> tree = new MTree(new Model());

    public MirrorDialog(Window window) {
        super(window, UI._("Select a mirror server"), 7);
        this.tree.setCellRenderer(MRenderer.getSharedInstance());
        this.tree.setRootVisible(false);
        this.tree.setSingleSelectionMode();
        this.addCenter(MPanel.createVLabelPanel(this.tree, UI._("Servers:")));
        this.searchPanel = new MSearchPanel(false, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                MirrorDialog.this.filter(this.getText());
            }
        };
        this.addNorth(this.searchPanel);
        this.packFixed(UI.WindowSize.MEDIUM);
    }

    public Server addGroup(String string) {
        Server server = new Server(string, null);
        ((Server)this.getModel().getRootItem()).add(server);
        return server;
    }

    public Model getModel() {
        return (Model)this.tree.getModel();
    }

    public Server getSelectedServer() {
        Server server = this.tree.getSelectedItem();
        return server == null || server.isGroup() ? null : server;
    }

    public void setSelectedServer(Server server) {
        this.tree.focusItem(server);
    }

    @Override
    protected void onClose() {
        super.onClose();
        this.searchPanel = null;
    }

    private void filter(final String string) {
        Model model = (Model)this.tree.getModel();
        if (string.isEmpty()) {
            model.setAllVisible(true);
            this.searchPanel.setState(MTextFieldPanel.State.NORMAL);
            return;
        }
        final BooleanProperty booleanProperty = new BooleanProperty(false);
        new MTreeScanner<Server>((Server)model.getRootItem()){

            @Override
            public void processItem(Server server) {
                if (server.isGroup()) {
                    return;
                }
                if (TK.containsIgnoreCase(server.toString(), string)) {
                    server.setVisible(true);
                    booleanProperty.yes();
                } else {
                    server.setVisible(false);
                }
            }
        };
        this.searchPanel.setState((Boolean)booleanProperty.get() != false ? MTextFieldPanel.State.OK : MTextFieldPanel.State.ERROR);
        model.reload();
        for (Server server : ((Server)model.getRootItem()).listChildren(Server.class, MV.MODEL)) {
            this.tree.setExpanded(server, true);
        }
    }

    public static final class Server
    extends MTreeItem {
        private final String name;
        private final String prefix;

        public Server(String string) {
            this(null, string);
        }

        public Server add(String string, String string2) {
            this.add(new Server(string, string2));
            return this;
        }

        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public boolean matches(MTreeItem mTreeItem) {
            Server server = (Server)mTreeItem;
            return this.prefix != null && this.prefix.equals(server.prefix);
        }

        public String toString() {
            if (this.name == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.name);
            if (this.prefix != null) {
                stringBuilder.append(" (").append(this.prefix).append(')');
            }
            return stringBuilder.toString();
        }

        private Server(String string, String string2) {
            this.name = string;
            this.prefix = string2;
        }

        private boolean isGroup() {
            return this.prefix == null;
        }
    }

    public static final class Model
    extends MTreeModel<Server> {
        private Model() {
            super(new Server(null, null));
        }
    }
}

