/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.validator.NotEmptyValidator;
import org.makagiga.feeds.FeedComponent;
import org.makagiga.feeds.FeedUtils;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.fs.feeds.FeedsFSPlugin;

public final class AddFeedDialog
extends MDialog {
    private boolean previewDone;
    private FeedComponent preview;
    private MainPanel mainPanel;
    private MTextField fileName;
    private String newFileName;
    private String newURL;

    public AddFeedDialog(Window window, String string, FeedsFS feedsFS) {
        super(window, feedsFS.getNewFileActionText(), "ui/feed", 23);
        MURLButton mURLButton = this.getURLButton();
        mURLButton.setText(UI._("Get More Feeds..."));
        mURLButton.setURL(feedsFS.getInfo().getConfig().read("x.moreFeeds", null));
        this.updateButtons(false);
        this.mainPanel = new MainPanel(false, string);
        this.mainPanel.feedURLTextField.getDocument().addDocumentListener(new MDocumentAdapter<MTextField>(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                AddFeedDialog.this.updateButtons(false);
            }
        });
        this.getValidatorSupport().add(new NotEmptyValidator(this.mainPanel.feedURLTextField));
        MPanel mPanel = MPanel.createBorderPanel(5);
        mPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(UI._("Preview")), UI.createEmptyBorder(5)));
        this.preview = new FeedComponent(FeedComponent.Type.COMBO_BOX_AND_VIEWER);
        this.preview.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AddFeedDialog.this.preview.isActive()) {
                    return;
                }
                if (AddFeedDialog.this.preview.isCancelled() || AddFeedDialog.this.preview.isError()) {
                    AddFeedDialog.this.fileName.setText(UI._("New Feed"));
                    AddFeedDialog.this.newURL = null;
                    AddFeedDialog.this.updateButtons(false);
                    AddFeedDialog.this.updateComponents(true);
                } else {
                    AddFeedDialog.this.fileName.setText(AddFeedDialog.this.preview.getTitle());
                    FeedComponent.ChannelInfo channelInfo = AddFeedDialog.this.preview.getChannelInfo();
                    URL uRL = channelInfo.getFeed().getSource();
                    AddFeedDialog.this.newURL = uRL == null ? null : uRL.toString();
                    AddFeedDialog.this.updateButtons(true);
                    AddFeedDialog.this.updateComponents(true);
                }
            }
        });
        this.preview.setArchiveFlags(2);
        mPanel.addCenter(this.preview);
        this.fileName = new MTextField(UI._("New Feed"));
        this.fileName.setAutoCompletion("rename");
        this.getValidatorSupport().add(new FSHelper.NameValidator(this.fileName));
        MPanel mPanel2 = this.getCenterPanel();
        mPanel2.setGroupLayout(true);
        Dimension dimension = new Dimension(-1, -2);
        mPanel2.getGroupLayout().beginRows().addComponent(this.mainPanel, null, null, dimension).addComponent(mPanel).beginColumns().addComponent((Component)this.fileName, UI._("Name:")).end().end();
        this.setSize(UI.WindowSize.MEDIUM);
        this.installValidatorMessage();
    }

    @Override
    public boolean exec() {
        return this.exec(this.mainPanel.feedURLTextField);
    }

    @Override
    protected boolean onAccept() {
        this.mainPanel.feedURLTextField.saveAutoCompletion();
        this.fileName.saveAutoCompletion();
        if (this.previewDone) {
            this.newFileName = this.fileName.getText();
            if (this.newURL == null) {
                this.newURL = this.mainPanel.feedURLTextField.getText();
            }
            return true;
        }
        this.updateComponents(false);
        this.preview.download(this.mainPanel.feedURLTextField.getText());
        return false;
    }

    @Override
    protected void onClose() {
        if (this.preview != null) {
            this.preview.cancel();
            this.preview = null;
        }
        this.mainPanel = null;
        this.fileName = null;
    }

    private void updateButtons(boolean bl) {
        this.previewDone = bl;
        if (bl) {
            this.changeButton((AbstractButton)this.getOKButton(), UI._("Create"), "ui/ok");
        } else {
            this.changeButton((AbstractButton)this.getOKButton(), UI._("Preview"), "ui/next");
        }
    }

    private void updateComponents(boolean bl) {
        if (this.getOKButton() != null) {
            this.getOKButton().setEnabled(bl);
        }
    }

    String getNewFileName() {
        return this.newFileName;
    }

    String getNewURL() {
        return this.newURL;
    }

    public static final class MainPanel
    extends FeedsFSPlugin.AbstractPanel {
        private final MSmallButton pasteButton;
        MTextField feedURLTextField;
        String originalFeedURL;

        public MainPanel(boolean bl, String string) {
            super(bl ? UI._("Feed") : null, true);
            Object object;
            this.add(FeedUtils.createAddressTip());
            this.addContentGap();
            this.feedURLTextField = new MTextField();
            if (TK.isEmpty(string)) {
                object = MClipboard.getURL();
                if (object != null) {
                    this.feedURLTextField.setText((String)object);
                }
            } else {
                this.feedURLTextField.setText(string);
            }
            this.feedURLTextField.setAutoCompletion("feedurl");
            this.pasteButton = new MSmallButton(MActionInfo.PASTE){

                @Override
                protected void onClick() {
                    MainPanel.this.feedURLTextField.clear();
                    MainPanel.this.feedURLTextField.paste();
                    MainPanel.this.feedURLTextField.setText(MainPanel.this.feedURLTextField.getText().trim());
                    MainPanel.this.feedURLTextField.makeDefault();
                }
            };
            object = MPanel.createHLabelPanel(this.feedURLTextField, UI._("Address:"));
            ((MPanel)object).addEast(this.pasteButton);
            this.add((JComponent)object);
        }

        @Override
        public void setLocked(boolean bl) {
            super.setLocked(bl);
            this.feedURLTextField.setEditable(!bl);
            this.pasteButton.setEnabled(!bl);
        }

        @Override
        protected boolean shouldRefresh() {
            return !this.feedURLTextField.getText().equals(this.originalFeedURL);
        }
    }
}

