/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.awt.Color;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.TK;
import org.makagiga.fs.MetaInfo;

public abstract class MetaInfoComparator
implements Comparator<MetaInfo>,
Serializable {
    @Deprecated
    public static final MetaInfoComparator BY_AGE = new ByAge();
    public static final MetaInfoComparator BY_COLOR = new ByColor();
    public static final MetaInfoComparator BY_DATE = new ByDate();
    public static final MetaInfoComparator BY_LABEL = new ByLabel();
    public static final MetaInfoComparator BY_NAME = new ByName();
    public static final MetaInfoComparator BY_PATH = new ByPath();
    @Deprecated
    public static final MetaInfoComparator BY_PATH_FILES_FIRST = new ByPathFilesFirst();
    public static final MetaInfoComparator BY_RATING = new ByRating();
    @Deprecated
    public static final MetaInfoComparator BY_RATIO = new ByRatio();
    @Deprecated
    public static final MetaInfoComparator BY_USAGE = new ByUsage();

    @Override
    public int compare(MetaInfo metaInfo, MetaInfo metaInfo2) {
        boolean bl = metaInfo.isFolder();
        boolean bl2 = metaInfo2.isFolder();
        if (bl && !bl2) {
            return -1;
        }
        if (bl2 && !bl) {
            return 1;
        }
        int n = this.compareValues(metaInfo, metaInfo2);
        if (n == 0) {
            n = this.compareValues2(metaInfo, metaInfo2);
        }
        return n;
    }

    protected MetaInfoComparator() {
    }

    protected abstract int compareValues(MetaInfo var1, MetaInfo var2);

    protected int compareValues2(MetaInfo metaInfo, MetaInfo metaInfo2) {
        return BY_NAME.compare(metaInfo, metaInfo2);
    }

    private static final class ByUsage
    extends MetaInfoComparator {
        private ByUsage() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return TK.compare(metaInfo.getUsage(), metaInfo2.getUsage()) * -1;
        }
    }

    private static final class ByRatio
    extends MetaInfoComparator {
        private ByRatio() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return Float.compare(metaInfo.getRatio(), metaInfo2.getRatio()) * -1;
        }
    }

    private static final class ByRating
    extends MetaInfoComparator {
        private ByRating() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return Float.compare(metaInfo.getRating(), metaInfo2.getRating()) * -1;
        }
    }

    private static final class ByPathFilesFirst
    extends MetaInfoComparator {
        private ByPathFilesFirst() {
        }

        @Override
        public int compare(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return this.compareValues(metaInfo, metaInfo2);
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return TK.compare(metaInfo.getFilePath(), metaInfo2.getFilePath(), "") * -1;
        }
    }

    private static final class ByPath
    extends MetaInfoComparator {
        private ByPath() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return TK.compare(metaInfo.getFilePath(), metaInfo2.getFilePath(), "");
        }
    }

    private static final class ByName
    extends MetaInfoComparator {
        private Collator collator = Collator.getInstance();

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return this.collator.compare(metaInfo.toString(), metaInfo2.toString());
        }

        @Override
        protected int compareValues2(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return 0;
        }

        private ByName() {
            this.collator.setStrength(0);
        }
    }

    private static final class ByLabel
    extends MetaInfoComparator {
        private ByLabel() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            MIcon mIcon = metaInfo.getIcon();
            MIcon mIcon2 = metaInfo2.getIcon();
            if (mIcon == null || mIcon2 == null) {
                return 1;
            }
            return TK.compare(MIcon.getName(mIcon), MIcon.getName(mIcon2), "");
        }
    }

    private static final class ByDate
    extends MetaInfoComparator {
        private ByDate() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return TK.compare(metaInfo.getFile().lastModified(), metaInfo2.getFile().lastModified());
        }
    }

    private static final class ByColor
    extends MetaInfoComparator {
        private ByColor() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            Color color = metaInfo.getColor();
            Color color2 = metaInfo2.getColor();
            int n = color == null ? 0 : color.getRGB();
            int n2 = color2 == null ? 0 : color2.getRGB();
            return TK.compare(n, n2);
        }
    }

    private static final class ByAge
    extends MetaInfoComparator {
        private ByAge() {
        }

        @Override
        protected int compareValues(MetaInfo metaInfo, MetaInfo metaInfo2) {
            return TK.compare(metaInfo.getAge(), metaInfo2.getAge()) * -1;
        }
    }
}

