/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds.archive;

import java.awt.Color;
import java.text.ParseException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MObject;
import org.makagiga.feeds.AbstractItem;
import org.makagiga.feeds.Enclosure;

public final class ArchiveItem
extends AbstractItem {
    private Color color;
    private DateFormat dateFormat = DateFormat.UNKNOWN;
    private Float rating;
    private String category;
    private String colorString;
    private String comment;
    private String downloadDate;
    private String icon;
    private String tags;

    public ArchiveItem() {
    }

    public ArchiveItem(AbstractItem abstractItem, boolean bl) {
        this.dateFormat = abstractItem.getArchiveDateFormat();
        this.setAuthor(abstractItem.getAuthor());
        this.setCommentsLink(abstractItem.getCommentsLink());
        this.setDescription(abstractItem.getDescription());
        if (abstractItem.hasEnclosure()) {
            for (Enclosure enclosure : abstractItem.getEnclosure()) {
                this.addEnclosure(enclosure);
            }
        }
        this.setId(abstractItem.getId());
        this.setLink(abstractItem.getLink());
        this.setLongDescription(abstractItem.getLongDescription());
        this.setPublishedDate(abstractItem.getPublishedDate());
        this.setRead(abstractItem.isRead());
        this.setTitle(abstractItem.getTitle());
        this.setUpdatedDate(abstractItem.getUpdatedDate());
        if (bl) {
            this.setDownloadDate();
            this.setNew(true);
        }
    }

    public boolean equals(AbstractItem abstractItem, int n) {
        boolean bl;
        if (abstractItem == this) {
            return true;
        }
        boolean bl2 = false;
        if (this.isIdPresent() && abstractItem.isIdPresent()) {
            if (this.equals(this.getId(), abstractItem.getId(), false)) {
                if (this.equals(this.getDate(), abstractItem.getDate(), bl2)) {
                    return true;
                }
                bl2 = true;
            } else {
                return false;
            }
        }
        if (!this.equals(this.getTitle(), abstractItem.getTitle(), bl2)) {
            return false;
        }
        if (!this.equals(this.getLink(), abstractItem.getLink(), bl2)) {
            return false;
        }
        if (!this.equals(this.getCommentsLink(), abstractItem.getCommentsLink(), bl2)) {
            return false;
        }
        boolean bl3 = bl = bl2 || (n & 1) == 0;
        if (bl && !this.equals(this.getDescription(), abstractItem.getDescription(), bl2)) {
            return false;
        }
        if (bl && !this.equals(this.getLongDescription(), abstractItem.getLongDescription(), bl2)) {
            return false;
        }
        if (!this.equals(this.getAuthor(), abstractItem.getAuthor(), bl2)) {
            return false;
        }
        return this.equals(this.getEnclosure(), abstractItem.getEnclosure(), bl2);
    }

    @XmlElement(name="category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    @XmlElement(name="color")
    public String getColor() {
        return this.colorString;
    }

    public void setColor(String string) {
        try {
            this.color = ColorProperty.parseColor(string);
            this.colorString = string;
        }
        catch (ParseException parseException) {
            this.color = null;
            this.colorString = null;
        }
    }

    @XmlTransient
    public Color getColorValue() {
        return this.color;
    }

    public void setColorValue(Color color) {
        this.color = color;
        this.colorString = color == null ? null : ColorProperty.toString(color);
    }

    @XmlElement(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    @XmlElement(name="downloadDate")
    public String getDownloadDate() {
        return this.downloadDate;
    }

    public void setDownloadDate(String string) {
        this.downloadDate = string;
    }

    public MDate getDownloadDateAsDate() {
        String string = this.getDownloadDate();
        return string == null ? null : this.parseDate(string);
    }

    @XmlElement(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    @XmlElement(name="rating")
    public Float getRating() {
        return this.rating;
    }

    public void setRating(Float f) {
        this.rating = f;
    }

    @Override
    public MDate getPublishedDateAsDate() {
        return this.parseDate(this.getPublishedDate());
    }

    @XmlElement(name="tags")
    public String getTags() {
        return this.tags;
    }

    public void setTags(String string) {
        this.tags = string;
    }

    @Override
    public MDate getUpdatedDateAsDate() {
        return this.parseDate(this.getUpdatedDate());
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDownloadDate() {
        MDate mDate = MDate.now();
        switch (this.dateFormat) {
            case RFC_3339: {
                this.downloadDate = mDate.formatRFC3339();
                break;
            }
            case RFC_822: {
                this.downloadDate = mDate.formatRFC822();
                break;
            }
            default: {
                this.downloadDate = mDate.formatRFC3339();
            }
        }
    }

    private boolean equals(Object object, Object object2, boolean bl) {
        boolean bl2 = MObject.safeEquals(object, object2);
        if (!bl2 && bl) {
            MLogger.debug("archive", "Article property changed: \"%s\" <> \"%s\"\n", object, object2);
        }
        return bl2;
    }

    private MDate parseDate(String string) {
        switch (this.dateFormat) {
            case RFC_3339: {
                return MDate.parseRFC3339(string);
            }
            case RFC_822: {
                return MDate.parseRFC822(string);
            }
        }
        return MDate.parseRFC3339(string);
    }

    public static enum DateFormat {
        RFC_3339,
        RFC_822,
        UNKNOWN;

    }
}

