/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds.archive;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.makagiga.commons.AbstractFileCache;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Pair;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.TK;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.feeds.AbstractChannel;
import org.makagiga.feeds.AbstractItem;
import org.makagiga.feeds.archive.ArchiveChannel;
import org.makagiga.feeds.archive.ArchiveException;
import org.makagiga.feeds.archive.ArchiveItem;

public final class Archive
extends AbstractFileCache<String, Item> {
    private static final long serialVersionUID = 8892549564412526580L;
    public static final int NO_DESCRIPTION_COMPARE = 1;
    public static final int NO_ARCHIVE = 2;
    public static final String CATEGORY_PROPERTY = "category";
    public static final String COLOR_PROPERTY = "color";
    public static final String COMMENT_PROPERTY = "comment";
    public static final String ICON_PROPERTY = "icon";
    public static final String RATING_PROPERTY = "rating";
    public static final String TAGS_PROPERTY = "tags";
    private transient SoftReference<ChannelInfo> softCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Archive archive = this;
        synchronized (archive) {
            this.softCache = null;
        }
        super.clear();
    }

    public synchronized ItemInfo get(String string, String string2, boolean bl) throws ArchiveException {
        if (string == null) {
            throw new ArchiveException("Channel URL is null");
        }
        if (string2 == null) {
            throw new ArchiveException("Item ID is null");
        }
        ChannelInfo channelInfo = this.getChannel(string);
        List<ArchiveItem> list = channelInfo.getChannel().getFreshItems();
        ArchiveItem archiveItem = this.findByID(string, list, string2);
        if (bl) {
            archiveItem.setRead(true);
            channelInfo.marshal();
        }
        return new ItemInfo(channelInfo.channel, archiveItem);
    }

    public synchronized ChannelInfo getChannel(String string) throws ArchiveException {
        ChannelInfo channelInfo;
        if (this.softCache != null && (channelInfo = this.softCache.get()) != null && string.equals(channelInfo.channel.getLink())) {
            return channelInfo;
        }
        Item item = (Item)this.getItem(string);
        if (item == null) {
            throw new ArchiveException(String.format("\"%s\" not found in archive", string), string);
        }
        try {
            File file = this.getItemFile(item);
            ArchiveChannel archiveChannel = ArchiveChannel.loadFromXML(file);
            if (archiveChannel == null) {
                throw new ArchiveException(String.format("Could not load archive for \"%s\"", string), string);
            }
            archiveChannel.onFinish();
            channelInfo = new ChannelInfo(archiveChannel, file);
            this.softCache = new SoftReference<ChannelInfo>(channelInfo);
            return channelInfo;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ArchiveException(fileNotFoundException);
        }
        catch (JAXBException jAXBException) {
            throw new ArchiveException(jAXBException);
        }
    }

    public static Archive getInstance() {
        return (Archive)LazyArchiveHolder.INSTANCE.get();
    }

    public synchronized void markAs(String string, State state) throws ArchiveException {
        if (TK.isEmpty(string)) {
            throw new ArchiveException("\"url\" is null or empty");
        }
        ChannelInfo channelInfo = this.getChannel(string);
        List<ArchiveItem> list = channelInfo.getChannel().getFreshItems();
        if (TK.isEmpty(list)) {
            this.log.debugFormat("No items in \"%s\" archive", string);
            return;
        }
        for (ArchiveItem archiveItem : list) {
            archiveItem.setRead(state == State.READ);
        }
        channelInfo.marshal();
    }

    public List<ArchiveItem> merge(String string, AbstractChannel<?> abstractChannel) {
        return this.merge(string, abstractChannel, 0);
    }

    public List<ArchiveItem> merge(String string, AbstractChannel<?> abstractChannel, int n) {
        return this.merge(string, abstractChannel, n, Policy.REMOVE, 10);
    }

    public synchronized List<ArchiveItem> merge(String string, AbstractChannel<?> abstractChannel, int n, Policy policy, int n2) {
        this.softCache = null;
        if ((n & 2) != 0) {
            List<?> list = abstractChannel.getItems();
            if (list == null) {
                return null;
            }
            ArrayList<ArchiveItem> arrayList = new ArrayList<ArchiveItem>(list.size());
            for (AbstractItem abstractItem : list) {
                arrayList.add(new ArchiveItem(abstractItem, true));
            }
            return arrayList;
        }
        ChannelInfo channelInfo = new ChannelInfo();
        try {
            boolean bl = true;
            Item item = (Item)this.getItem(string);
            if (item == null) {
                channelInfo.file = this.createItemFile(null);
                this.log.debugFormat("Creating new archive entry \"%s\" for \"%s\"", channelInfo.file, string);
                this.putItem(string, new Item(channelInfo.file.getName()));
                channelInfo.channel = new ArchiveChannel(string, abstractChannel);
            } else {
                channelInfo.file = this.getItemFile(item);
                if (channelInfo.file.exists()) {
                    try {
                        channelInfo.channel = ArchiveChannel.loadFromXML(channelInfo.file);
                    }
                    catch (JAXBException jAXBException) {
                        throw new ArchiveException(jAXBException);
                    }
                    if (channelInfo.channel == null) {
                        this.log.debugFormat("'Existing' archive entry \"%s\" for \"%s\" does not exist!", channelInfo.file, string);
                        channelInfo.channel = new ArchiveChannel(string, abstractChannel);
                    } else {
                        channelInfo.channel.onFinish();
                        item.incUsage();
                        this.log.debugFormat("Using existing archive entry \"%s\" for \"%s\"", channelInfo.file, string);
                        if (abstractChannel != null) {
                            if (!channelInfo.channel.add(abstractChannel.getItems(), n, policy, n2)) {
                                bl = false;
                            }
                            if (abstractChannel.getBase() == null && channelInfo.channel.getBase() != null) {
                                abstractChannel.setBase(channelInfo.channel.getBase());
                                bl = true;
                            }
                        }
                    }
                } else {
                    this.removeItem(string);
                    this.putItem(string, new Item(channelInfo.file.getName()));
                    channelInfo.channel = new ArchiveChannel(string, abstractChannel);
                }
            }
            if (bl) {
                channelInfo.marshal();
            }
            return channelInfo.channel.getFreshItems();
        }
        catch (ArchiveException archiveException) {
            this.removeItem(string);
            if (channelInfo.file != null) {
                channelInfo.file.delete();
            }
            MLogger.exception(archiveException);
            return new ArchiveChannel(string, abstractChannel).getItems();
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return new ArchiveChannel(string, abstractChannel).getItems();
        }
    }

    public synchronized void removeExpiredInfo(String string) throws ArchiveException {
        ChannelInfo channelInfo = this.getChannel(string);
        channelInfo.getChannel().removeExpiredInfo();
        channelInfo.marshal();
    }

    public synchronized void setItemProperty(String string, String string2, Property ... propertyArray) throws ArchiveException {
        if (string == null) {
            throw new ArchiveException("Channel URL is null");
        }
        if (string2 == null) {
            throw new ArchiveException("Item ID is null");
        }
        ChannelInfo channelInfo = this.getChannel(string);
        List<ArchiveItem> list = channelInfo.getChannel().getFreshItems();
        ArchiveItem archiveItem = this.findByID(string, list, string2);
        boolean bl = false;
        for (Property property : propertyArray) {
            Object object;
            if (CATEGORY_PROPERTY.equals(property.getKey())) {
                object = property.getValue();
                archiveItem.setCategory(object == null ? null : object.toString());
                bl = true;
                continue;
            }
            if (COLOR_PROPERTY.equals(property.getKey())) {
                archiveItem.setColorValue((Color)property.getValue());
                bl = true;
                continue;
            }
            if (COMMENT_PROPERTY.equals(property.getKey())) {
                object = (String)property.getValue();
                archiveItem.setComment(TK.isEmpty(object) ? null : (String)object);
                bl = true;
                continue;
            }
            if (ICON_PROPERTY.equals(property.getKey())) {
                archiveItem.setIcon((String)property.getValue());
                bl = true;
                continue;
            }
            if (RATING_PROPERTY.equals(property.getKey())) {
                object = (Float)property.getValue();
                archiveItem.setRating(((Float)object).floatValue() == 0.0f ? null : (Float)object);
                bl = true;
                continue;
            }
            if (!TAGS_PROPERTY.equals(property.getKey())) continue;
            object = property.getValue();
            String string3 = object == null ? null : object.toString();
            archiveItem.setTags(TK.isEmpty(string3) ? null : string3);
            bl = true;
        }
        if (bl) {
            channelInfo.marshal();
        }
    }

    public static synchronized void shutDown() {
        Archive.getInstance().doWriteIndex();
    }

    @Override
    protected void readIndex() throws IOException {
        this.readXMLIndex(this.getName(), "index");
    }

    @Override
    protected Map.Entry<String, Item> readXMLEntry(SimpleXMLReader simpleXMLReader) {
        Item item = new Item(simpleXMLReader.getStringAttribute("file"));
        item.setUsage(simpleXMLReader.getIntegerAttribute("usage", 1));
        return Pair.create(simpleXMLReader.getStringAttribute("url"), item);
    }

    @Override
    protected void writeIndex() throws IOException {
        this.writeXMLIndex(this.getName(), "index");
    }

    @Override
    protected void writeXMLEntry(XMLBuilder xMLBuilder, Map.Entry<String, Item> entry) {
        Item item = entry.getValue();
        xMLBuilder.singleTag("entry", "usage", item.getUsage(), "url", entry.getKey(), "file", item.getFileName());
    }

    private Archive() {
        super("archive", null);
    }

    private ArchiveItem findByID(String string, List<ArchiveItem> list, String string2) throws ArchiveException {
        if (TK.isEmpty(list)) {
            throw new ArchiveException(String.format("Item \"%s\" not found in \"%s\" archive (archive is empty)", string2, string));
        }
        for (ArchiveItem archiveItem : list) {
            if (!string2.equals(archiveItem.getUniqueID())) continue;
            return archiveItem;
        }
        throw new ArchiveException(String.format("Item \"%s\" not found in \"%s\" archive", string2, string));
    }

    private static final class LazyArchiveHolder {
        private static final MGuardedObject<Archive> INSTANCE = new MGuardedObject<Archive>(new Archive(), "org.makagiga.feeds.archive.Archive", PermissionInfo.ThreatLevel.LOW, "RSS Archive");

        private LazyArchiveHolder() {
        }
    }

    public static final class Property
    extends Pair<String, Object> {
        public Property(String string, Object object) {
            super(string, object);
        }
    }

    public static final class ItemInfo {
        private ArchiveChannel channel;
        private ArchiveItem item;

        public ArchiveChannel getChannel() {
            return this.channel;
        }

        public ArchiveItem getItem() {
            return this.item;
        }

        private ItemInfo(ArchiveChannel archiveChannel, ArchiveItem archiveItem) {
            this.channel = archiveChannel;
            this.item = archiveItem;
        }
    }

    public static final class Item
    extends AbstractFileCache.Item {
        public Item(String string) {
            super(string);
        }
    }

    public static final class ChannelInfo {
        private ArchiveChannel channel;
        private File file;

        public ArchiveChannel getChannel() {
            return this.channel;
        }

        public File getFile() {
            return this.file;
        }

        @Deprecated
        public void marshal() throws ArchiveException {
            this.channel.saveToXML(this.file);
        }

        private ChannelInfo() {
        }

        private ChannelInfo(ArchiveChannel archiveChannel, File file) {
            this.channel = archiveChannel;
            this.file = file;
        }
    }

    public static enum State {
        READ,
        UNREAD;

    }

    public static enum Policy {
        DO_NOT_REMOVE,
        REMOVE,
        USE_GLOBAL_SETTINGS;

    }
}

