/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.todo;

import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.makagiga.Tabs;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.ColumnManager;
import org.makagiga.commons.Config;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.Linkify;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLinkAction;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.Preloader;
import org.makagiga.commons.UI;
import org.makagiga.commons.mv.ModelDataSource;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.TablePrintInfo;
import org.makagiga.editors.DocumentLinks;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorDesigner;
import org.makagiga.editors.EditorExportV2;
import org.makagiga.editors.EditorIO;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorPrint;
import org.makagiga.editors.EditorSearch;
import org.makagiga.editors.EditorStats;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.TextUtils;
import org.makagiga.editors.todo.TodoEditorCore;
import org.makagiga.editors.todo.TodoEditorDesigner;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.pim.calendar.ICalendar;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskPanel;
import org.makagiga.todo.sources.LocalTaskModelDataSource;
import org.makagiga.tools.EditorQuickFind;
import org.makagiga.tools.presentation.Presentation;

public final class TodoEditor
extends Editor<TodoEditorCore>
implements DocumentLinks,
EditorConfig,
EditorDesigner<TodoEditorDesigner>,
EditorExportV2,
EditorIO,
EditorPrint,
EditorSearch,
EditorStats<ChartModel>,
EditorZoom,
Focusable,
PluginMenu,
Preloader.Events,
Presentation.ToggleListener {
    private MAction showGridAction;
    private final ModelDataSource<? super TaskModel> source;
    private StaticCoreHandler staticCoreHandler;
    private TaskPanel<TodoEditorCore> taskPanel;
    private TodoEditorDesigner designer;

    public TodoEditor() {
        MPanel mPanel = this.getMainPanel();
        this.setCore(new TodoEditorCore(this));
        MScrollPane mScrollPane = new MScrollPane((JComponent)this.core, 2);
        mScrollPane.setColumnHeaderView(((TodoEditorCore)this.core).getTableHeader());
        mPanel.addCenter(mScrollPane);
        this.designer = new TodoEditorDesigner();
        this.taskPanel = new StaticTaskPanel((TodoEditorCore)this.core);
        this.taskPanel.setVisible(!Presentation.isActive());
        mPanel.addNorth(this.taskPanel);
        Presentation.addToggleListener(this);
        MTip mTip = new MTip(TodoEditor.class.getName());
        mTip.setRoundType(GlassPainter.RoundType.NONE);
        mTip.showNextTip(MTip.Visible.SELDOM);
        mPanel.addSouth(mTip);
        this.staticCoreHandler = new StaticCoreHandler();
        ((TodoEditorCore)this.core).addMouseListener(this.staticCoreHandler);
        ((TodoEditorCore)this.core).getSelectionModel().addListSelectionListener(this.staticCoreHandler);
        this.source = new LocalTaskModelDataSource();
    }

    @Override
    public void focus() {
        this.taskPanel.focus();
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.taskPanel.isLocked();
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        this.taskPanel.setLocked(bl);
        ((TaskModel)((TodoEditorCore)this.core).getModel()).setLocked(bl);
    }

    @Override
    public void onClose() {
        Presentation.removeToggleListener(this);
        if (this.staticCoreHandler != null) {
            ((TodoEditorCore)this.core).removeMouseListener(this.staticCoreHandler);
            ((TodoEditorCore)this.core).getSelectionModel().removeListSelectionListener(this.staticCoreHandler);
            this.staticCoreHandler = null;
        }
        if (this.designer != null) {
            this.designer.dispose(new Object[0]);
            this.designer = null;
        }
        this.taskPanel = null;
        ((TodoEditorCore)this.core).dispose(new Object[0]);
    }

    @Override
    public void onLastClose() {
    }

    @Override
    public void setExportMode(boolean bl) {
        super.setExportMode(bl);
        if (bl) {
            ((TodoEditorCore)this.core).clearSelection();
        }
    }

    @Override
    public void updateActions() {
        if (!this.isCurrent()) {
            return;
        }
        ((TodoEditorCore)this.core).getEditActionGroup().update();
    }

    @Override
    public void updateStatusText() {
        this.setStatusText(((TodoEditorCore)this.core).getSelectionText());
    }

    @Override
    public Collection<MLinkAction> getDocumentLinks() {
        Linkify linkify = Linkify.getInstance();
        MArrayList<MLinkAction> mArrayList = null;
        for (Task task : (TaskModel)((TodoEditorCore)this.core).getModel()) {
            Set<URI> set = linkify.findAll(task.getSummary());
            if (set.isEmpty()) continue;
            if (mArrayList == null) {
                mArrayList = new MArrayList<MLinkAction>();
            }
            for (URI uRI : set) {
                mArrayList.add(new MLinkAction(uRI));
            }
        }
        return mArrayList == null ? Collections.emptyList() : mArrayList;
    }

    @Override
    public void loadConfig(Config config) {
        Config config2 = Config.getDefault();
        ((TodoEditorCore)this.core).read(config2, config, this);
        if (this.showGridAction != null) {
            this.showGridAction.setSelected(((TodoEditorCore)this.core).isGridVisible());
        }
    }

    @Override
    public void saveConfig(Config config) {
        Config config2 = Config.getDefault();
        ((TodoEditorCore)this.core).write(config2, config, this);
    }

    @Override
    public synchronized TodoEditorDesigner getEditorDesigner() {
        return this.designer;
    }

    @Override
    public void updateEditorDesigner() {
    }

    @Override
    public void exportFile(EditorPlugin.FileType fileType, OutputStream outputStream) throws Exception {
        if (fileType.is("csv")) {
            ((TodoEditorCore)this.core).saveToFileAsCSV(outputStream);
        } else if (!fileType.is("html")) {
            if (fileType.is("ics")) {
                ((TodoEditorCore)this.core).saveToFileAsXCalendar(outputStream, new ICalendar());
            } else if (fileType.is("mgtodo") || fileType.is("xml")) {
                ((TaskModel)((TodoEditorCore)this.core).getModel()).saveToXML(outputStream);
            } else if (fileType.is("ods")) {
                ((TodoEditorCore)this.core).saveToFileAsODS(outputStream);
            } else if (fileType.is("opml")) {
                ((TodoEditorCore)this.core).saveToFileAsOPML(outputStream);
            } else if (fileType.is("txt")) {
                ((TodoEditorCore)this.core).saveToFileAsText(outputStream);
            } else if (fileType.is("vcs")) {
                ((TodoEditorCore)this.core).saveToFileAsVcs(outputStream);
            } else if (fileType.is("xhtml")) {
                ((TodoEditorCore)this.core).saveToFileAsHTML(outputStream, true, false);
            } else {
                this.exportNotSupported(fileType);
            }
        }
    }

    @Override
    public Object configureExport(Window window, EditorPlugin.FileType fileType) throws Exception {
        if (!fileType.is("html")) {
            return null;
        }
        FormPanel<HTMLOptionsForm> formPanel = new FormPanel<HTMLOptionsForm>(new HTMLOptionsForm());
        formPanel.setLabel("html5", "HTML 5");
        formPanel.setLabel("preview", UI._("Open in External Browser/Editor"));
        MDialog mDialog = formPanel.createDialog(window, UI._("Export"));
        mDialog.changeButton((AbstractButton)mDialog.getOKButton(), MActionInfo.CONTINUE);
        if (mDialog.exec()) {
            return formPanel.getForm();
        }
        return EditorExportV2.CANCEL_EXPORT;
    }

    @Override
    public EditorExportV2.ExportResult exportFile(EditorPlugin.FileType fileType, File file, OutputStream outputStream, Object object) throws Exception {
        if (fileType.is("html")) {
            HTMLOptionsForm hTMLOptionsForm = (HTMLOptionsForm)object;
            ((TodoEditorCore)this.core).saveToFileAsHTML(outputStream, hTMLOptionsForm.html5, hTMLOptionsForm.html5);
            return hTMLOptionsForm.preview ? EditorExportV2.ExportResult.PREVIEW : EditorExportV2.ExportResult.OK;
        }
        return EditorExportV2.ExportResult.OK;
    }

    @Override
    public void loadFile(InputStream inputStream, boolean bl) throws Exception {
        this.source.read((TaskModel)((TodoEditorCore)this.core).getModel(), inputStream, bl);
        EditorQuickFind.autoSearch();
    }

    @Override
    public void saveFile(OutputStream outputStream) throws Exception {
        this.source.write((TaskModel)((TodoEditorCore)this.core).getModel(), outputStream);
        this.updateIndex(((TodoEditorCore)this.core).getKeywords());
    }

    @Override
    public Printable getPrintable(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return ((TodoEditorCore)this.core).getPrintable(TablePrintInfo.getPrintMode(flags), messageFormat, messageFormat2);
    }

    @Override
    public PrintInfo.PrintResult printDocument(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return TablePrintInfo.printDocument((JTable)this.core, flags, messageFormat, messageFormat2, this.getPrintTitle());
    }

    @Override
    public EditorSearch.SearchResult findText(String string, Flags flags) {
        return ((TodoEditorCore)this.core).searchFor(string, 0, flags);
    }

    @Override
    public EditorSearch.SearchResult findNextText(String string, Flags flags) {
        EditorSearch.SearchResult searchResult = ((TodoEditorCore)this.core).searchFor(string, ((TodoEditorCore)this.core).getSelectedRow() + 1, flags);
        if (searchResult == EditorSearch.SearchResult.WRAP_AROUND) {
            return this.findText(string, flags) == EditorSearch.SearchResult.NOT_FOUND ? EditorSearch.SearchResult.NOT_FOUND : EditorSearch.SearchResult.WRAP_AROUND;
        }
        return searchResult;
    }

    @Override
    public String getDefaultSearchText() {
        return ((TodoEditorCore)this.core).getSelectedSummary();
    }

    @Override
    public int getSupportedSearchOptions() {
        return 1;
    }

    @Override
    public ChartPainter<ChartModel> getStatsChart() {
        return new ChartPainter<ChartModel>(((TodoEditorCore)this.core).createChartModel());
    }

    @Override
    public MProperties getStatsProperties() {
        return null;
    }

    @Override
    public String getStatsTitle() {
        return this.getMetaInfo().toString();
    }

    @Override
    public JComponent getZoomComponent() {
        return null;
    }

    @Override
    public boolean isZoomEnabled(EditorZoom.ZoomType zoomType) {
        return TextUtils.canZoom((JComponent)this.core, zoomType);
    }

    @Override
    public void zoom(EditorZoom.ZoomType zoomType) {
        ((TodoEditorCore)this.core).updateFontSize(TextUtils.zoom((JComponent)this.core, zoomType).getSize());
        Config config = Config.getDefault();
        ((TodoEditorCore)this.core).writeFontSize(config, this);
        config.sync();
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("EDIT_MENU")) {
            ActionGroup actionGroup = ((TodoEditorCore)this.core).getEditActionGroup();
            actionGroup.updateMenu(mMenu);
            mMenu.addSeparator();
            mMenu.add(((TodoEditorCore)this.core).createSetValueMenu(((TodoEditorCore)this.core).getSelectedRows()));
        } else if (string.equals("VIEW_MENU_EDITOR") && ((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            mMenu.addSeparator();
            ColumnManager columnManager = ((TodoEditorCore)this.core).getColumnManager();
            mMenu.add(columnManager.createMenu());
            if (this.showGridAction == null) {
                this.showGridAction = new ShowGridAction();
            }
            mMenu.addCheckBox(this.showGridAction, ((TodoEditorCore)this.core).isGridVisible());
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if (string.equals("EDITOR_TOOL_BAR")) {
            ActionGroup actionGroup = ((TodoEditorCore)this.core).getEditActionGroup();
            actionGroup.updateToolBar(mToolBar);
        }
    }

    @Override
    @Deprecated
    public void preloadFinished() {
        this.destroy();
    }

    @Override
    public void toggle(Presentation.ToggleEvent toggleEvent) {
        this.taskPanel.setVisible(!toggleEvent.isActive());
    }

    @Override
    @Deprecated
    protected ActionGroup createSharedActionGroup() {
        return super.createSharedActionGroup();
    }

    private static final class StaticTaskPanel
    extends TaskPanel<TodoEditorCore> {
        @Override
        public void setLocked(boolean bl) {
            super.setLocked(bl);
            this.newTaskTextField.setToolTipText(bl ? UI._("This file is locked. Click the \"Unlock\" button if you want to edit this file.") : this.newTaskTextField.getPromptText());
        }

        private StaticTaskPanel(TodoEditorCore todoEditorCore) {
            super(todoEditorCore);
        }
    }

    private static final class StaticCoreHandler
    extends MMouseAdapter
    implements ListSelectionListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Editor<?> editor;
            if (MMouseAdapter.isLeft(mouseEvent) && (editor = Editor.getCurrentEditor()) != null) {
                editor.showLockInfo();
            }
        }

        @Override
        public void popupTrigger(MouseEvent mouseEvent) {
            Editor<?> editor = Editor.getCurrentEditor();
            if (editor != null) {
                editor.showPopupMenu("EDIT_MENU", (InputEvent)mouseEvent);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Editor<?> editor = Editor.getCurrentEditor();
            if (editor instanceof TodoEditor) {
                TodoEditor todoEditor = (TodoEditor)editor;
                todoEditor.getEditorDesigner().updateComponentsLater((TodoEditorCore)todoEditor.getCore());
            }
        }

        private StaticCoreHandler() {
        }
    }

    private static final class ShowGridAction
    extends MAction {
        @Override
        public void onAction() {
            boolean bl = this.isSelected();
            Editor<?> editor = Editor.getCurrentEditor();
            if (editor instanceof TodoEditor) {
                Config config = Config.getDefault();
                config.write(((TodoEditor)TodoEditor.class.cast(editor)).getGlobalEntry("showGrid"), bl);
                config.sync();
            }
            for (Editor editor2 : Tabs.getInstance()) {
                if (!(editor2 instanceof TodoEditor)) continue;
                ((TodoEditorCore)((TodoEditor)TodoEditor.class.cast(editor2)).getCore()).setGridVisible(bl);
            }
        }

        private ShowGridAction() {
            super(MActionInfo.SHOW_GRID);
        }
    }

    @Form(order={"preview", "html5"})
    private static final class HTMLOptionsForm {
        @Field
        private boolean preview = true;
        @Field
        private boolean html5 = true;

        private HTMLOptionsForm() {
        }
    }
}

