/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.notepad.spi;

import java.awt.Color;
import javax.swing.KeyStroke;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.TK;
import org.makagiga.editors.notepad.NotepadEditor;
import org.makagiga.editors.notepad.NotepadEditorCore;
import org.makagiga.editors.notepad.spi.CodePreviewProvider;

public final class HTMLPreviewProvider
extends CodePreviewProvider {
    public static final KeyStroke ACTION_KEY_STROKE = KeyStroke.getKeyStroke(72, MAction.getMenuMask() | 1);

    public HTMLPreviewProvider() {
        super("HTML 3.2 (" + TK.toString(ACTION_KEY_STROKE) + ")");
    }

    @Override
    public String createHTMLCode(NotepadEditor notepadEditor) throws Exception {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        String string = ((NotepadEditorCore)notepadEditor.getCore()).getText();
        if (!TK.containsIgnoreCase(string, "<html")) {
            hTMLBuilder.beginHTML();
            hTMLBuilder.beginStyle();
            Color color = ((NotepadEditorCore)notepadEditor.getCore()).getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            hTMLBuilder.bestLinkRules(color);
            hTMLBuilder.endStyle();
            hTMLBuilder.beginDoc();
            hTMLBuilder.emit(string);
            hTMLBuilder.endDoc();
        } else {
            hTMLBuilder.emit(string);
        }
        return hTMLBuilder.toString();
    }
}

