/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import javax.swing.ButtonGroup;
import javax.swing.KeyStroke;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MTogglePanel;
import org.makagiga.commons.UI;
import org.makagiga.editors.AnnotationBar;
import org.makagiga.editors.Editor;
import org.makagiga.editors.image.ImageEditor;
import org.makagiga.editors.image.ImageEditorCore;
import org.makagiga.editors.image.ImageEditorDesigner;
import org.makagiga.editors.image.tools.Tool;
import org.makagiga.editors.image.tools.ToolButton;

public final class ToolManager
extends MTogglePanel {
    private final MArrayList<Tool> tools = new MArrayList();
    private static String currentID = "";
    private Tool current;

    public ToolManager() {
        super(UI._("Tools"), null, "tool-manager", true);
    }

    public Tool getCurrent() {
        return this.current;
    }

    public void setCurrent(Tool tool) {
        this.current = tool;
        currentID = this.current == null ? "" : this.current.getID();
    }

    public boolean processKeyBinding(KeyStroke keyStroke) {
        for (Tool tool : this.tools) {
            if (!keyStroke.equals(tool.getKeyStroke())) continue;
            this.setActive(tool);
            return true;
        }
        return false;
    }

    public <T extends Tool> T register(T t) {
        this.tools.add(t);
        return t;
    }

    public void setActive(Tool tool) {
        ImageEditorCore imageEditorCore = Editor.getCurrentCore(ImageEditorCore.class);
        if (imageEditorCore != null) {
            imageEditorCore.setTool(tool);
            AnnotationBar annotationBar = AnnotationBar.getInstance();
            for (ToolButton object : ContainerIterator.create(annotationBar, ToolButton.class)) {
                if (object.getTool() != tool || object.isSelected()) continue;
                object.setSelected(true);
                break;
            }
            ImageEditorDesigner imageEditorDesigner = imageEditorCore.getEditor().getEditorDesigner();
            for (MTogglePanel mTogglePanel : ContainerIterator.create(imageEditorDesigner, MTogglePanel.class)) {
                if ("image-info".equals(mTogglePanel.getID()) || "tool-manager".equals(mTogglePanel.getID())) continue;
                mTogglePanel.setExpanded(tool.isPanelVisible(mTogglePanel.getID()));
            }
        }
    }

    public void setContext(ImageEditor imageEditor, ImageEditorCore imageEditorCore) {
        for (Tool tool : this.tools) {
            tool.setContext(imageEditor, imageEditorCore);
        }
    }

    public void unregisterAll() {
        this.current = null;
        this.tools.clear();
    }

    public void update() {
        AnnotationBar annotationBar = AnnotationBar.getInstance();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Tool tool : this.tools) {
            ToolButton toolButton = new ToolButton(tool);
            annotationBar.add(toolButton);
            buttonGroup.add(toolButton);
            if (!tool.getID().equals(currentID)) continue;
            this.current = tool;
            toolButton.setSelected(true);
        }
    }
}

