/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MCellTip;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.EditorSearch;
import org.makagiga.editors.EditorZoom;

public final class TextUtils {
    public static final int MIN_ZOOM = 8;
    public static final int MAX_ZOOM = 128;
    private static final String HIGHLIGHTER_HANDLER = "org.makagiga.editors.TextUtils.highlighterHandler";
    private static final String OLD_HIGHLIGHTER = "org.makagiga.editors.TextUtils.oldHighlighter";

    public static boolean canZoom(JComponent jComponent, EditorZoom.ZoomType zoomType) {
        if (zoomType == EditorZoom.ZoomType.IN) {
            return jComponent.getFont().getSize() < 128;
        }
        if (zoomType == EditorZoom.ZoomType.OUT) {
            return jComponent.getFont().getSize() > 8;
        }
        return true;
    }

    public static EditorSearch.SearchResult findText(JTextComponent jTextComponent, String string, Flags flags) {
        return TextUtils.searchFor(jTextComponent, string, 0, flags);
    }

    @Deprecated
    public static EditorSearch.SearchResult findText(JTextComponent jTextComponent, String string, int n, Flags flags) {
        return TextUtils.searchFor(jTextComponent, string, 0, flags);
    }

    public static EditorSearch.SearchResult findNextText(JTextComponent jTextComponent, String string, Flags flags) {
        EditorSearch.SearchResult searchResult = TextUtils.searchFor(jTextComponent, string, jTextComponent.getSelectionStart() + 1, flags);
        if (searchResult == EditorSearch.SearchResult.WRAP_AROUND) {
            EditorSearch.SearchResult searchResult2 = TextUtils.findText(jTextComponent, string, flags);
            return searchResult2 == EditorSearch.SearchResult.NOT_FOUND ? EditorSearch.SearchResult.NOT_FOUND : EditorSearch.SearchResult.WRAP_AROUND;
        }
        return searchResult;
    }

    public static void uninstallSearchHighlighter(JTextComponent jTextComponent) {
        StaticHighlighterHandler staticHighlighterHandler = UI.getClientProperty(jTextComponent, HIGHLIGHTER_HANDLER, null);
        if (staticHighlighterHandler != null) {
            jTextComponent.getDocument().removeDocumentListener(staticHighlighterHandler);
            jTextComponent.removeMouseListener(staticHighlighterHandler);
            jTextComponent.putClientProperty(HIGHLIGHTER_HANDLER, null);
            Highlighter highlighter = UI.getClientProperty(jTextComponent, OLD_HIGHLIGHTER, null);
            if (highlighter == null) {
                highlighter = new DefaultHighlighter();
            }
            jTextComponent.setHighlighter(highlighter);
            jTextComponent.putClientProperty(OLD_HIGHLIGHTER, null);
        }
    }

    public static Font zoom(JComponent jComponent, EditorZoom.ZoomType zoomType) {
        Serializable serializable;
        if (jComponent instanceof JTable) {
            MCellTip.getInstance().setVisible(false);
        }
        int n = -1;
        JViewport jViewport = null;
        if (jComponent instanceof JTextComponent && (jViewport = MScrollPane.getViewport(serializable = (JTextComponent)jComponent)) != null) {
            n = serializable.viewToModel(jViewport.getViewPosition());
        }
        serializable = UI.changeFontSize(jComponent, zoomType == EditorZoom.ZoomType.IN ? 1 : -1, 8, 128);
        if (n != -1) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                if (rectangle != null) {
                    rectangle.height = jTextComponent.getVisibleRect().height;
                    jTextComponent.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {
                MLogger.exception(badLocationException);
            }
        }
        return serializable;
    }

    private TextUtils() {
    }

    private static StaticHighlighterHandler installSearchHighlighter(JTextComponent jTextComponent, String string, Flags flags) {
        StaticHighlighterHandler staticHighlighterHandler = UI.getClientProperty(jTextComponent, HIGHLIGHTER_HANDLER, null);
        if (staticHighlighterHandler == null) {
            staticHighlighterHandler = new StaticHighlighterHandler(jTextComponent);
            jTextComponent.getDocument().addDocumentListener(staticHighlighterHandler);
            jTextComponent.addMouseListener(staticHighlighterHandler);
            jTextComponent.putClientProperty(HIGHLIGHTER_HANDLER, staticHighlighterHandler);
            Highlighter highlighter = jTextComponent.getHighlighter();
            jTextComponent.putClientProperty(OLD_HIGHLIGHTER, highlighter);
            MHighlighter.install(jTextComponent, staticHighlighterHandler).setDisableIfSelection(false);
        }
        staticHighlighterHandler.update(jTextComponent, string, flags);
        return staticHighlighterHandler;
    }

    private static EditorSearch.SearchResult searchFor(JTextComponent jTextComponent, String string, int n, Flags flags) {
        String string2;
        String string3;
        Document document = jTextComponent.getDocument();
        int n2 = document.getLength();
        try {
            string3 = document.getText(0, n2);
        }
        catch (BadLocationException badLocationException) {
            MLogger.exception(badLocationException);
            TextUtils.uninstallSearchHighlighter(jTextComponent);
            return EditorSearch.SearchResult.NOT_FOUND;
        }
        if (TK.isEmpty(string3)) {
            TextUtils.uninstallSearchHighlighter(jTextComponent);
            return EditorSearch.SearchResult.NOT_FOUND;
        }
        if (n > n2 - 1) {
            return EditorSearch.SearchResult.WRAP_AROUND;
        }
        if (flags.isSet(1L)) {
            string2 = string;
        } else {
            string3 = string3.toUpperCase();
            string2 = string.toUpperCase();
        }
        int n3 = string3.indexOf(string2, n);
        if (n3 != -1) {
            jTextComponent.setCaretPosition(n3);
            jTextComponent.setSelectionStart(n3);
            jTextComponent.setSelectionEnd(n3 + string2.length());
            TextUtils.installSearchHighlighter(jTextComponent, string2, flags);
            return EditorSearch.SearchResult.FOUND;
        }
        int n4 = jTextComponent.getSelectionStart();
        if (string3.indexOf(string2, n4) == n4) {
            return EditorSearch.SearchResult.WRAP_AROUND;
        }
        TextUtils.uninstallSearchHighlighter(jTextComponent);
        return n == 0 ? EditorSearch.SearchResult.NOT_FOUND : EditorSearch.SearchResult.WRAP_AROUND;
    }

    private static final class StaticHighlighterHandler
    extends MMouseAdapter
    implements DocumentListener,
    MHighlighter.UserHighlight<JTextComponent> {
        private Flags flags = new Flags();
        private String textToFind;
        private final WeakReference<JTextComponent> textComponentRef;

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.onChange();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.onChange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.onChange();
        }

        @Override
        public void highlight(MHighlighter<JTextComponent> mHighlighter, JTextComponent jTextComponent, String string) {
            int n;
            String string2 = string;
            if (this.flags.isClear(1L)) {
                string2 = string2.toUpperCase();
            }
            int n2 = jTextComponent.getSelectionStart();
            int n3 = jTextComponent.getSelectionEnd();
            int n4 = 0;
            while ((n = string2.indexOf(this.textToFind, n4)) != -1) {
                Color color = n >= n2 && n <= n3 ? MColor.SKY_BLUE : MHighlighter.SEARCH_COLOR;
                mHighlighter.addHighlight(n, n + this.textToFind.length(), color, true);
                n4 = n + 1;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
            if (jTextComponent != null) {
                TextUtils.uninstallSearchHighlighter(jTextComponent);
                jTextComponent.repaint();
            }
        }

        private StaticHighlighterHandler(JTextComponent jTextComponent) {
            this.textComponentRef = TK.newWeakRef(jTextComponent);
        }

        private void onChange() {
            JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
            if (jTextComponent != null) {
                TextUtils.uninstallSearchHighlighter(jTextComponent);
            }
        }

        private void update(JTextComponent jTextComponent, String string, Flags flags) {
            this.textToFind = string;
            this.flags = flags;
            MHighlighter.update(jTextComponent, this);
        }
    }
}

