/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JComponent;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTab;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.ReferenceCount;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.Tuple;
import org.makagiga.commons.UI;
import org.makagiga.commons.crypto.CryptoUtils;
import org.makagiga.commons.crypto.PBEInfo;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorCrypto;
import org.makagiga.editors.EditorIO;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorPrint;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.search.Index;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.AdvancedProperties;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;
import org.makagiga.tree.version.VersionControl;
import org.makagiga.tree.version.VersionException;

public abstract class Editor<C extends Component>
extends MTab
implements Config.GlobalEntry,
Lockable,
PrintInfo {
    private boolean asyncLoad;
    private boolean doShowLockInfo = true;
    private boolean exportMode;
    private boolean modified;
    private boolean printing;
    private static Map<Class<?>, ActionGroup> sharedActionGroupMap = TK.newHashMap();
    private MPanel mainPanel;
    private MTimer syncTimer;
    private static ReferenceCount<String> referenceCount = new ReferenceCount();
    private Tuple.Two<Color, Color> componentColorsState;
    protected C core;
    private boolean locked;
    private MetaInfo metaInfo;
    private PluginInfo info;
    private String oldStatusText = "";
    PBEInfo pbeInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Editor() {
        Class<Editor> clazz = Editor.class;
        synchronized (Editor.class) {
            referenceCount.addReference(this.getClass().getName());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Editor(PluginInfo pluginInfo) {
        this(pluginInfo.toString(), pluginInfo.getSmallIcon());
    }

    public Editor(String string, MIcon mIcon) {
        this.setMetaInfo(MetaInfo.createDummy(string, mIcon));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object object = this;
        synchronized (object) {
            if (this.syncTimer != null) {
                this.syncTimer.stop();
                this.syncTimer = null;
            }
        }
        this.pbeInfo = null;
        this.onClose();
        object = Editor.class;
        synchronized (Editor.class) {
            if (referenceCount.dereference(this.getClass().getName())) {
                ActionGroup actionGroup = sharedActionGroupMap.get(this.getClass());
                if (actionGroup != null) {
                    actionGroup.clear();
                    sharedActionGroupMap.remove(this.getClass());
                }
                this.onLastClose();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setCore(null);
            this.removeAll();
            this.mainPanel = null;
            return;
        }
    }

    public final void exportNotSupported(EditorPlugin.FileType fileType) throws Exception {
        throw new Exception(UI._("Export to \"{0}\" is not supported", fileType));
    }

    public final C getCore() {
        return this.core;
    }

    public final void setCore(C c) {
        this.core = c;
    }

    public static final synchronized Editor<?> getCurrentEditor() {
        return (Editor)Tabs.getInstance().getSelectedTab();
    }

    @Deprecated
    public final PluginInfo getInfo() {
        return this.info;
    }

    @Deprecated
    public final void setInfo(PluginInfo pluginInfo) {
        this.info = pluginInfo;
    }

    public final MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public final void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public MToolBar.TextPosition getPreferredToolBarTextPosition() {
        return MToolBar.TextPosition.USER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ActionGroup getSharedActionGroup() {
        Class<Editor> clazz = Editor.class;
        synchronized (Editor.class) {
            ActionGroup actionGroup = sharedActionGroupMap.get(this.getClass());
            if (actionGroup == null) {
                actionGroup = this.createSharedActionGroup();
                sharedActionGroupMap.put(this.getClass(), actionGroup);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return actionGroup;
        }
    }

    public boolean getSupportsToolBarUnderTabs() {
        return false;
    }

    public boolean isAsyncLoad() {
        return this.asyncLoad;
    }

    public void setAsyncLoad(boolean bl) {
        this.asyncLoad = bl;
    }

    public boolean isCloseable() {
        return true;
    }

    public boolean isExportMode() {
        return this.exportMode;
    }

    public void setExportMode(boolean bl) {
        this.exportMode = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (bl != this.modified) {
            this.modified = bl;
            this.updateStatusText();
        }
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean bl) {
        this.printing = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void loadFromFile() throws Exception {
        block28: {
            int n;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray;
            block27: {
                if (!(this instanceof EditorIO)) break block28;
                File file = this.metaInfo.getFile();
                boolean bl = file.length() == 0L;
                byArray = null;
                byteArrayOutputStream = null;
                FilterInputStream filterInputStream = null;
                try {
                    block32: {
                        block29: {
                            byte[] byArray2;
                            byte[] byArray3;
                            block31: {
                                InputStream inputStream;
                                Closeable closeable;
                                String string;
                                byte[] byArray4;
                                Map<String, String> map;
                                block30: {
                                    int n2;
                                    DataInputStream dataInputStream;
                                    n = 0;
                                    if (!bl) {
                                        dataInputStream = null;
                                        try {
                                            dataInputStream = new DataInputStream(new FS.BufferedFileInput(file));
                                            n = "MAKAGIGA_DATA".equals(dataInputStream.readUTF());
                                        }
                                        catch (IOException iOException) {
                                            FS.close(dataInputStream);
                                            catch (Throwable throwable) {
                                                FS.close(dataInputStream);
                                                throw throwable;
                                            }
                                        }
                                        FS.close(dataInputStream);
                                    }
                                    filterInputStream = new FS.BufferedFileInput(file);
                                    if (n == 0) break block29;
                                    dataInputStream = new DataInputStream(filterInputStream);
                                    filterInputStream = dataInputStream;
                                    if (!"MAKAGIGA_DATA".equals(dataInputStream.readUTF())) {
                                        throw new Exception("Data header not found");
                                    }
                                    if (!"PROPERTIES".equals(dataInputStream.readUTF())) {
                                        throw new Exception("Data properties not found");
                                    }
                                    int n3 = dataInputStream.readInt();
                                    map = TK.newHashMap(n3);
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        map.put(dataInputStream.readUTF(), dataInputStream.readUTF());
                                    }
                                    if (!"DATA".equals(dataInputStream.readUTF())) {
                                        throw new Exception("Data not found");
                                    }
                                    n2 = dataInputStream.readInt();
                                    byArray4 = new byte[n2];
                                    dataInputStream.readFully(byArray4);
                                    if (!"CHECKSUM".equals(dataInputStream.readUTF())) {
                                        throw new Exception("Data checksum not found");
                                    }
                                    string = dataInputStream.readUTF();
                                    int n4 = dataInputStream.readInt();
                                    byArray3 = new byte[n4];
                                    dataInputStream.readFully(byArray3);
                                    byteArrayOutputStream = new ByteArrayOutputStream(byArray4.length);
                                    if (!string.startsWith("Hmac")) break block30;
                                    closeable = null;
                                    try {
                                        inputStream = new ByteArrayInputStream(byArray4);
                                        closeable = new CryptoUtils.MacInputStream(EditorCrypto.createCipherInputStream(MainWindow.getInstance(), this, this.metaInfo, map, inputStream), this.pbeInfo.createMac(string));
                                        FS.copyStream((InputStream)closeable, byteArrayOutputStream);
                                    }
                                    catch (Throwable throwable) {
                                        FS.close(closeable);
                                        throw throwable;
                                    }
                                    FS.close(closeable);
                                    byArray2 = ((CryptoUtils.MacInputStream)closeable).getMac().doFinal();
                                    break block31;
                                }
                                closeable = null;
                                inputStream = null;
                                try {
                                    closeable = new DigestOutputStream(byteArrayOutputStream, MessageDigest.getInstance(string));
                                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
                                    inputStream = EditorCrypto.createCipherInputStream(MainWindow.getInstance(), this, this.metaInfo, map, byteArrayInputStream);
                                    FS.copyStream(inputStream, (OutputStream)closeable);
                                }
                                finally {
                                    FS.close(inputStream);
                                }
                                byArray2 = ((DigestOutputStream)closeable).getMessageDigest().digest();
                            }
                            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                                throw new Exception(UI._("Invalid password or corrupted data"));
                            }
                            this.asyncLoad = false;
                            byArray = byteArrayOutputStream.toByteArray();
                            ((EditorIO)EditorIO.class.cast(this)).loadFile(new ByteArrayInputStream(byArray), bl);
                            break block32;
                        }
                        ((EditorIO)EditorIO.class.cast(this)).loadFile(filterInputStream, bl);
                    }
                    if (this.asyncLoad) break block27;
                }
                catch (Exception exception) {
                    try {
                        this.pbeInfo = null;
                        FS.close(filterInputStream);
                        throw exception;
                    }
                    catch (Throwable throwable) {
                        int n5;
                        if (!this.asyncLoad) {
                            FS.close(filterInputStream);
                        }
                        CryptoUtils.clear(byArray);
                        if (byteArrayOutputStream != null && (n5 = byteArrayOutputStream.size()) > 0) {
                            byteArrayOutputStream.reset();
                            for (int i = 0; i < n5; ++i) {
                                byteArrayOutputStream.write(0);
                            }
                        }
                        throw throwable;
                    }
                }
                FS.close(filterInputStream);
            }
            CryptoUtils.clear(byArray);
            if (byteArrayOutputStream != null && (n = byteArrayOutputStream.size()) > 0) {
                byteArrayOutputStream.reset();
                for (int i = 0; i < n; ++i) {
                    byteArrayOutputStream.write(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveToFile() throws Exception {
        block14: {
            FilterOutputStream filterOutputStream;
            block13: {
                this.canSaveToFile();
                if (!(this instanceof EditorIO)) break block14;
                filterOutputStream = null;
                try {
                    block15: {
                        File file = this.metaInfo.getFile();
                        this.checkFreeDiskSpace(file);
                        try {
                            VersionControl.create(this.metaInfo, null, 0);
                        }
                        catch (VersionException versionException) {
                            MLogger.exception(versionException);
                        }
                        filterOutputStream = new FS.BufferedFileOutput(file);
                        if (this.pbeInfo == null) break block15;
                        DataOutputStream dataOutputStream = new DataOutputStream(filterOutputStream);
                        filterOutputStream = dataOutputStream;
                        dataOutputStream.writeUTF("MAKAGIGA_DATA");
                        dataOutputStream.writeUTF("PROPERTIES");
                        Map map = TK.newHashMap("VERSION", MApplication.getInternalVersion().toString(), "SALT", CryptoUtils.toString(this.pbeInfo.getSalt()), "TRANSFORMATION", this.pbeInfo.getTransformation(), "COMPRESSION", "NONE");
                        dataOutputStream.writeInt(map.size());
                        for (Map.Entry object2 : map.entrySet()) {
                            dataOutputStream.writeUTF((String)object2.getKey());
                            dataOutputStream.writeUTF((String)object2.getValue());
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.max((int)file.length(), 1024));
                        CryptoUtils.MacOutputStream macOutputStream = null;
                        try {
                            macOutputStream = new CryptoUtils.MacOutputStream(EditorCrypto.createCipherOutputStream(this, byteArrayOutputStream), this.pbeInfo.createMac("HmacSHA1"));
                            ((EditorIO)EditorIO.class.cast(this)).saveFile(macOutputStream);
                        }
                        catch (Throwable byArray) {
                            FS.close(macOutputStream);
                            throw byArray;
                        }
                        FS.close(macOutputStream);
                        dataOutputStream.writeUTF("DATA");
                        dataOutputStream.writeInt(byteArrayOutputStream.size());
                        byteArrayOutputStream.writeTo(dataOutputStream);
                        dataOutputStream.writeUTF("CHECKSUM");
                        dataOutputStream.writeUTF("HmacSHA1");
                        byte[] byArray = macOutputStream.getMac().doFinal();
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        this.updateIndex("");
                        this.updateLocalIndex("");
                        try {
                            VersionControl.deleteAllVersions(this.metaInfo, true);
                        }
                        catch (VersionException versionException) {
                            MLogger.exception(versionException);
                        }
                        DefaultPreview.getInstance().removePreview(file);
                        break block13;
                    }
                    ((EditorIO)EditorIO.class.cast(this)).saveFile(filterOutputStream);
                }
                catch (Throwable throwable) {
                    if (filterOutputStream instanceof FS.BufferedFileOutput && ((Boolean)Vars.treeSyncFile.get()).booleanValue()) {
                        ((FS.BufferedFileOutput)FS.BufferedFileOutput.class.cast(filterOutputStream)).sync();
                    }
                    FS.close(filterOutputStream);
                    if (this.metaInfo != null && this.metaInfo.isFile()) {
                        this.metaInfo.invalidatePreview(true);
                    }
                    throw throwable;
                }
            }
            if (filterOutputStream instanceof FS.BufferedFileOutput && ((Boolean)Vars.treeSyncFile.get()).booleanValue()) {
                ((FS.BufferedFileOutput)FS.BufferedFileOutput.class.cast(filterOutputStream)).sync();
            }
            FS.close(filterOutputStream);
            if (this.metaInfo != null && this.metaInfo.isFile()) {
                this.metaInfo.invalidatePreview(true);
            }
        }
    }

    public void updateActions() {
    }

    public static final synchronized Component getCurrentCore() {
        Editor<?> editor = Editor.getCurrentEditor();
        return editor == null ? null : (Component)editor.getCore();
    }

    public static final <T extends Component> T getCurrentCore(Class<T> clazz) {
        Component component = Editor.getCurrentCore();
        if (component == null) {
            return null;
        }
        if (component.getClass() != clazz) {
            return null;
        }
        return (T)component;
    }

    @Deprecated
    public final synchronized String getStatusText() {
        return this.oldStatusText;
    }

    @Deprecated
    public final synchronized void setStatusText(String string) {
        this.oldStatusText = string;
        if (this.isCurrent()) {
            if (MainWindow.isInstance()) {
                MainWindow.getInstance().setEditorStatusText(string);
            } else {
                MStatusBar.message(string);
            }
        }
    }

    @Deprecated
    public final boolean isCurrent() {
        return Editor.getCurrentEditor() == this;
    }

    @Deprecated
    public final void setStatusText(String string, Object ... objectArray) {
        this.setStatusText(MessageFormat.format(string, objectArray));
    }

    public final synchronized void showLockInfo() {
        if (this.locked && this.doShowLockInfo) {
            this.doShowLockInfo = false;
            MStatusBar.info(UI._("This file is locked. Click the \"Unlock\" button if you want to edit this file."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean sync(boolean bl) {
        if (this.syncTimer != null) {
            this.syncTimer.stop();
        }
        this.syncConfig();
        if (this.isModified()) {
            MLogger.info("editor", "Saving \"%s\"...", this.metaInfo.getFilePath());
            try {
                if (this.metaInfo.isWriteable()) {
                    this.saveToFile();
                    AdvancedProperties.applyPermissions(this.metaInfo, true);
                    Tracker.add(this.metaInfo, TrackerEvent.ID.ITEM_SAVED);
                }
                this.setModified(false);
            }
            catch (Exception exception) {
                if (!bl) {
                    MMessage.error(null, exception, UI._("Could not save file"));
                }
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (!bl) {
                    this.updateStatusText();
                }
            }
        }
        return true;
    }

    public final synchronized void syncConfig() {
        if (this instanceof EditorConfig) {
            Config config = this.getConfigPrivileged();
            Config config2 = this.metaInfo.getConfig();
            ((EditorConfig)EditorConfig.class.cast(this)).saveConfig(config2);
            config.sync();
            if (config2 != null && this.metaInfo.isWriteable()) {
                config2.sync();
            }
        }
    }

    public final synchronized void syncLater() {
        if (this.syncTimer == null) {
            this.syncTimer = new MTimer(MTimer.Format.SECONDS, this.getSyncTimerDelay()){

                @Override
                protected boolean onTimeout() {
                    this.stop();
                    Editor.this.sync(false);
                    return false;
                }
            };
        }
        this.syncTimer.setDelay(MTimer.Format.SECONDS, this.getSyncTimerDelay());
        this.syncTimer.restart();
    }

    @Deprecated
    public void updateStatusText() {
        this.setStatusText(this.modified ? UI._("Modified") : "");
    }

    public boolean onBeforeClose() {
        return true;
    }

    public void onClose() {
    }

    public void onLastClose() {
    }

    public void showPopupMenu(String string, InputEvent inputEvent) {
        if (this instanceof PluginMenu) {
            MMenu mMenu = new MMenu();
            ((PluginMenu)PluginMenu.class.cast(this)).updateMenu(string, mMenu);
            mMenu.showPopup(inputEvent);
        }
    }

    @Override
    public String getGlobalEntry(String string) {
        PluginInfo pluginInfo = this.info == null ? this.metaInfo.getFS().getInfo() : this.info;
        return string + "." + pluginInfo.getID();
    }

    @Override
    public synchronized boolean isLocked() {
        return this.locked;
    }

    @Override
    public synchronized void setLocked(boolean bl) {
        this.doShowLockInfo = bl;
        this.locked = bl;
    }

    @Override
    public void afterPrint(PrintInfo.PrintResult printResult) {
        if (this.componentColorsState == null) {
            return;
        }
        if (this.core instanceof JComponent) {
            ((JComponent)JComponent.class.cast(this.core)).setDoubleBuffered(true);
        }
        this.setPrinting(false);
        if (this.componentColorsState.get1() != null) {
            ((Component)this.core).setBackground(this.componentColorsState.get1());
        }
        if (this.componentColorsState.get2() != null) {
            ((Component)this.core).setForeground(this.componentColorsState.get2());
        }
        this.componentColorsState = null;
        if (TagsUtils.AutoTag.PRINTED.isEnabled() && (printResult == PrintInfo.PrintResult.COMPLETE || printResult == PrintInfo.PrintResult.IN_PROGRESS)) {
            TagsUtils.addTag(this.metaInfo, TagsUtils.AutoTag.PRINTED);
            this.metaInfo.refresh(false);
        }
    }

    @Override
    public void beforePrint() {
        this.componentColorsState = Tuple.of(((Component)this.core).getBackground(), ((Component)this.core).getForeground());
        ((Component)this.core).setBackground(Color.WHITE);
        ((Component)this.core).setForeground(Color.BLACK);
        if (this.core instanceof JComponent) {
            ((JComponent)JComponent.class.cast(this.core)).setDoubleBuffered(false);
        }
        this.setPrinting(true);
    }

    @Override
    public Printable getPrintable(Flags flags) throws PrinterException {
        if (this instanceof EditorPrint) {
            return ((EditorPrint)EditorPrint.class.cast(this)).getPrintable(flags, this.getPrintHeader(flags.isSet(8L)), this.getPrintFooter(flags.isSet(4L)));
        }
        return null;
    }

    @Override
    public Component getPrintComponent() {
        return this.core;
    }

    @Override
    public MessageFormat getPrintHeader(boolean bl) {
        return bl ? new MessageFormat("{0} - " + this.getPrintTitle()) : null;
    }

    @Override
    public MessageFormat getPrintFooter(boolean bl) {
        return bl ? new MessageFormat(MDate.now().formatDateTime(0, 3)) : null;
    }

    @Override
    public int getPrintingCapabilities() {
        return 12;
    }

    @Override
    public String getPrintTitle() {
        return this.metaInfo.toString();
    }

    @Override
    public PrintInfo.PrintResult printDocument(Flags flags) throws PrinterException {
        if (this instanceof EditorPrint) {
            return ((EditorPrint)EditorPrint.class.cast(this)).printDocument(flags, this.getPrintHeader(flags.isSet(8L)), this.getPrintFooter(flags.isSet(4L)));
        }
        return PrintInfo.PrintResult.ERROR;
    }

    protected void canSaveToFile() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTo(OutputStream outputStream) throws IOException {
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(this.getMetaInfo().getFile());
            FS.copyStream(bufferedFileInput, outputStream);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
    }

    protected ActionGroup createSharedActionGroup() {
        return new ActionGroup();
    }

    protected MPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = MPanel.createBorderPanel();
            this.mainPanel.setOpaque(false);
            this.addCenter(this.mainPanel);
        }
        return this.mainPanel;
    }

    protected void setMetaInfo(String string, MIcon mIcon) {
        this.setMetaInfo(MetaInfo.createDummy(string, mIcon));
    }

    protected void showPopupMenu(String string, MouseEvent mouseEvent) {
        this.showPopupMenu(string, (InputEvent)mouseEvent);
    }

    protected void updateIndex(Object ... objectArray) {
        try {
            Index.update(this.getMetaInfo(), objectArray);
        }
        catch (SecurityException securityException) {
            MLogger.warning("core", "Search index disabled by Security Manager: %s", securityException.getMessage());
        }
    }

    protected void updateIndex(StringList stringList) {
        Index.update(this.getMetaInfo(), stringList.toArray());
    }

    protected boolean updateLocalIndex(Object ... objectArray) {
        return Index.updateLocal(this.getMetaInfo(), objectArray);
    }

    protected boolean updateLocalIndex(StringList stringList) {
        return this.updateLocalIndex(stringList.toArray());
    }

    private void checkFreeDiskSpace(File file) throws IOException {
        long l;
        while ((l = file.getFreeSpace()) != 0L && l < 16384L) {
            String string = UI._("No free disk space to save\n\"{0}\"", file);
            if (MMessage.customConfirm(null, MIcon.stock("ui/warning"), new MActionInfo(UI._("Retry"), "ui/save"), new MActionInfo(UI._("Cancel (all unsaved changes will be lost!)"), "ui/cancel"), string)) continue;
            throw new IOException(string);
        }
    }

    private Config getConfigPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Config.getDefault();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Config>(){

            @Override
            public Config run() {
                return Config.getDefault();
            }
        });
    }

    private int getSyncTimerDelay() {
        int n;
        int n2 = n = (Boolean)Vars.treePreview.get() != false ? 10 : 5;
        if (FS.isPortable()) {
            n *= 6;
        }
        return n;
    }
}

