/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import org.makagiga.commons.MComponent;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorAnnotation;

public final class AnnotationBar
extends MToolBar {
    private static MGuardedObject<AnnotationBar> _guardedInstance;

    public static synchronized AnnotationBar getInstance() {
        if (_guardedInstance == null) {
            _guardedInstance = new MGuardedObject<AnnotationBar>(new AnnotationBar(), "org.makagiga.editors.AnnotationBar", PermissionInfo.ThreatLevel.LOW, "Annotation Bar");
        }
        return _guardedInstance.get();
    }

    public void setEditor(Editor<?> editor) {
        int n = this.getComponentCount();
        this.removeAll();
        if (editor instanceof EditorAnnotation) {
            ((EditorAnnotation)EditorAnnotation.class.cast(editor)).updateAnnotationBar();
            this.install(editor);
        } else {
            this.uninstall();
        }
        if (this.getComponentCount() != n) {
            this.validate();
        }
    }

    private AnnotationBar() {
        super(1, MIcon.Size.SMALL);
        this.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.setVisible(false);
    }

    private void install(Editor<?> editor) {
        if (this.getParent() != editor) {
            this.uninstall();
            if ((((EditorAnnotation)EditorAnnotation.class.cast(editor)).getAnnotationCapabilities() & 1) != 0) {
                editor.addWest(this);
                this.showLineBorder(MLineBorder.Position.RIGHT);
            } else {
                editor.addEast(this);
                this.showLineBorder(MLineBorder.Position.LEFT);
            }
        }
        this.setVisible(true);
    }

    private void uninstall() {
        MComponent.removeFromParent(this, false);
        this.setVisible(false);
    }
}

