/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.calendar;

import java.awt.Window;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MCalendarPanel;
import org.makagiga.commons.MDate;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueEvent;
import org.makagiga.commons.ValueListener;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.calendar.CalendarComponent;
import org.makagiga.desktop.calendar.CalendarWidgetPlugin;
import org.makagiga.tools.summary.SummaryData;

public final class CalendarWidget
extends Widget
implements Focusable,
Observer {
    private boolean idle;
    private CalendarComponent calendarComponent;

    public CalendarWidget(CalendarWidgetPlugin calendarWidgetPlugin) {
        super(calendarWidgetPlugin.getInfo());
        this.calendarComponent = new CalendarComponent(calendarWidgetPlugin);
        this.calendarComponent.addValueListener(new ValueListener<Date>(){

            @Override
            public void valueChanged(ValueEvent<Date> valueEvent) {
                if (valueEvent.isReason((Object)MCalendarPanel.ValueChangeReason.AUTO_UPDATE)) {
                    CalendarWidget.this.updateTitle();
                }
            }
        });
        this.addCenter(this.calendarComponent);
        this.setResizable(true);
        this.idle = SummaryData.getInstance().isIdle();
        this.updateTitle();
    }

    @Override
    public void focus() {
        MCalendarPanel mCalendarPanel = this.getCalendarComponent();
        if (mCalendarPanel != null) {
            mCalendarPanel.getDateSpinner().requestFocusInWindow();
        }
    }

    public MCalendarPanel getCalendarComponent() {
        return this.calendarComponent;
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onRestoreSession() throws Exception {
        this.calendarComponent.setAutoUpdate(true);
        SummaryData.getInstance().addObserver(this);
    }

    @Override
    public void onSaveSession() throws Exception {
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.idle != SummaryData.getInstance().isIdle()) {
            this.idle = true;
            this.updateTitle();
        }
    }

    @Override
    protected void onSettings(Window window) {
    }

    @Override
    protected void onShutDown() {
        super.onShutDown();
        SummaryData.getInstance().removeObserver(this);
        if (this.calendarComponent != null) {
            this.calendarComponent.setAutoUpdate(false);
            this.calendarComponent = null;
        }
    }

    @Override
    protected void updateWidgetUI() {
        if (this.calendarComponent != null) {
            this.calendarComponent.updateColors();
        }
    }

    private void updateTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.idle) {
            stringBuilder.append('[').append(UI._("Please Wait...")).append("] ");
        }
        stringBuilder.append(UI._("{0} - Calendar", MDate.now().formatDate(2)));
        this.setTitle(stringBuilder.toString());
    }
}

