/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.calendar;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MCalendarPanel;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.desktop.calendar.CalendarWidgetPlugin;
import org.makagiga.desktop.ui.WidgetDesktopPaneUI;
import org.makagiga.editors.todo.TodoEditorPlugin;
import org.makagiga.fs.MetaInfo;
import org.makagiga.todo.Task;
import org.makagiga.tools.summary.SummaryData;
import org.makagiga.web.wiki.WikiPanel;

final class CalendarComponent
extends MCalendarPanel {
    private final CalendarWidgetPlugin plugin;

    @Override
    protected MMenu onClick(int n) {
        MDate mDate = (MDate)this.getSelectedDate();
        String string = this.plugin.getConfig().read("x.monthNames2", null);
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        mMenu.addTitle(mDate.fancyFormat(1, false));
        mMenu.add(new DateAction(UI._("Show Information for This Day"), "ui/info", mDate, this.plugin.getValue("onThisDay"), string));
        mMenu.add(new DateAction(UI._("News"), null, mDate, this.plugin.getValue("news"), string));
        mMenu.addSeparator();
        mMenu.add(this.plugin.createTaskMenu(this));
        boolean bl = false;
        MCalendar mCalendar = mDate.toCalendar();
        SummaryData summaryData = SummaryData.getInstance();
        for (SummaryData.Node node : summaryData.getTaskStateMap().values()) {
            for (SummaryData.Node node2 : node.list(MV.MODEL)) {
                for (SummaryData.Node node3 : node2.list(MV.MODEL)) {
                    MCalendar mCalendar2;
                    Task task = node3.getTask();
                    MDate mDate2 = task.getDateTime();
                    if (!mDate2.isValid() || (mCalendar2 = mDate2.toCalendar()).getDay() != n || !mCalendar2.isSameField(mCalendar, 2, 1)) continue;
                    if (!bl) {
                        mMenu.addTitle(UI._("Tasks for This Day"));
                        bl = true;
                    }
                    mMenu.add(new ShowTaskAction(node2.getMetaInfo(), task));
                }
            }
        }
        return mMenu;
    }

    CalendarComponent(CalendarWidgetPlugin calendarWidgetPlugin) {
        this.plugin = calendarWidgetPlugin;
        this.setTodayButtonVisible(false);
        this.getInfoLabel().setIcon(null);
        this.updateColors();
    }

    void updateColors() {
        CoolHeader coolHeader = this.getInfoLabel();
        coolHeader.setBackground(WidgetDesktopPaneUI.getDesktopBackground());
        coolHeader.setForeground(WidgetDesktopPaneUI.getDesktopForeground());
    }

    private static final class ShowTaskAction
    extends MAction {
        private final MetaInfo metaInfo;
        private final Task task;

        @Override
        public void onAction() {
            TodoEditorPlugin.showTask(this.metaInfo, this.task);
        }

        private ShowTaskAction(MetaInfo metaInfo, Task task) {
            super(task.getSummary().isEmpty() ? "<" + UI._("No Summary") + ">" : TK.centerSqueeze(task.getSummary(), 128));
            this.setLongDescription(metaInfo.toString());
            this.metaInfo = metaInfo;
            this.task = task;
        }
    }

    private static final class DateAction
    extends MAction {
        private final MDate date;
        private final String monthNames2;
        private final String template;

        @Override
        public void onAction() {
            String[] stringArray;
            if (TK.isEmpty(this.template)) {
                return;
            }
            if (this.monthNames2 == null) {
                stringArray = DateFormatSymbols.getInstance(Locale.US).getMonths();
            } else {
                stringArray = this.monthNames2.split(" ");
                if (stringArray.length != 12) {
                    stringArray = DateFormatSymbols.getInstance(Locale.US).getMonths();
                }
            }
            SimpleDateFormat simpleDateFormat = this.monthNames2 == null ? new SimpleDateFormat("", Locale.US) : new SimpleDateFormat("");
            String string = this.template;
            String[][] stringArrayArray = new String[][]{{"d", "{@day-of-month}"}, {"dd", "{@2-digit-day-of-month}"}, {"H", "{@hour}"}, {"MM", "{@2-digit-month}"}, {"MMMM", "{@full-month-name}"}, {"yyyy", "{@4-digit-year}"}};
            MDate mDate = MDate.now();
            for (int i = 0; i < stringArrayArray.length; ++i) {
                String string2 = stringArrayArray[i][0];
                String string3 = stringArrayArray[i][1];
                simpleDateFormat.applyPattern(string2);
                String string4 = string2.equals("H") ? simpleDateFormat.format(mDate) : simpleDateFormat.format(this.date);
                string = string.replace(string3, TK.escapeURL(string4));
                if (!string3.endsWith("-name}")) continue;
                string3 = "{@lower-case-" + string3.substring(2);
                string = string.replace(string3, TK.escapeURL(string4.toLowerCase()));
            }
            string = string.replace("{@full-month-name-2}", TK.escapeURL(stringArray[simpleDateFormat.getCalendar().get(2)]));
            WikiPanel.openURI(this.getSourceWindow(), string, this.getName());
        }

        private DateAction(String string, String string2, MDate mDate, String string3, String string4) {
            super(string, string2);
            this.date = mDate;
            this.template = string3;
            this.monthNames2 = string4;
            try {
                URL uRL = new URL(string3);
                this.setHTMLHelp(MURLButton.getLinkToolTipText(uRL.getHost()));
            }
            catch (MalformedURLException malformedURLException) {
                MLogger.warning("plugin", malformedURLException.toString());
            }
        }
    }
}

