/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDesktopPane;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetInternalFrame;

public final class Pager
extends MPanel {
    private int current;
    private int number = 2;
    private static Pager _instance;

    public MMenu createMoveToDesktopMenu(WidgetInternalFrame widgetInternalFrame) {
        MMenu mMenu = new MMenu(UI._("Move to Desktop"));
        if (MDesktopPane.isLocked(widgetInternalFrame)) {
            mMenu.setEnabled(false);
        } else {
            mMenu.addMenuListener(new StaticMenuAdapter(widgetInternalFrame));
        }
        return mMenu;
    }

    public static synchronized Pager getInstance() {
        if (_instance == null) {
            _instance = new Pager();
        }
        return _instance;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int n) {
        if (n < 0 || n > this.number - 1) {
            this.current = 0;
        }
        this.current = n;
        this.updateView();
    }

    public String getDisplayName(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    public int getNumber() {
        return this.number;
    }

    public void readConfig(Config config) {
        this.setCurrent(config.readInt("Desktop.current", 0));
    }

    public void writeConfig(Config config) {
        config.write("Desktop.current", this.current);
    }

    private Pager() {
        super(null);
        this.setLayout(new GridLayout(1, this.number));
        this.setOpaque(UI.isGTK());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.number; ++i) {
            Button button = new Button(this, i);
            this.add(button);
            buttonGroup.add(button);
        }
    }

    private void updateView() {
        for (WidgetInternalFrame jComponent : Desktop.getInstance()) {
            jComponent.updateVirtualDesktop();
        }
        for (Button button : ContainerIterator.create(this, Button.class)) {
            if (button.page != this.current) continue;
            button.setSelected(true);
            break;
        }
    }

    private static final class StaticMenuAdapter
    extends MMenuAdapter {
        private final WeakReference<WidgetInternalFrame> frameRef;

        @Override
        protected void onSelect(MMenu mMenu) {
            mMenu.removeAll();
            WidgetInternalFrame widgetInternalFrame = (WidgetInternalFrame)this.frameRef.get();
            if (widgetInternalFrame == null) {
                return;
            }
            Widget widget = widgetInternalFrame.getWidget();
            if (widget == null) {
                return;
            }
            Pager pager = Pager.getInstance();
            for (int i = 0; i < pager.getNumber(); ++i) {
                mMenu.addRadioButton(new MoveToDesktopAction(widget, i), i == widget.getDesktopNumber());
            }
        }

        private StaticMenuAdapter(WidgetInternalFrame widgetInternalFrame) {
            super(true);
            this.frameRef = TK.newWeakRef(widgetInternalFrame);
        }
    }

    private static final class ButtonDropTarget
    extends DropTarget {
        @Override
        public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            super.dragEnter(dropTargetDragEvent);
            this.doSelect(dropTargetDragEvent);
        }

        @Override
        public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            super.dragOver(dropTargetDragEvent);
            this.doSelect(dropTargetDragEvent);
        }

        private ButtonDropTarget() {
        }

        private void doSelect(DropTargetDragEvent dropTargetDragEvent) {
            Button button = (Button)this.getComponent();
            if (!button.isSelected() && button.contains(dropTargetDragEvent.getLocation())) {
                TK.fireActionPerformed(button, button.getActionListeners());
            }
            dropTargetDragEvent.rejectDrag();
        }
    }

    private static final class Button
    extends MToggleButton {
        private final int page;

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            Container container = this.getParent();
            if (container == null) {
                return null;
            }
            return new Point(container.getWidth() - this.getX(), this.getY());
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Pager pager = Pager.getInstance();
            HTMLBuilder hTMLBuilder = new HTMLBuilder();
            hTMLBuilder.beginTag("html");
            hTMLBuilder.emit(UI._("Desktop: {0}", "<b>" + HTMLBuilder.escape(pager.getDisplayName(this.page)) + "</b>"));
            TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (WidgetInternalFrame object : Desktop.getInstance()) {
                if (object.getWidget().getDesktopNumber() != this.page) continue;
                String string = object.getTitle();
                if (string == null) {
                    string = "";
                }
                treeSet.add(string);
            }
            if (treeSet.isEmpty()) {
                hTMLBuilder.doubleTag("p", "<i>" + HTMLBuilder.escape(UI._("No Widgets")) + "</i>", "style", "margin-top: 5px");
            } else {
                hTMLBuilder.beginTag("ul", "style", "margin-left: 10px; margin-right: 0px; margin-top: 5px; margin-bottom: 0px");
                for (String string : treeSet) {
                    hTMLBuilder.doubleTag("li", HTMLBuilder.escape(TK.centerSqueeze(string)), new Object[0]);
                }
                hTMLBuilder.endTag("ul");
            }
            hTMLBuilder.endTag("html");
            return hTMLBuilder.toString();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (UI.isSubstance()) {
                this.putClientProperty("substancelaf.buttonnominsize", true);
            }
        }

        @Override
        protected void onClick() {
            Pager.getInstance().setCurrent(this.page);
        }

        private Button(Pager pager, int n) {
            this.page = n;
            this.setCursor(12);
            this.setDropTarget(new ButtonDropTarget());
            this.setRequestFocusEnabled(false);
            this.setStyle("margin: 4 10 4 10");
            this.setText(pager.getDisplayName(n));
            this.setToolTipText("");
        }
    }

    public static final class MoveToDesktopAction
    extends MDataAction.Weak<Widget> {
        private final int number;

        public MoveToDesktopAction(Widget widget, int n) {
            super(widget, Pager.getInstance().getDisplayName(n));
            this.number = n;
        }

        @Override
        public void onAction() {
            Widget widget = (Widget)this.get();
            if (widget != null) {
                widget.setDesktopNumber(this.number);
            }
        }
    }
}

