/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.Item;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MFontButton;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MTable;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.SecureProperty;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueEvent;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.mv.BooleanRenderer;
import org.makagiga.commons.mv.ColorEditor;
import org.makagiga.commons.mv.ColorRenderer;

public final class ConsoleConfig
extends MTable<Model>
implements Config.GlobalEntry {
    private final BooleanRenderer booleanRenderer;
    private final ColorRenderer<Object> colorRenderer;
    private final MRenderer<Font> fontRenderer;
    private final MRenderer<Object> renderer;

    public ConsoleConfig() {
        super(new Model());
        this.getColumnManager().setDefaultColumnOrder(0, 1, 2, 3);
        this.getColumnManager().updateProperties();
        this.setAutoCreateRowSorter(true);
        this.setSelectionMode(0);
        this.booleanRenderer = new BooleanRenderer();
        this.colorRenderer = new ColorRenderer();
        this.colorRenderer.setFlat(true);
        this.fontRenderer = new MRenderer<Font>(){

            @Override
            protected void onRender(Font font) {
                this.setText(FontProperty.toString(font));
                ConsoleConfig consoleConfig = (ConsoleConfig)this.getTable();
                Value value = (Value)((Model)consoleConfig.getModel()).getRowAt(this.getModelRow());
                this.setStyle(((PropertyAccess)value.getValue()).isDefaultValue() ? "font-weight: normal" : "font-weight: bold");
            }
        };
        this.renderer = new MRenderer<Object>(){

            @Override
            protected void onRender(Object object) {
                this.setText(String.valueOf(object));
                ConsoleConfig consoleConfig = (ConsoleConfig)this.getTable();
                Value value = (Value)((Model)consoleConfig.getModel()).getRowAt(this.getModelRow());
                this.setStyle(((PropertyAccess)value.getValue()).isDefaultValue() ? "font-weight: normal" : "font-weight: bold");
            }
        };
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 1 || n3 == 2) {
            int n4 = this.convertRowIndexToModel(n);
            Value value = (Value)((Model)this.getModel()).getRowAt(n4);
            Class clazz = ((PropertyAccess)value.getValue()).getType();
            Object object = this.getValueAt(n, n2);
            if (clazz == Boolean.class) {
                BooleanRenderer booleanRenderer = new BooleanRenderer();
                booleanRenderer.setSelected((Boolean)object);
                return new DefaultCellEditor(booleanRenderer);
            }
            if (clazz == Color.class) {
                ColorEditor colorEditor = new ColorEditor();
                if (n3 == 1) {
                    Color color = (Color)this.getValueAt(n, 2);
                    colorEditor.setDefaultColor(color);
                }
                return colorEditor;
            }
            if (object instanceof Enum) {
                Value value2 = (Value)((Model)this.getModel()).getRowAt(n4);
                PropertyAccess propertyAccess = (PropertyAccess)value2.getValue();
                EnumProperty enumProperty = propertyAccess instanceof SecureProperty ? (EnumProperty)((SecureProperty)SecureProperty.class.cast(propertyAccess)).getProperty() : (EnumProperty)propertyAccess;
                MComboBox<Enum> mComboBox = new MComboBox<Enum>();
                if (enumProperty.hasEnumValues()) {
                    mComboBox.addAllItems(enumProperty.getEnumValues());
                    mComboBox.setSelectedItem(enumProperty.get());
                }
                return new DefaultCellEditor(mComboBox);
            }
            if (clazz == Font.class) {
                return new FontEditor();
            }
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 1 || n3 == 2) {
            int n4 = this.convertRowIndexToModel(n);
            Value value = (Value)((Model)this.getModel()).getRowAt(n4);
            Class clazz = ((PropertyAccess)value.getValue()).getType();
            Object t = ((PropertyAccess)value.getValue()).get();
            if (clazz == Boolean.class) {
                this.booleanRenderer.setEnabled(n3 == 1);
                return this.booleanRenderer;
            }
            if (clazz == Color.class) {
                Color color = (Color)t;
                this.colorRenderer.setColor(color);
                this.colorRenderer.setText(ColorProperty.toString(color));
                return this.colorRenderer;
            }
            if (clazz == Font.class) {
                return this.fontRenderer;
            }
        }
        return this.renderer;
    }

    public void updateModel() {
        ((Model)this.getModel()).update();
    }

    @Override
    public String getGlobalEntry(String string) {
        return "ConsoleConfig." + string;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
    }

    private static final class FontEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Object value;

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = object;
            MFontButton mFontButton = new MFontButton((Font)object);
            mFontButton.addValueListener(new ValueListener<Font>(){

                @Override
                public void valueChanged(ValueEvent<Font> valueEvent) {
                    FontEditor.this.value = valueEvent.getNewValue();
                    FontEditor.this.stopCellEditing();
                }
            });
            return mFontButton;
        }

        private FontEditor() {
        }
    }

    protected static final class Value
    extends Item<PropertyAccess<Object>> {
        private Value(PropertyAccess<Object> propertyAccess, String string) {
            super(propertyAccess, string);
        }
    }

    protected static final class Model
    extends AbstractListTableModel<Value> {
        private static final int NAME_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;
        private static final int DEFAULT_VALUE_COLUMN = 2;
        private static final int TYPE_COLUMN = 3;

        @Override
        public Object getValueAt(int n, int n2) {
            Value value = (Value)this.getRowAt(n);
            switch (n2) {
                case 0: {
                    return value.getText();
                }
                case 1: {
                    return ((PropertyAccess)value.getValue()).get();
                }
                case 2: {
                    return ((PropertyAccess)value.getValue()).getDefaultValue();
                }
                case 3: {
                    PropertyAccess propertyAccess = (PropertyAccess)value.getValue();
                    StringBuilder stringBuilder = new StringBuilder(Property.getTypeAsString(propertyAccess));
                    if (MLogger.isDeveloper() && propertyAccess instanceof SecureProperty) {
                        stringBuilder.append(", S");
                    }
                    if (propertyAccess instanceof EnumProperty) {
                        stringBuilder.insert(0, "Enum (").append(')');
                    }
                    return stringBuilder.toString();
                }
            }
            throw new WTFError("Unknown column: " + n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                Value value = (Value)this.getRowAt(n);
                try {
                    if (value.getText().startsWith("Kiosk.") && !MMessage.simpleConfirm(null)) {
                        return;
                    }
                    Value value2 = this.createCopyForUndo(value);
                    if (object instanceof Boolean || object instanceof Color || object instanceof Enum || object instanceof Font) {
                        ((PropertyAccess)value.getValue()).set(object);
                    } else {
                        ((PropertyAccess)value.getValue()).parse(object.toString());
                    }
                    this.fireTableRowsUpdated(n, n);
                    if (!((Object)((PropertyAccess)value.getValue())).equals(value2.getValue())) {
                        this.fireUndoableEditHappened(new AbstractListTableModel.ChangeUndo(value2, this.createCopyForUndo(value), n));
                    }
                }
                catch (SecurityException securityException) {
                    MMessage.error(null, securityException);
                }
                catch (ParseException parseException) {
                    MMessage.error(null, parseException);
                }
                Config.getDefault().sync();
            }
        }

        @Override
        protected Value createCopyForUndo(Value value) {
            return new Value((PropertyAccess)((PropertyAccess)value.getValue()).clone(), value.getText());
        }

        private Model() {
            super(new AbstractListTableModel.ColumnInfo(UI._("Name"), false, "NAME"), new AbstractListTableModel.ColumnInfo(UI._("Value"), true, "VALUE"), new AbstractListTableModel.ColumnInfo(UI._("Default Value"), false, "DEFAULT_VALUE"), new AbstractListTableModel.ColumnInfo(UI._("Type"), false, "TYPE"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            try {
                this.setEventsEnabled(false);
                this.clear();
                Config config = Config.getDefault();
                for (Map.Entry<String, PropertyAccess<?>> entry : config.getRegisteredProperties().entrySet()) {
                    this.addRow(new Value(entry.getValue(), entry.getKey()));
                }
            }
            finally {
                this.setEventsEnabled(true);
                this.fireTableDataChanged();
            }
        }
    }
}

