/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.validator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.validator.ValidatorMessage;
import org.makagiga.commons.validator.ValidatorSupport;

public abstract class Validator<V>
extends InputVerifier
implements Serializable {
    private boolean enabled = true;
    private JComponent component;
    private MessageType messageType = MessageType.ERROR;
    private static final StaticHandler staticHandler = new StaticHandler();

    public Validator() {
    }

    public Validator(JComponent jComponent) {
        this.setComponent(jComponent);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent jComponent) {
        if (this.component != null) {
            this.component.removeFocusListener(staticHandler);
            this.uninstall();
        }
        this.component = jComponent;
        if (this.component != null) {
            this.component.addFocusListener(staticHandler);
            this.install();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean validate() {
        Object object;
        Object object2;
        boolean bl;
        if (!this.enabled) {
            return true;
        }
        MDialog mDialog = this.getDialog();
        if (mDialog == null) {
            return true;
        }
        boolean bl2 = false;
        ValidatorMessage validatorMessage = mDialog.getValidatorMessage();
        try {
            this.setMessageType(MessageType.ERROR);
            bl = this.isValid();
            if (!bl && validatorMessage != null) {
                bl2 = true;
                validatorMessage.validatedBy = this;
                validatorMessage.setIcon(null);
                validatorMessage.setText(null);
                validatorMessage.setToolTipText(null);
            }
        }
        catch (Exception exception) {
            object2 = exception.getMessage();
            if (validatorMessage != null) {
                bl2 = true;
                validatorMessage.validatedBy = this;
                validatorMessage.setToolTipText(null);
                if (this.component != null && (object = this.component.getAccessibleContext()) != null) {
                    validatorMessage.setToolTipText(((AccessibleContext)object).getAccessibleName());
                }
                switch (this.messageType) {
                    case ERROR: {
                        validatorMessage.setErrorMessage((String)object2);
                        break;
                    }
                    case INFO: {
                        validatorMessage.setInfoMessage((String)object2);
                        break;
                    }
                    case WARNING: {
                        validatorMessage.setWarningMessage((String)object2);
                        break;
                    }
                    default: {
                        throw new WTFError(this.messageType);
                    }
                }
            }
            bl = false;
        }
        if (validatorMessage != null) {
            Container container = validatorMessage.getParent();
            if (bl) {
                if (validatorMessage.isVisible() && (validatorMessage.validatedBy == this || TK.isEmpty(validatorMessage.getText()))) {
                    if (!(container instanceof JLayeredPane) && container != null) {
                        int n = validatorMessage.getPreferredSize().height;
                        mDialog.setHeight(mDialog.getHeight() - n);
                    }
                    validatorMessage.setVisible(false);
                }
            } else if (bl2 && !TK.isEmpty(validatorMessage.getText())) {
                validatorMessage.setVisible(true);
                object2 = AutoCompletion.getCurrentTextComponent();
                if (object2 == this.component) {
                    AutoCompletion.hidePopupWindow();
                }
                if (container instanceof JLayeredPane) {
                    if (this.component != null) {
                        object = MScrollPane.getScrollPane(this.component);
                        Rectangle rectangle = SwingUtilities.convertRectangle(object != null ? ((Component)object).getParent() : this.component.getParent(), object != null ? ((Component)object).getBounds() : this.component.getBounds(), mDialog.getContentPane());
                        int n = rectangle.y + this.component.getHeight() - 6;
                        validatorMessage.setLocation(rectangle.x + 5, n);
                        validatorMessage.setSize(validatorMessage.getPreferredSize());
                    } else {
                        validatorMessage.setLocation(0, 0);
                        validatorMessage.setSize(validatorMessage.getPreferredSize());
                    }
                } else if (container != null) {
                    int n = validatorMessage.getPreferredSize().height;
                    mDialog.setHeight(mDialog.getHeight() + n);
                }
            }
        }
        if (mDialog.getOKButton() != null) {
            mDialog.getOKButton().setEnabled(bl || this.messageType != MessageType.ERROR);
        }
        return bl;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        return this.validate();
    }

    protected MDialog getDialog() {
        if (this.component == null) {
            MLogger.debug("validator", "Null component");
            return null;
        }
        Window window = UI.windowFor(this.component);
        return window instanceof MDialog ? (MDialog)window : null;
    }

    protected abstract V getValue();

    protected abstract void install();

    protected abstract void uninstall();

    protected abstract boolean isValid() throws Exception;

    protected final boolean revalidate() {
        MDialog mDialog = this.getDialog();
        if (mDialog == null) {
            return true;
        }
        ValidatorSupport validatorSupport = mDialog.getValidatorSupport();
        if (validatorSupport != null) {
            return validatorSupport.validate(mDialog);
        }
        return true;
    }

    protected final void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    private static final class StaticHandler
    implements FocusListener {
        private StaticHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JComponent jComponent = (JComponent)focusEvent.getSource();
            Window window = UI.windowFor(jComponent);
            if (window instanceof MDialog) {
                MDialog mDialog = (MDialog)window;
                mDialog.getValidatorSupport().validate(mDialog);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MDialog mDialog;
            ValidatorMessage validatorMessage;
            JComponent jComponent = (JComponent)focusEvent.getSource();
            Window window = UI.windowFor(jComponent);
            if (window instanceof MDialog && (validatorMessage = (mDialog = (MDialog)window).getValidatorMessage()) != null) {
                validatorMessage.setVisible(false);
            }
        }
    }

    public static enum MessageType {
        ERROR,
        INFO,
        WARNING;

    }
}

