/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.transition;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.makagiga.commons.Benchmark;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.transition.FadeTransition;
import org.makagiga.commons.transition.ImageView;
import org.makagiga.commons.transition.Transition;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class TransitionPanel
extends MPanel {
    private transient ImageView from;
    private transient ImageView to;
    private int tooSlowCount;
    private transient Timeline timeline;
    private Transition transition = new FadeTransition();
    private static final String CONSTRAINTS_PROPERTY = "org.makagiga.commons.transition.TransitionPanel.constraints";

    public TransitionPanel() {
        super(new CardLayout());
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = TK.checkNull(transition);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        if (this.timeline != null) {
            return false;
        }
        return super.isOptimizedDrawingEnabled();
    }

    public void showCard(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CONSTRAINTS_PROPERTY);
        if (object instanceof String) {
            this.showCard(object.toString());
        }
    }

    @Override
    public void showCard(String string) {
        JComponent jComponent;
        if (this.timeline != null) {
            this.transition.stop(this, this.timeline);
            this.timeline = null;
        }
        if ((jComponent = this.findVisible()) != null && string.equals(jComponent.getClientProperty(CONSTRAINTS_PROPERTY))) {
            return;
        }
        if (this.tooSlowCount > 5) {
            super.showCard(string);
            this.onTimelineDone();
            return;
        }
        if (!((Boolean)UI.animations.get()).booleanValue() || this.transition == Transition.NO_TRANSITION) {
            super.showCard(string);
            this.onTimelineDone();
            return;
        }
        long l = 0L;
        Benchmark benchmark = Benchmark.begin("create-from");
        this.from = new ImageView(jComponent);
        l += benchmark.elapsedMS();
        super.showCard(string);
        JComponent jComponent2 = this.findByConstraints(string);
        benchmark = Benchmark.begin("create-to");
        this.to = new ImageView(jComponent2);
        if ((l += benchmark.elapsedMS()) > 500L) {
            MLogger.warning("core", "System too slow for component transitions (took %d ms)", l);
            ++this.tooSlowCount;
        }
        this.timeline = new Timeline();
        this.timeline.setDuration(this.transition.getDuration());
        if (this.from != null && this.to != null) {
            this.transition.setup(this, this.timeline, this.from, this.to);
        }
        this.timeline.addCallback(new UIThreadTimelineCallbackAdapter(){

            @Override
            public void onTimelinePulse(float f, float f2) {
                TransitionPanel.this.repaint();
            }

            @Override
            public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                if (timelineState2 == Timeline.TimelineState.DONE) {
                    TransitionPanel.this.from = TK.dispose(TransitionPanel.this.from);
                    TransitionPanel.this.to = TK.dispose(TransitionPanel.this.to);
                    TransitionPanel.this.timeline = null;
                    TransitionPanel.this.onTimelineDone();
                    TransitionPanel.this.repaint();
                }
            }
        });
        this.transition.start(this, this.timeline);
    }

    public void showNextCard() {
        int n = this.getComponentCount();
        if (n == 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.getComponent(i).isVisible()) continue;
            this.showCard((JComponent)this.getComponent((i + 1) % n));
            break;
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("String constraints expected");
        }
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("JComponent expected");
        }
        super.addImpl(component, object, n);
        ((JComponent)JComponent.class.cast(component)).putClientProperty(CONSTRAINTS_PROPERTY, object);
    }

    protected void onTimelineDone() {
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.timeline == null) {
            super.paintChildren(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.from != null) {
            this.from.paint(this, graphics2D);
        }
        if (this.to != null) {
            this.to.paint(this, graphics2D);
        }
    }

    private JComponent findByConstraints(String string) {
        for (Component component : this.getComponents()) {
            JComponent jComponent = (JComponent)component;
            if (!string.equals(jComponent.getClientProperty(CONSTRAINTS_PROPERTY))) continue;
            return jComponent;
        }
        return null;
    }

    private JComponent findVisible() {
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return (JComponent)component;
        }
        return null;
    }
}

