/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.style;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class Style {
    protected boolean marginSingleValueSet;
    protected boolean paddingSingleValueSet;
    protected Border border;
    protected Color backgroundColor;
    protected Color color;
    protected Cursor cursor;
    protected Insets margin;
    protected Insets padding;
    protected int fontSize;
    protected int fontStyle;
    protected int marginBottom = Integer.MIN_VALUE;
    protected int marginLeft = Integer.MIN_VALUE;
    protected int marginRight = Integer.MIN_VALUE;
    protected int marginTop = Integer.MIN_VALUE;
    protected int paddingBottom = Integer.MIN_VALUE;
    protected int paddingLeft = Integer.MIN_VALUE;
    protected int paddingRight = Integer.MIN_VALUE;
    protected int paddingTop = Integer.MIN_VALUE;
    protected String fontName;
    private static Map<String, Parser<Object>> parsers = TK.newHashMap("cursor", new CursorParser(), "font-family", new FontFamilyParser());
    private static Map<String, Color> colorNames;

    public Style(Font font, String string) throws ParseException {
        if (font != null) {
            this.fontName = font.getName();
            this.fontSize = font.getSize();
            this.fontStyle = font.getStyle();
        }
        this.parse(string);
    }

    public void apply(Component component) throws ParseException {
        Serializable serializable;
        Font font;
        if (this.border != null) {
            if (component instanceof JComponent) {
                ((JComponent)JComponent.class.cast(component)).setBorder(this.border);
            } else {
                MLogger.warning("style", "Ignoring \"border\" property for \"%s\" component", component);
            }
        }
        if (this.backgroundColor != null) {
            component.setBackground(this.backgroundColor);
            if (component instanceof JLabel) {
                ((JLabel)JLabel.class.cast(component)).setOpaque(true);
            }
        }
        if (this.color != null) {
            component.setForeground(this.color);
        }
        if (this.cursor != null) {
            component.setCursor(this.cursor);
        }
        if (!((font = component.getFont()) == null || font.getSize() == this.fontSize && font.getStyle() == this.fontStyle && font.getName().equals(this.fontName))) {
            serializable = new Font(this.fontName, this.fontStyle, this.fontSize);
            component.setFont((Font)serializable);
        }
        if (this.marginSingleValueSet && this.margin == null) {
            if (component instanceof JComponent) {
                serializable = (JComponent)component;
                Border border = ((JComponent)serializable).getBorder();
                this.margin = border != null ? border.getBorderInsets(component) : UI.createInsets(0);
            } else {
                MLogger.warning("style", "Ignoring \"margin\" property for \"%s\" component", component);
            }
        }
        if (this.margin != null) {
            if (this.marginSingleValueSet) {
                if (this.marginBottom != Integer.MIN_VALUE) {
                    this.margin.bottom = this.marginBottom;
                }
                if (this.marginLeft != Integer.MIN_VALUE) {
                    this.margin.left = this.marginLeft;
                }
                if (this.marginRight != Integer.MIN_VALUE) {
                    this.margin.right = this.marginRight;
                }
                if (this.marginTop != Integer.MIN_VALUE) {
                    this.margin.top = this.marginTop;
                }
            }
            if (component instanceof JComponent) {
                serializable = (JComponent)component;
                ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
            } else {
                MLogger.warning("style", "Ignoring \"margin\" property for \"%s\" component", component);
            }
        }
        if (this.paddingSingleValueSet && this.padding == null) {
            if (component instanceof AbstractButton) {
                serializable = (AbstractButton)component;
                this.padding = ((AbstractButton)serializable).getMargin();
            } else if (component instanceof JTextComponent) {
                serializable = (JTextComponent)component;
                this.padding = ((JTextComponent)serializable).getMargin();
            } else {
                MLogger.warning("style", "Ignoring \"padding\" property for \"%s\" component", component);
            }
        }
        if (this.padding != null) {
            if (this.paddingSingleValueSet) {
                if (this.paddingBottom != Integer.MIN_VALUE) {
                    this.padding.bottom = this.paddingBottom;
                }
                if (this.paddingLeft != Integer.MIN_VALUE) {
                    this.padding.left = this.paddingLeft;
                }
                if (this.paddingRight != Integer.MIN_VALUE) {
                    this.padding.right = this.paddingRight;
                }
                if (this.paddingTop != Integer.MIN_VALUE) {
                    this.padding.top = this.paddingTop;
                }
            }
            if (component instanceof AbstractButton) {
                serializable = (AbstractButton)component;
                ((AbstractButton)serializable).setMargin(this.padding);
            } else if (component instanceof JTextComponent) {
                serializable = (JTextComponent)component;
                ((JTextComponent)serializable).setMargin(this.padding);
            } else {
                MLogger.warning("style", "Ignoring \"padding\" property for \"%s\" component", component);
            }
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void setCursor(int n) {
        this.cursor = Cursor.getPredefinedCursor(n);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        this.padding = insets;
    }

    public void parse(String string) throws ParseException {
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter(";");
        while (scanner.hasNext()) {
            int n;
            Insets insets;
            String string2 = scanner.next();
            int n2 = string2.indexOf(58);
            if (n2 == -1) {
                this.error("\":\" expected");
            }
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            Parser<Object> parser = parsers.get(string3);
            if (parser != null) {
                parser.update(this, parser.parse(string4));
                continue;
            }
            if ("background-color".equals(string3)) {
                this.backgroundColor = this.parseColor(string4);
                continue;
            }
            if ("border-style".equals(string3)) {
                this.border = this.parseBorderStyle(string4);
                continue;
            }
            if ("color".equals(string3)) {
                this.color = this.parseColor(string4);
                continue;
            }
            if ("font-size".equals(string3)) {
                if ("smaller".equals(string4)) {
                    --this.fontSize;
                    continue;
                }
                if ("larger".equals(string4)) {
                    ++this.fontSize;
                    continue;
                }
                if ("x-large".equals(string4)) {
                    this.fontSize += 2;
                    continue;
                }
                if ("xx-large".equals(string4)) {
                    this.fontSize += 10;
                    continue;
                }
                this.fontSize = this.parseSize(string4);
                continue;
            }
            if ("font-style".equals(string3)) {
                if ("italic".equals(string4)) {
                    this.fontStyle |= 2;
                    continue;
                }
                if ("normal".equals(string4)) {
                    this.fontStyle &= 0xFFFFFFFD;
                    continue;
                }
                this.error("Invalid \"font-style\" value: " + string4);
                continue;
            }
            if ("font-weight".equals(string3)) {
                if ("bold".equals(string4)) {
                    this.fontStyle |= 1;
                    continue;
                }
                if ("normal".equals(string4)) {
                    this.fontStyle &= 0xFFFFFFFE;
                    continue;
                }
                this.error("Invalid \"font-weight\" value: " + string4);
                continue;
            }
            if ("margin".equals(string3)) {
                insets = this.parseInsets(string4);
                if (insets != null) {
                    this.margin = insets;
                    this.marginSingleValueSet = false;
                    continue;
                }
                n = this.parseSize(string4);
                this.margin = UI.createInsets(n);
                this.marginSingleValueSet = false;
                continue;
            }
            if ("margin-bottom".equals(string3)) {
                this.marginBottom = this.parseSize(string4);
                this.marginSingleValueSet = true;
                continue;
            }
            if ("margin-left".equals(string3)) {
                this.marginLeft = this.parseSize(string4);
                this.marginSingleValueSet = true;
                continue;
            }
            if ("margin-right".equals(string3)) {
                this.marginRight = this.parseSize(string4);
                this.marginSingleValueSet = true;
                continue;
            }
            if ("margin-top".equals(string3)) {
                this.marginTop = this.parseSize(string4);
                this.marginSingleValueSet = true;
                continue;
            }
            if ("padding".equals(string3)) {
                insets = this.parseInsets(string4);
                if (insets != null) {
                    this.padding = insets;
                    this.paddingSingleValueSet = false;
                    continue;
                }
                n = this.parseSize(string4);
                this.padding = UI.createInsets(n);
                this.paddingSingleValueSet = false;
                continue;
            }
            if ("padding-bottom".equals(string3)) {
                this.paddingBottom = this.parseSize(string4);
                this.paddingSingleValueSet = true;
                continue;
            }
            if ("padding-left".equals(string3)) {
                this.paddingLeft = this.parseSize(string4);
                this.paddingSingleValueSet = true;
                continue;
            }
            if ("padding-right".equals(string3)) {
                this.paddingRight = this.parseSize(string4);
                this.paddingSingleValueSet = true;
                continue;
            }
            if ("padding-top".equals(string3)) {
                this.paddingTop = this.parseSize(string4);
                this.paddingSingleValueSet = true;
                continue;
            }
            this.error("Unknown property: " + string3);
        }
    }

    protected void error(String string) throws ParseException {
        throw new ParseException(string, 0);
    }

    protected Border parseBorderStyle(String string) throws ParseException {
        if ("inset".equals(string)) {
            return BorderFactory.createLoweredBevelBorder();
        }
        if ("outset".equals(string)) {
            return BorderFactory.createRaisedBevelBorder();
        }
        throw new ParseException("Invalid \"border-style\" value: " + string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Color parseColor(String string) throws ParseException {
        if (TK.isEmpty(string)) {
            this.error("Color value is null or empty");
        }
        if (string.charAt(0) == '#') {
            return ColorProperty.parseColor(string);
        }
        Class<Style> clazz = Style.class;
        synchronized (Style.class) {
            if (colorNames == null) {
                colorNames = TK.newHashMap("aqua", Color.CYAN, "black", Color.BLACK, "blue", Color.BLUE, "fuchsia", Color.MAGENTA, "gray", Color.GRAY, "green", new Color(32768), "lime", Color.GREEN, "maroon", new Color(0x800000), "navy", new Color(128), "olive", new Color(0x808000), "purple", new Color(0x800080), "red", Color.RED, "silver", new Color(0xC0C0C0), "teal", new Color(32896), "white", Color.WHITE, "yellow", Color.YELLOW);
            }
            Color color = colorNames.get(string);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (color == null) {
                color = UIManager.getColor(string);
            }
            return color;
        }
    }

    @Deprecated
    protected int parseCursor(String string) throws ParseException {
        return (Integer)parsers.get("cursor").parse(string);
    }

    protected Insets parseInsets(String string) throws ParseException {
        if (!string.contains(" ")) {
            return null;
        }
        List<String> list = TK.fastSplit(string, ' ');
        if (list.size() != 4) {
            this.error("Expected 4, space-separated values: " + string);
        }
        Insets insets = UI.createInsets(0);
        insets.top = this.parseSize(list.get(0));
        insets.right = this.parseSize(list.get(1));
        insets.bottom = this.parseSize(list.get(2));
        insets.left = this.parseSize(list.get(3));
        return insets;
    }

    protected int parseSize(String string) throws ParseException {
        try {
            int n = string.indexOf("px");
            return Integer.parseInt(n == -1 ? string : string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            this.error("Invalid size value: " + string);
            return -1;
        }
    }

    private static interface Parser<T> {
        public T parse(String var1) throws ParseException;

        public void update(Style var1, T var2);
    }

    private static final class FontFamilyParser
    implements Parser<String> {
        private FontFamilyParser() {
        }

        @Override
        public String parse(String string) throws ParseException {
            return string;
        }

        @Override
        public void update(Style style, String string) {
            style.setFontName(string);
        }
    }

    private static final class CursorParser
    implements Parser<Integer> {
        private Map<String, Integer> map = TK.newHashMap("default", 0, "move", 13, "hand", 12, "pointer", 12, "text", 2);

        private CursorParser() {
        }

        @Override
        public Integer parse(String string) throws ParseException {
            Integer n = this.map.get(string);
            if (n == null) {
                throw new ParseException("Invalid \"cursor\" value: " + string, 0);
            }
            return n;
        }

        @Override
        public void update(Style style, Integer n) {
            style.setCursor(n);
        }
    }
}

