/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.sb;

import java.awt.Window;
import java.net.URI;
import java.security.BasicPermission;
import java.util.Set;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.sb.PageChecker;

public final class DefaultPageChecker
implements PageChecker {
    private static PageChecker current = new DefaultPageChecker();
    private final Set<String> knownProtocols = TK.newHashSet("ftp", "sftp", "http", "https", "mailto");
    private String[] badBytes;

    public static synchronized PageChecker get() {
        return current;
    }

    public static synchronized void set(PageChecker pageChecker) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission("set"));
        }
        current = pageChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageChecker.PageStatus getPageStatus(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("null uri");
        }
        String string = uRI.getScheme();
        if ("FILE".equalsIgnoreCase(string)) {
            return PageChecker.PageStatus.MALWARE;
        }
        if (!this.knownProtocols.contains(string)) {
            return PageChecker.PageStatus.UNKNOWN;
        }
        String string2 = uRI.getPath();
        if (TK.isEmpty(string2)) {
            return PageChecker.PageStatus.OK;
        }
        DefaultPageChecker defaultPageChecker = this;
        synchronized (defaultPageChecker) {
            if (this.badBytes == null) {
                this.badBytes = new String[32];
                for (int i = 0; i < this.badBytes.length; ++i) {
                    this.badBytes[i] = "%" + TK.toUpperCase(TK.toByteHex(i));
                }
            }
            String string3 = TK.toUpperCase(uRI.toASCIIString());
            for (String string4 : this.badBytes) {
                if (!string3.contains(string4)) continue;
                return PageChecker.PageStatus.MALWARE;
            }
        }
        string2 = TK.toUpperCase(TK.unescapeURL(string2));
        string2 = string2.trim();
        if (string2.endsWith(".BAT") || string2.endsWith(".CMD") || string2.endsWith(".COM") || string2.endsWith(".DESKTOP") || string2.endsWith(".EXE") || string2.endsWith(".PIF") || string2.endsWith(".WMF") || string2.endsWith(".SH")) {
            return PageChecker.PageStatus.MALWARE;
        }
        return PageChecker.PageStatus.OK;
    }

    @Override
    public boolean showWarning(Window window, URI uRI, PageChecker.PageStatus pageStatus) {
        return MMessage.customConfirm(window, MIcon.stock("ui/warning"), MActionInfo.OPEN_URI, null, UI._("Are you sure you want to open this file?") + "\n\n" + uRI);
    }

    private DefaultPageChecker() {
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

