/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.print;

import java.awt.Color;
import java.awt.Component;
import java.lang.ref.WeakReference;
import org.makagiga.commons.print.AbstractPrintInfo;
import org.makagiga.commons.print.PrintInfo;

public abstract class ComponentPrintInfo<T extends Component>
extends AbstractPrintInfo {
    private Color oldBackground;
    private Color oldForeground;
    private WeakReference<T> componentRef;

    public ComponentPrintInfo(String string, T t, String string2, String string3) {
        super(string, string2, string3);
        this.componentRef = new WeakReference<T>(t);
    }

    @Override
    public void afterPrint(PrintInfo.PrintResult printResult) {
        Component component = (Component)this.componentRef.get();
        if (component != null) {
            component.setBackground(this.oldBackground);
            component.setForeground(this.oldForeground);
        }
    }

    @Override
    public void beforePrint() {
        Component component = (Component)this.componentRef.get();
        if (component != null) {
            this.oldBackground = component.getBackground();
            this.oldForeground = component.getForeground();
            component.setBackground(Color.WHITE);
            component.setForeground(Color.BLACK);
        }
    }

    public T getComponent() {
        return (T)((Component)this.componentRef.get());
    }
}

