/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.painters;

import java.awt.Color;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.LinearGradientPainter;

public abstract class PainterFactory {
    private static PainterFactory glassPainterFactory = new DefaultGlassPainterFactory();
    private static PainterFactory linearGradientPainterFactory = new DefaultLinearGradientPainterFactory();

    public static PainterFactory getGlassPainterFactory() {
        return glassPainterFactory;
    }

    public static void setGlassPainterFactory(PainterFactory painterFactory) {
        glassPainterFactory = painterFactory == null ? new DefaultGlassPainterFactory() : painterFactory;
    }

    public static PainterFactory getLinearGradientPainterFactory() {
        return linearGradientPainterFactory;
    }

    public static void setLinearGradientPainterFactory(PainterFactory painterFactory) {
        linearGradientPainterFactory = painterFactory == null ? new DefaultLinearGradientPainterFactory() : painterFactory;
    }

    public static GlassPainter newGlassPainter() {
        return glassPainterFactory.createGlassPainter(null, GlassPainter.RoundType.ALL);
    }

    public static GlassPainter newGlassPainter(Color color, GlassPainter.RoundType roundType) {
        return glassPainterFactory.createGlassPainter(color, roundType);
    }

    public static LinearGradientPainter newLinearGradientPainter(Color color, Color color2) {
        return linearGradientPainterFactory.createLinearGradientPainter(color, color2);
    }

    protected PainterFactory() {
    }

    protected GlassPainter createGlassPainter(Color color, GlassPainter.RoundType roundType) {
        return null;
    }

    protected LinearGradientPainter createLinearGradientPainter(Color color, Color color2) {
        return null;
    }

    private static final class DefaultLinearGradientPainterFactory
    extends PainterFactory {
        private DefaultLinearGradientPainterFactory() {
        }

        @Override
        protected LinearGradientPainter createLinearGradientPainter(Color color, Color color2) {
            return new LinearGradientPainter(color, color2);
        }
    }

    private static final class DefaultGlassPainterFactory
    extends PainterFactory {
        private DefaultGlassPainterFactory() {
        }

        @Override
        protected GlassPainter createGlassPainter(Color color, GlassPainter.RoundType roundType) {
            return new GlassPainter(color, roundType);
        }
    }
}

