/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.painters;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.VolatileImage;
import java.io.Serializable;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.Painter;

public abstract class AbstractPainter
implements Painter,
Serializable {
    protected Cache cache;
    protected Insets insets;
    private boolean cached = true;
    private boolean usePainterInsets;
    private Color primaryColor;

    public AbstractPainter(Color color, Insets insets) {
        this.primaryColor = color;
        if (insets != null) {
            this.insets = (Insets)insets.clone();
        }
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color color) {
        if (this.cache != null) {
            if (TK.isChange(this.primaryColor, color)) {
                this.primaryColor = color;
                this.cache.invalidate();
            }
        } else {
            this.primaryColor = color;
        }
    }

    @Override
    public Insets getPainterInsets(Component component) {
        return this.insets == null ? null : (Insets)this.insets.clone();
    }

    public void setPainterInsets(Insets insets) {
        if (this.cache != null) {
            if (TK.isChange(this.insets, insets)) {
                this.insets = insets == null ? null : (Insets)insets.clone();
                this.cache.invalidate();
            }
        } else {
            this.insets = insets;
        }
    }

    public boolean getUsePainterInsets() {
        return this.usePainterInsets;
    }

    public void setUsePainterInsets(boolean bl) {
        this.usePainterInsets = bl;
    }

    public void invalidate() {
        if (this.cache != null) {
            this.cache.invalidate();
        }
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean bl) {
        if (bl != this.cached) {
            this.cached = bl;
            if (this.cache != null) {
                this.cache.invalidate();
            }
        }
    }

    public boolean isOpaque() {
        return true;
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D) {
        Insets insets;
        Insets insets2 = insets = this.usePainterInsets ? this.getPainterInsets(component) : null;
        if (insets == null) {
            this.paint(component, graphics2D, 0, 0, component.getWidth(), component.getHeight());
        } else {
            this.paint(component, graphics2D, insets.left, insets.top, component.getWidth() - (insets.left + insets.right), component.getHeight() - (insets.top + insets.bottom));
        }
    }

    public static final class Cache
    implements Serializable {
        private static final long serialVersionUID = 5382010243884201615L;
        private transient boolean paintInProgress;
        private int x;
        private int y;
        private int width;
        private int height;
        private transient VolatileImage image;

        public Cache() {
            this.invalidate();
        }

        public void invalidate() {
            this.paintInProgress = false;
            this.x = -1;
            this.y = -1;
            this.width = -1;
            this.height = -1;
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean paint(Painter painter, Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
            if (painter instanceof AbstractPainter && !((AbstractPainter)AbstractPainter.class.cast(painter)).isCached()) {
                return false;
            }
            if (component == null) {
                return false;
            }
            if (this.paintInProgress) {
                return false;
            }
            if (this.x != n || this.y != n2 || this.width != n3 || this.height != n4) {
                this.invalidate();
            }
            do {
                int n5;
                int n6 = n5 = this.image == null ? 2 : this.image.validate(component.getGraphicsConfiguration());
                if (n5 == 2) {
                    this.invalidate();
                    this.image = UI.createCompatibleVolatileImage(n3, n4, 1);
                }
                if (n5 != 0) {
                    Graphics2D graphics2D2 = this.image.createGraphics();
                    this.paintInProgress = true;
                    try {
                        Color color;
                        Container container;
                        if (component != null && painter instanceof AbstractPainter && !((AbstractPainter)AbstractPainter.class.cast(painter)).isOpaque() && (container = component.getParent()) != null && (color = container.getBackground()) != null) {
                            graphics2D2.setColor(color);
                            graphics2D2.fillRect(0, 0, n3, n4);
                        }
                        painter.paint(component, graphics2D2, 0, 0, n3, n4);
                    }
                    finally {
                        this.paintInProgress = false;
                    }
                    graphics2D2.dispose();
                }
                this.x = n;
                this.y = n2;
                this.width = n3;
                this.height = n4;
                graphics2D.drawImage(this.image, n, n2, null);
            } while (this.image.contentsLost());
            return true;
        }
    }
}

