/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.mv;

import java.awt.Font;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.UI;
import org.makagiga.commons.request.AbstractRequestManager;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;

public class FontRenderer
extends MRenderer<String> {
    private boolean previewEnabled = true;
    private FontRequestManager frm;
    private MLabel normal;
    private MLabel preview;
    private RequestSource<Font> requestSource;

    public FontRenderer() {
        this((RequestSource<Font>)null);
    }

    public FontRenderer(RequestSource<Font> requestSource) {
        this.requestSource = requestSource;
    }

    public static Font createFont(String string) {
        Font font = new Font(string, 0, UI.getDefaultFontSize() + 2);
        return font.canDisplay('X') ? font : null;
    }

    @Override
    public MLabel getLabel() {
        return this.normal;
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setPreviewEnabled(boolean bl) {
        this.previewEnabled = bl;
    }

    @Override
    public void setIcon(Icon icon) {
        this.getLabel().setIcon(icon);
    }

    @Override
    public void setText(String string) {
        this.getLabel().setText(string);
    }

    @Override
    protected JComponent createView() {
        this.normal = new MRenderer.OptimizedLabel();
        this.preview = new MRenderer.OptimizedLabel();
        this.preview.setText(UI._("Preview"));
        this.preview.setTextAntialiasing(true);
        MRenderer.OptimizedPanel optimizedPanel = new MRenderer.OptimizedPanel(false);
        optimizedPanel.getGroupLayout().addComponent(this.normal).addContentGap().addComponent(this.preview);
        return optimizedPanel;
    }

    @Override
    protected void onRender(String string) {
        this.normal.setForeground(null);
        this.preview.setForeground(null);
        this.normal.setText(string);
        if (this.isPreviewEnabled()) {
            if (this.requestSource == null) {
                this.preview.setFont(FontRenderer.createFont(string));
            } else {
                if (this.frm == null) {
                    this.frm = new FontRequestManager();
                }
                this.preview.setFont(this.frm.requestFont(this.requestSource, string));
            }
            this.preview.setVisible(true);
        } else {
            this.preview.setFont(null);
            this.preview.setVisible(false);
        }
        this.setToolTipText(string);
    }

    private static final class FontRequestManager
    extends AbstractRequestManager<Font> {
        private final HashMap<String, Font> cache = new HashMap(50);

        @Override
        protected Font getResult(RequestInfo<Font> requestInfo) throws Exception {
            String string = requestInfo.getProperty("name", null);
            Font font = FontRenderer.createFont(string);
            this.cache.put(string, font);
            return font;
        }

        private FontRequestManager() {
            super(1, 50L);
        }

        private Font requestFont(RequestSource<Font> requestSource, String string) {
            Font font = this.cache.get(string);
            if (font != null) {
                return font;
            }
            RequestProperties requestProperties = new RequestProperties();
            requestProperties.put("name", string);
            this.startRequest(requestSource, requestProperties);
            return null;
        }
    }
}

