/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.io;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDate;
import org.makagiga.commons.io.DataHeader;
import org.makagiga.commons.io.DataType;

public class MDataInputStream
extends DataInputStream {
    public MDataInputStream(byte[] byArray) {
        super(new ByteArrayInputStream(byArray));
    }

    public MDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public Object[] readArray() throws IOException {
        DataType.ARRAY.verifyID(this);
        int n = this.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readProperty();
        }
        return objectArray;
    }

    public List<?> readCollection() throws IOException {
        DataType.COLLECTION.verifyID(this);
        int n = this.readInt();
        MArrayList<Object> mArrayList = new MArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            mArrayList.add(this.readProperty());
        }
        return mArrayList;
    }

    public DataHeader readHeader() throws IOException {
        return this.readHeader(null);
    }

    public DataHeader readHeader(String string) throws IOException {
        Object object;
        Map<String, ?> map = this.readPropertyMap();
        if (string != null && !string.equals(object = (String)map.get("ID"))) {
            throw new IOException("Invalid ID: " + (String)object + " (expected: " + string + ")");
        }
        object = new DataHeader();
        ((HashMap)object).putAll(map);
        return object;
    }

    public Object readProperty() throws IOException {
        byte by = this.readByte();
        if (by == DataType.NULL.getID()) {
            return null;
        }
        if (by == DataType.BOOLEAN.getID()) {
            return this.readBoolean();
        }
        if (by == DataType.BYTE.getID()) {
            return this.readByte();
        }
        if (by == DataType.CHARACTER.getID()) {
            return Character.valueOf(this.readChar());
        }
        if (by == DataType.DOUBLE.getID()) {
            return this.readDouble();
        }
        if (by == DataType.FLOAT.getID()) {
            return Float.valueOf(this.readFloat());
        }
        if (by == DataType.INTEGER.getID()) {
            return this.readInt();
        }
        if (by == DataType.LONG.getID()) {
            return this.readLong();
        }
        if (by == DataType.SHORT.getID()) {
            return this.readShort();
        }
        if (by == DataType.STRING.getID()) {
            return this.readUTF();
        }
        if (by == DataType.BYTE_ARRAY.getID()) {
            int n = this.readInt();
            byte[] byArray = new byte[n];
            this.readFully(byArray);
            return byArray;
        }
        if (by == DataType.DATE.getID()) {
            return new MDate(this.readLong());
        }
        if (by == DataType.COLOR.getID()) {
            return new Color(this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte());
        }
        throw new IOException("Unsupported property type: " + by);
    }

    public Object readProperty(String string) throws IOException {
        String string2 = this.readUTF();
        if (!string.equals(string2)) {
            throw new IOException("Invalid property name: " + string2 + " (expected: " + string + ")");
        }
        return this.readProperty();
    }

    public Map<String, ?> readPropertyMap() throws IOException {
        DataType.MAP.verifyID(this);
        int n = this.readInt();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < n; ++i) {
            linkedHashMap.put(this.readUTF(), this.readProperty());
        }
        return linkedHashMap;
    }
}

