/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.fx;

import java.awt.Color;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MTimeline;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.UI;
import org.pushingpixels.trident.Timeline;

public final class Blend {
    @Deprecated
    public static final int BACKGROUND = 1;
    @Deprecated
    public static final int FOREGROUND = 2;
    @Deprecated
    public static final int BEVEL_BORDER = 4;
    private boolean removed;
    private final Color sourceBackground;
    private final Color sourceForeground;
    private final Color targetBackground;
    private final Color targetForeground;
    private final Component component;
    private Component repaintComponent;
    private final Flags flags;
    private int count = 20;
    private long initialDelay = -1L;
    private long initialDelayStart = -1L;
    private static Map<Component, Blend> components;
    private static final String TIMELINE_PROPERTY = "org.makagiga.commons.fx.Blend.timeline";
    private static Timer timer;

    public static Timeline animateBackground(JComponent jComponent, Color color, Color color2) {
        MTimeline<JComponent> mTimeline = new MTimeline<JComponent>(jComponent);
        mTimeline.addPropertyToInterpolate("background", (JComponent)((Object)(color == null ? UI.getBackground(jComponent) : color)), (JComponent)((Object)(color2 == null ? UI.getBackground(jComponent) : color2)));
        return Blend.setup(jComponent, mTimeline);
    }

    public static Timeline animateForeground(JComponent jComponent, Color color, Color color2) {
        MTimeline<JComponent> mTimeline = new MTimeline<JComponent>(jComponent);
        mTimeline.addPropertyToInterpolate("foreground", (JComponent)((Object)(color == null ? UI.getForeground(jComponent) : color)), (JComponent)((Object)(color2 == null ? UI.getForeground(jComponent) : color2)));
        return Blend.setup(jComponent, mTimeline);
    }

    @Deprecated
    public static Blend background(Component component, Color color, Color color2) {
        return Blend.start(component, null, color, null, color2, 1);
    }

    @Deprecated
    public static synchronized Blend border(JComponent jComponent, Color color, Color color2) {
        if (jComponent == null) {
            return null;
        }
        Color color3 = jComponent.getBackground();
        if (color3 == null) {
            color3 = Color.WHITE;
        }
        jComponent.setBorder(BorderFactory.createBevelBorder(0, color3, color3));
        return Blend.start(jComponent, color, null, color2, null, 4);
    }

    @Deprecated
    public static Blend foreground(Component component, Color color, Color color2) {
        return Blend.start(component, color, null, color2, null, 2);
    }

    @Deprecated
    public void setInitialDelay(int n) {
        this.initialDelay = n;
    }

    @Deprecated
    public void setRepaintComponent(Component component) {
        this.repaintComponent = component;
    }

    @Deprecated
    public static synchronized Blend start(Component component, Color color, Color color2, Color color3, Color color4, int n) {
        Blend blend;
        if (component == null) {
            return null;
        }
        if (components == null) {
            components = new Hashtable<Component, Blend>();
        }
        if (timer == null) {
            timer = new Timer();
        }
        if ((blend = components.get(component)) != null) {
            if ((n & 4) != 0) {
                ((JComponent)JComponent.class.cast(blend.component)).setBorder(BorderFactory.createRaisedBevelBorder());
            } else {
                blend.component.setForeground(blend.targetForeground);
                blend.component.setBackground(blend.targetBackground);
                blend.repaint();
                blend.removed = true;
            }
        }
        blend = new Blend(component, color, color2, color3, color4, n);
        if ((n & 2) != 0) {
            blend.component.setForeground(blend.sourceForeground);
        }
        if ((n & 1) != 0) {
            blend.component.setBackground(blend.sourceBackground);
        }
        blend.repaint();
        components.put(component, blend);
        if (!timer.isRunning()) {
            timer.start();
        }
        return blend;
    }

    @Deprecated
    public static synchronized boolean stop(Component component) {
        return components == null ? false : components.remove(component) != null;
    }

    public static Timeline stopAnimation(JComponent jComponent) {
        Timeline timeline = null;
        WeakReference weakReference = UI.getClientProperty(jComponent, TIMELINE_PROPERTY, null);
        if (weakReference != null) {
            timeline = (Timeline)weakReference.get();
            if (timeline != null) {
                weakReference.clear();
                if (timeline instanceof MTimeline) {
                    ((MTimeline)MTimeline.class.cast(timeline)).setEnabled(false);
                }
                timeline.cancel();
            }
            jComponent.putClientProperty(TIMELINE_PROPERTY, null);
        }
        return timeline;
    }

    @Deprecated
    public static Blend textField(JTextField jTextField) {
        if (!jTextField.isEnabled() || !jTextField.isEditable()) {
            return null;
        }
        return Blend.start(jTextField, UI.getColor("TextField.selectionForeground"), UI.getColor("TextField.selectionBackground"), null, null, 3);
    }

    private Blend(Component component, Color color, Color color2, Color color3, Color color4, int n) {
        this.component = component;
        this.sourceBackground = color2 == null ? component.getBackground() : color2;
        this.sourceForeground = color == null ? component.getForeground() : color;
        this.targetBackground = color4 == null ? component.getBackground() : color4;
        this.targetForeground = color3 == null ? component.getForeground() : color3;
        this.flags = new Flags(n);
    }

    private static Color blend(Color color, Color color2, int n) {
        float f = (100.0f - (float)n) / 100.0f;
        float f2 = (float)n / 100.0f;
        return new Color((int)((float)color.getRed() * f + (float)color2.getRed() * f2), (int)((float)color.getGreen() * f + (float)color2.getGreen() * f2), (int)((float)color.getBlue() * f + (float)color2.getBlue() * f2));
    }

    private void repaint() {
        if (this.repaintComponent != null && !this.repaintComponent.getIgnoreRepaint()) {
            this.repaintComponent.repaint();
        }
    }

    private static Timeline setup(JComponent jComponent, Timeline timeline) {
        Blend.stopAnimation(jComponent);
        timeline.setDuration(500L);
        timeline.play();
        jComponent.putClientProperty(TIMELINE_PROPERTY, new WeakReference<Timeline>(timeline));
        return timeline;
    }

    private static final class Timer
    extends MTimer {
        private static final int INTERVAL = 18;

        public Timer() {
            super(18);
        }

        @Override
        protected boolean onTimeout() {
            if (components.isEmpty()) {
                return false;
            }
            Iterator iterator = components.values().iterator();
            while (iterator.hasNext()) {
                Blend blend = (Blend)iterator.next();
                if (blend.removed) {
                    if (blend.flags.isSet(1L)) {
                        blend.component.setBackground(blend.targetBackground);
                    }
                    if (blend.flags.isSet(2L)) {
                        blend.component.setForeground(blend.targetForeground);
                    }
                    blend.repaint();
                    iterator.remove();
                    continue;
                }
                if (blend.initialDelay != -1L) {
                    if (blend.initialDelayStart == -1L) {
                        blend.initialDelayStart = System.currentTimeMillis();
                        continue;
                    }
                    long l = System.currentTimeMillis();
                    if (l - blend.initialDelayStart < blend.initialDelay) continue;
                    blend.initialDelay = -1L;
                    blend.initialDelayStart = -1L;
                }
                blend.count--;
                if (blend.count <= 0) {
                    blend.removed = true;
                }
                if (blend.flags.isSet(4L)) {
                    Color color = Blend.blend(blend.targetForeground, blend.sourceForeground, (int)((double)blend.count * 4.5));
                    Color color2 = color.brighter();
                    Color color3 = color.darker();
                    ((JComponent)JComponent.class.cast(blend.component)).setBorder(BorderFactory.createBevelBorder(0, color2.brighter(), color2, color3.darker(), color3));
                }
                if (blend.flags.isSet(1L)) {
                    blend.component.setBackground(Blend.blend(blend.targetBackground, blend.sourceBackground, (int)((double)blend.count * 4.5)));
                }
                if (blend.flags.isSet(2L)) {
                    blend.component.setForeground(Blend.blend(blend.targetForeground, blend.sourceForeground, (int)((double)blend.count * 4.5)));
                }
                blend.repaint();
            }
            return true;
        }
    }
}

