/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.crypto;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.makagiga.commons.MPasswordField;
import org.makagiga.commons.TK;
import org.makagiga.commons.crypto.CryptoUtils;

public final class PBEInfo {
    public static final String DEFAULT_TRANSFORMATION = "PBEWithSHA1AndDESede";
    private PBEParameterSpec paramSpec;
    private byte[] salt;
    private SecretKey secretKey;
    private String transformation;

    public PBEInfo(char[] cArray, String string, byte[] byArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.checkPassword(cArray);
        this.transformation = TK.checkNull(string, "transformation");
        this.setSalt(byArray);
        this.secretKey = this.createSecretKey(cArray);
    }

    @Deprecated
    public PBEInfo(char[] cArray, boolean bl, String string, byte[] byArray) {
        this.checkPassword(cArray);
        this.transformation = TK.checkNull(string, "transformation");
        this.setSalt(byArray);
        try {
            this.secretKey = this.createSecretKey(cArray);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException(invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        if (bl) {
            MPasswordField.clear(cArray);
        }
    }

    public PBEInfo(SecretKey secretKey, byte[] byArray) {
        this.secretKey = TK.checkNull(secretKey, "secretKey");
        this.setSalt(byArray);
    }

    public synchronized void clear() {
        CryptoUtils.clear(this.salt);
    }

    public synchronized Cipher createCipher(int n) throws Exception {
        return this.createCipher(n, this.transformation);
    }

    public synchronized Cipher createCipher(int n, String string) throws Exception {
        if (this.paramSpec == null) {
            this.paramSpec = new PBEParameterSpec(this.salt, 20);
        }
        Cipher cipher = Cipher.getInstance(string);
        cipher.init(n, (Key)this.secretKey, this.paramSpec);
        return cipher;
    }

    public synchronized Mac createMac(String string) throws InvalidKeyException, NoSuchAlgorithmException {
        TK.checkNullOrEmpty(string);
        Mac mac = Mac.getInstance(string);
        mac.init(this.secretKey);
        return mac;
    }

    public synchronized byte[] getSalt() {
        return Arrays.copyOf(this.salt, this.salt.length);
    }

    public String getTransformation() {
        return this.transformation;
    }

    @SuppressWarnings(value="FI_EMPTY")
    protected void finalize() throws Throwable {
    }

    private void checkPassword(char[] cArray) {
        TK.checkNull(cArray, "password");
        if (cArray.length == 0) {
            throw new IllegalArgumentException("Password cannot be empty");
        }
    }

    private SecretKey createSecretKey(char[] cArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.transformation);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        pBEKeySpec.clearPassword();
        return secretKey;
    }

    private void setSalt(byte[] byArray) {
        this.salt = byArray == null ? CryptoUtils.createSalt(9) : Arrays.copyOf(byArray, byArray.length);
    }
}

