/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.FS;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class ColorPalette
implements Comparable<ColorPalette>,
Icon,
Iterable<Map.Entry<Color, String>>,
MRenderer.Renderable {
    private static ColorPalette _application;
    private static ColorPalette _default;
    private static ColorPalette _namedColors;
    private static ColorPalette _web20;
    private Image previewImage;
    private int columns = 8;
    private static final int DEFAULT_COLUMNS = 8;
    private static List<ColorPalette> _all;
    private final Map<Color, String> map = new LinkedHashMap<Color, String>();
    private String name;

    public ColorPalette() {
    }

    public ColorPalette(String string, Color ... colorArray) {
        this(8, string, colorArray);
    }

    public ColorPalette(int n, String string, Color ... colorArray) {
        this.columns = n;
        this.name = string;
        if (colorArray != null) {
            ColorPalette colorPalette = ColorPalette.getNamedColors();
            for (Color color : colorArray) {
                this.add(color, colorPalette.getDisplayName(color));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createPreviewImage(int n, int n2) {
        int n3 = this.getColumns();
        int n4 = this.getRows();
        BufferedImage bufferedImage = UI.createCompatibleImage(n3, n4, false);
        MGraphics2D mGraphics2D = new MGraphics2D(bufferedImage);
        mGraphics2D.setColor(Color.WHITE);
        mGraphics2D.fillRect();
        int n5 = 0;
        int n6 = 0;
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            for (Color color : this.map.keySet()) {
                mGraphics2D.setColor(color);
                mGraphics2D.drawPoint(n5, n6);
                if (n5 == n3 - 1) {
                    n5 = 0;
                    ++n6;
                    continue;
                }
                ++n5;
            }
        }
        mGraphics2D.dispose(new Object[0]);
        return UI.scaleImage(bufferedImage, n, n2, UI.Quality.LOW);
    }

    public static synchronized List<ColorPalette> getAll() {
        if (_all == null) {
            String[] stringArray = new String[]{"Blues", "Caramel", "Coldfire", "Dark_pastels", "Firecode", "Gold", "Grays", "Lights", "Muted", "Paintjet", "Pastels", "Plasma", "Royal", "Tango", "Web", "oxygen"};
            _all = new MArrayList<ColorPalette>(stringArray.length + 3);
            for (String string : stringArray) {
                _all.add(new ColorPalette(string));
            }
            _all.add(ColorPalette.getNamedColors());
            _all.add(ColorPalette.getApplicationPalette());
            _all.add(ColorPalette.getWeb20Palette());
            Collections.sort(_all);
            _all = Collections.unmodifiableList(_all);
        }
        return _all;
    }

    public static synchronized ColorPalette getApplicationPalette() {
        if (_application == null) {
            _application = new ColorPalette("Makagiga");
            ColorPalette._application.name = MApplication.getFullName();
        }
        return _application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumns() {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            return this.columns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            return this.map.size();
        }
    }

    public static synchronized ColorPalette getDefaultPalette() {
        if (_default == null) {
            _default = new ColorPalette("Default");
            ColorPalette._default.name = "<" + UI._("Default") + ">";
        }
        return _default;
    }

    public String getDisplayName(Color color) {
        if (color == null) {
            return "?";
        }
        String string = this.getName(color);
        if (string == null) {
            string = TK.toUpperCase(ColorProperty.toString(color));
        }
        return string;
    }

    public static synchronized ColorPalette getNamedColors() {
        if (_namedColors == null) {
            _namedColors = new ColorPalette("Named_Colors");
            ColorPalette._namedColors.name = UI._("Named Colors");
        }
        return _namedColors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(Color color) {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            return this.map.get(color);
        }
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getCount() / (double)this.getColumns());
    }

    public static synchronized ColorPalette getWeb20Palette() {
        if (_web20 == null) {
            _web20 = new ColorPalette("Web2.0");
        }
        return _web20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream) throws IOException {
        FS.TextReader textReader = null;
        try {
            textReader = FS.getUTF8Reader(inputStream);
            boolean bl = true;
            for (String string : textReader) {
                Object object;
                string = string.trim();
                if (bl) {
                    if (!string.equals("GIMP Palette")) {
                        throw new IOException("Expected \"GIMP Palette\" header");
                    }
                    bl = false;
                    continue;
                }
                if (string.isEmpty() || string.charAt(0) == '#') continue;
                if (string.startsWith("Columns:")) {
                    int n = 8;
                    try {
                        n = Integer.parseInt(string.substring(8).trim());
                        n = TK.range(n, 8, 1, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        MLogger.exception(numberFormatException);
                    }
                    object = this;
                    synchronized (object) {
                        this.columns = n;
                        continue;
                    }
                }
                if (string.startsWith("Name:")) {
                    ColorPalette colorPalette = this;
                    synchronized (colorPalette) {
                        this.name = string.substring(5).trim();
                        continue;
                    }
                }
                List<String> list = TK.fastSplit(string = string.replace("\t", " "), ' ');
                if (list.size() > 3) {
                    try {
                        object = new Color(this.parse(list.get(0)), this.parse(list.get(1)), this.parse(list.get(2)));
                        String string2 = TK.toString(list.subList(3, list.size()), " ");
                        this.add((Color)object, string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Invalid number format: " + string + ", " + numberFormatException);
                    }
                }
                throw new IOException("Invalid line format: " + string);
            }
        }
        finally {
            FS.close(textReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBinary(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        if (!string.equals("GIMP Palette")) {
            throw new IOException("Expected \"GIMP Palette\" header");
        }
        int n = dataInputStream.readInt();
        if (n != 1) {
            throw new IOException("Version " + n + " is not supported");
        }
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            this.name = dataInputStream.readUTF();
            this.columns = dataInputStream.readInt();
        }
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Color color = new Color(dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedByte());
            String string2 = dataInputStream.readUTF();
            ColorPalette colorPalette2 = this;
            synchronized (colorPalette2) {
                this.map.put(color, string2);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws IOException {
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(outputStream);
            textWriter.println("GIMP Palette");
            textWriter.println("Name: " + this);
            textWriter.println("Columns: " + this.getColumns());
            textWriter.println("#");
            StringBuilder stringBuilder = new StringBuilder();
            ColorPalette colorPalette = this;
            synchronized (colorPalette) {
                for (Map.Entry<Color, String> entry : this.map.entrySet()) {
                    stringBuilder.setLength(0);
                    Color color = entry.getKey();
                    this.appendByte(stringBuilder, color.getRed());
                    stringBuilder.append(' ');
                    this.appendByte(stringBuilder, color.getGreen());
                    stringBuilder.append(' ');
                    this.appendByte(stringBuilder, color.getBlue());
                    stringBuilder.append('\t').append(entry.getValue()).append('\n');
                    textWriter.print(stringBuilder);
                }
            }
        }
        finally {
            FS.close(textWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("GIMP Palette");
        dataOutputStream.writeInt(1);
        dataOutputStream.writeUTF(this.toString());
        dataOutputStream.writeInt(this.getColumns());
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            dataOutputStream.writeInt(this.map.size());
            for (Map.Entry<Color, String> entry : this.map.entrySet()) {
                Color color = entry.getKey();
                dataOutputStream.writeByte(color.getRed());
                dataOutputStream.writeByte(color.getGreen());
                dataOutputStream.writeByte(color.getBlue());
                dataOutputStream.writeUTF(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Color> toColorList() {
        MArrayList<Color> mArrayList;
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            mArrayList = new MArrayList<Color>(this.map.size());
            mArrayList.addAll((Collection<Color>)this.map.keySet());
        }
        return mArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            return this.name == null ? "?" : this.name;
        }
    }

    @Override
    public int compareTo(ColorPalette colorPalette) {
        return this.toString().compareToIgnoreCase(colorPalette.toString());
    }

    @Override
    public int getIconHeight() {
        return MIcon.getSmallSize();
    }

    @Override
    public int getIconWidth() {
        return MIcon.getSmallSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            if (this.previewImage == null) {
                this.previewImage = this.createPreviewImage(this.getIconWidth(), this.getIconHeight());
            }
            graphics.drawImage(this.previewImage, n, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<Color, String>> iterator() {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            return TK.unmodifiableIterator(this.map.entrySet().iterator());
        }
    }

    @Override
    public void setupRenderer(MRenderer<?> mRenderer) {
        mRenderer.setIcon(this);
        mRenderer.setText(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Color color, String string) {
        ColorPalette colorPalette = this;
        synchronized (colorPalette) {
            this.map.put(color, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorPalette(String string) {
        InputStream inputStream = null;
        final String string2 = "palettes/" + string + ".bgpl";
        try {
            SecurityManager securityManager = System.getSecurityManager();
            inputStream = securityManager == null ? ColorPalette.class.getResourceAsStream(string2) : AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return ColorPalette.class.getResourceAsStream(string2);
                }
            });
            this.readBinary(new DataInputStream(inputStream));
            FS.close(inputStream);
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
        finally {
            FS.close(inputStream);
        }
    }

    private void appendByte(StringBuilder stringBuilder, int n) {
        String string = Integer.toString(n);
        int n2 = 3 - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
    }

    private int parse(String string) {
        int n = Integer.parseInt(string);
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        return n;
    }
}

