/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.category;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.commons.painters.FlatPainter;
import org.makagiga.commons.painters.GlassPainter;

public class CategoryListRenderer<T>
extends MRenderer<T> {
    private static final CategoryList EMPTY_CATEGORY_LIST = new CategoryList();
    private final CategoryManager categoryManager;

    public CategoryListRenderer(CategoryManager categoryManager) {
        this.categoryManager = TK.checkNull(categoryManager, "categoryManager");
    }

    public static Color getBorderColor(Category category, Color color) {
        Color color2 = category.getColor();
        if (color2 == null) {
            color2 = color;
        }
        return MColor.deriveColor(color2, 0.8f);
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public static Dimension getPreferredSize(Component component, CategoryList categoryList) {
        if (TK.isEmpty(categoryList)) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = component.getFontMetrics(CategoryListRenderer.getFont(component));
        int n = 2;
        Dimension dimension = new Dimension(1, fontMetrics.getHeight() + n * 2);
        for (Category category : categoryList) {
            Icon icon = category.getIcon();
            int n2 = MIcon.isEmpty(icon) || icon instanceof ImageIcon && ((ImageIcon)ImageIcon.class.cast(icon)).getImage() == null ? 0 : icon.getIconWidth() + 2;
            dimension.width += n2 + fontMetrics.stringWidth(category.getName()) + n * 2 + 5;
        }
        return dimension;
    }

    public static void paint(Component component, Graphics2D graphics2D, CategoryList categoryList, Color color, Color color2) {
        if (TK.isEmpty(categoryList)) {
            return;
        }
        Object object = UI.setAntialiasing(graphics2D, true);
        graphics2D.setFont(CategoryListRenderer.getFont(component));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 2;
        int n2 = fontMetrics.getHeight();
        int n3 = 5;
        int n4 = (component.getHeight() - n2) / 2;
        int n5 = n4 + fontMetrics.getAscent();
        n4 -= n;
        int n6 = n2 + n * 2 - 1;
        for (Category category : categoryList) {
            String string = category.getName();
            Icon icon = category.getIcon();
            int n7 = MIcon.isEmpty(icon) || icon instanceof ImageIcon && ((ImageIcon)ImageIcon.class.cast(icon)).getImage() == null ? 0 : icon.getIconWidth() + 2;
            int n8 = fontMetrics.stringWidth(string);
            int n9 = n7 + n8 + n * 2;
            Color color3 = category.getColor();
            if (color3 == null) {
                color3 = color;
            }
            Color color4 = CategoryListRenderer.getBorderColor(category, color);
            CategoryListRenderer.paintBackground(component, graphics2D, color3, color4, n3, n4, n9, n6);
            if (icon != null && n7 > 0) {
                int n10 = icon.getIconHeight();
                int n11 = n4 + n6 / 2 - n10 / 2 + 1;
                icon.paintIcon(component, graphics2D, n3 + 2, n11);
            }
            graphics2D.setColor(color2);
            graphics2D.drawString(string, n3 + n7 + n, n5);
            if ((n3 += n9 + 5) <= component.getWidth()) continue;
            break;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    @Override
    protected JComponent createView() {
        return new View();
    }

    protected CategoryList getCategoryList(T t) {
        if (t == null) {
            return EMPTY_CATEGORY_LIST;
        }
        String string = t.toString();
        if (TK.isEmpty(string)) {
            return EMPTY_CATEGORY_LIST;
        }
        return new CategoryList(this.categoryManager, string);
    }

    @Override
    protected void onRender(T t) {
        View view = (View)this.getView();
        view.categoryList = this.getCategoryList(t);
    }

    static void paintBackground(Component component, Graphics2D graphics2D, Color color, Color color2, int n, int n2, int n3, int n4) {
        if (component instanceof JComponent && ((JComponent)JComponent.class.cast(component)).isPaintingForPrint()) {
            FlatPainter flatPainter = new FlatPainter(color);
            flatPainter.paint(component, graphics2D, n, n2, n3, n4);
        } else {
            GlassPainter glassPainter = new GlassPainter(color, GlassPainter.RoundType.NONE);
            glassPainter.setCached(false);
            glassPainter.paint(component, graphics2D, n + 1, n2 + 1, n3 - 1, n4 - 1);
        }
        graphics2D.setColor(color2);
        graphics2D.drawRect(n, n2, n3, n4);
    }

    private static Font getFont(Component component) {
        Font font = UI.getFont(component);
        return font.deriveFont((float)(font.getSize() - 1));
    }

    public static class View
    extends MRenderer.OptimizedPanel {
        private transient CategoryList categoryList;
        private final Color backgroundColor;
        private final Color foregroundColor;

        public View() {
            this(Category.DEFAULT_COLOR, Color.BLACK);
        }

        public View(Color color, Color color2) {
            super(null);
            this.backgroundColor = TK.checkNull(color, "backgroundColor");
            this.foregroundColor = TK.checkNull(color2, "foregroundColor");
        }

        @Override
        public Dimension getPreferredSize() {
            if (TK.isEmpty(this.categoryList)) {
                Font font = this.getFont();
                int n = font == null ? UI.getDefaultFontSize() : font.getSize();
                int n2 = 16;
                int n3 = n + n2 - 1;
                return new Dimension(super.getPreferredSize().width, n3);
            }
            return CategoryListRenderer.getPreferredSize(this, this.categoryList);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            CategoryListRenderer.paint(this, (Graphics2D)graphics, this.categoryList, this.backgroundColor, this.foregroundColor);
        }

        public void setCategoryList(CategoryList categoryList) {
            this.categoryList = categoryList;
        }
    }
}

