/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.about;

import java.io.Serializable;
import java.net.URI;
import org.makagiga.commons.MObject;
import org.makagiga.commons.TK;

public final class License
implements Serializable {
    public static final License APACHE_V2 = new License("Apache License, Version 2.0", URI.create("http://www.apache.org/licenses/LICENSE-2.0.html"));
    public static final License BSD = new License("BSD License", URI.create("http://www.opensource.org/licenses/bsd-license.php"));
    private final String name;
    private final URI uri;

    public License(String string, URI uRI) {
        this.name = TK.checkNullOrEmpty(string);
        this.uri = TK.checkNull(uRI);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof License)) {
            return false;
        }
        License license = (License)object;
        return this.name.equals(license.name) && this.uri.equals(license.uri);
    }

    public int hashCode() {
        return MObject.hashCode(this.name, this.uri);
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.name;
    }
}

