/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;

public final class XMLHelper {
    public static final String MAKAGIGA_NAMESPACE_BASE = "http://makagiga.org/damn.good.coffee/";
    public static final String MAKAGIGA_GHNS_EXTENSIONS = "http://makagiga.org/damn.good.coffee/hot/";
    private static final Map<Class<?>, SoftReference<JAXBContext>> contextCache = TK.newHashMap();

    public static synchronized void clearContextCache() {
        for (SoftReference<JAXBContext> softReference : contextCache.values()) {
            softReference.clear();
        }
        contextCache.clear();
    }

    public static synchronized void clearContextCache(Class<?> clazz) {
        SoftReference<JAXBContext> softReference = contextCache.get(clazz);
        if (softReference != null) {
            softReference.clear();
            contextCache.remove(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized JAXBContext createContext(Class<?> clazz) throws JAXBException {
        JAXBContext jAXBContext = null;
        SoftReference<JAXBContext> softReference = contextCache.get(clazz);
        if (softReference != null && (jAXBContext = softReference.get()) == null) {
            contextCache.remove(clazz);
        }
        if (jAXBContext != null) {
            return jAXBContext;
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            Class<JAXBContext> clazz3 = JAXBContext.class;
            synchronized (JAXBContext.class) {
                jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        {
            contextCache.put(clazz, new SoftReference<JAXBContext>(jAXBContext));
            return jAXBContext;
        }
    }

    public static Marshaller createMarshaller(Object object) throws JAXBException {
        JAXBContext jAXBContext = XMLHelper.createContext(object.getClass());
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unmarshaller createUnmarshaller(Class<?> clazz) throws JAXBException {
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            Class<JAXBContext> clazz3 = JAXBContext.class;
            synchronized (JAXBContext.class) {
                JAXBContext jAXBContext = XMLHelper.createContext(clazz);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return jAXBContext.createUnmarshaller();
            }
        }
    }

    public static void debug(Object object) {
        try {
            XMLHelper.createMarshaller(object).marshal(object, (OutputStream)System.err);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshal(Object object, File file) throws FileNotFoundException, JAXBException {
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(file);
            XMLHelper.createMarshaller(object).marshal(object, (Writer)textWriter);
        }
        finally {
            FS.close(textWriter);
        }
    }

    public static void marshal(Object object, OutputStream outputStream) throws JAXBException {
        XMLHelper.createMarshaller(object).marshal(object, outputStream);
    }

    public static void marshal(Object object, String string) throws FileNotFoundException, JAXBException {
        XMLHelper.marshal(object, new File(string));
    }

    public static void marshal(Object object, Writer writer) throws JAXBException {
        XMLHelper.createMarshaller(object).marshal(object, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> clazz, File file) throws FileNotFoundException, JAXBException {
        T t;
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            t = XMLHelper.unmarshal(clazz, bufferedFileInput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
        return t;
    }

    public static <T> T unmarshal(Class<T> clazz, InputStream inputStream) throws JAXBException {
        return (T)XMLHelper.createUnmarshaller(clazz).unmarshal(inputStream);
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader) throws JAXBException {
        return (T)XMLHelper.createUnmarshaller(clazz).unmarshal(reader);
    }

    public static <T> T unmarshal(Class<T> clazz, String string) throws FileNotFoundException, JAXBException {
        return XMLHelper.unmarshal(clazz, new File(string));
    }

    public static <T> T unmarshal(Class<T> clazz, URL uRL) throws JAXBException {
        return (T)XMLHelper.createUnmarshaller(clazz).unmarshal(uRL);
    }

    private XMLHelper() {
    }
}

