/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.makagiga.commons.UI;

class WindowDragAdapter
extends MouseAdapter {
    private Point startDrag = new Point();

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        Window window = UI.windowFor(jComponent);
        Point point = mouseEvent.getLocationOnScreen();
        point.translate(-this.startDrag.x, -this.startDrag.y);
        window.setLocation(point);
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        Window window = UI.windowFor(jComponent);
        jComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.startDrag = SwingUtilities.convertPoint(jComponent, mouseEvent.getPoint(), window);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        jComponent.setCursor(Cursor.getPredefinedCursor(13));
        this.startDrag.setLocation(0, 0);
    }

    WindowDragAdapter(JComponent jComponent) {
        jComponent.setCursor(Cursor.getPredefinedCursor(13));
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }
}

