/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.util.Locale;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.FS;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MProcess;
import org.makagiga.commons.PlatformConfig;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.StringList;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class OS {
    @ConfigEntry(value="OS.openCommand")
    @PlatformConfig
    public static final PropertyAccess<String> openCommand = new StringProperty().getSecure();
    private static boolean gnome;
    private static boolean kde;
    private static boolean linux;
    private static boolean mac;
    private static boolean noDistroInfo;
    private static boolean solaris;
    private static boolean unix;
    private static boolean webStart;
    private static boolean windows;
    private static boolean xfce;
    private static float _javaVersion;
    private static int _javaUpdate;
    private static int pid;
    private static Locale locale;
    private static String arch;
    private static String distroInfoCache;
    private static String internalName;
    private static String name;
    private static String runtimeName;
    private static String userName;
    private static String version;

    public static boolean email(String string) {
        if (OS.tryDefaultLaunch(Desktop.Action.MAIL, URI.create("mailto:" + TK.escapeURL(string)))) {
            return true;
        }
        return OS.email(string, null, null);
    }

    public static boolean email(String string, String string2, File file) {
        String string3 = OS.locateXdgUtil("email");
        if (string3 != null) {
            StringList stringList = new StringList();
            stringList.add(string3);
            stringList.add("--utf8");
            if (string2 != null) {
                stringList.add("--subject");
                stringList.add(string2);
            }
            if (file != null) {
                stringList.add("--attach");
                stringList.add(file.getPath());
            }
            if (string != null) {
                stringList.add(string);
            } else {
                stringList.add("mailto:");
            }
            return OS.tryLaunch(stringList.toArray());
        }
        MMessage.error(null, UI._("Could not send mail: {0}", string));
        return false;
    }

    public static String getArch() {
        return arch;
    }

    public static String getInternalName() {
        return internalName;
    }

    public static int getJavaUpdate() {
        return _javaUpdate;
    }

    public static float getJavaVersion() {
        return _javaVersion;
    }

    public static Locale getLocale() {
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String getName() {
        return name;
    }

    public static synchronized int getPID() {
        RuntimeMXBean runtimeMXBean;
        int n;
        if (runtimeName == null && (n = (runtimeName = (runtimeMXBean = ManagementFactory.getRuntimeMXBean()).getName()).indexOf(64)) != -1) {
            try {
                pid = Integer.parseInt(runtimeName.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                MLogger.exception(numberFormatException);
            }
        }
        return pid;
    }

    public static String getSummary() {
        return OS.getSummary(false);
    }

    static String getSummary(boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MApplication.getTitle());
        if (!TK.isEmpty(MApplication.getBuildInfo())) {
            stringBuilder.append(" [").append(MApplication.getBuildInfo()).append(']');
        }
        stringBuilder.append('\n');
        String string2 = MApplication.getResourceString("Application.x.codename", null);
        if (!TK.isEmpty(string2)) {
            stringBuilder.append("Codename: ").append(string2).append('\n');
        }
        stringBuilder.append('\n');
        stringBuilder.append(OS.getName()).append(' ').append(OS.getVersion()).append(" (").append(System.getProperty("os.arch")).append(')');
        if (OS.isWebStart()) {
            stringBuilder.append(", Web Start");
        }
        if (OS.isGNOME()) {
            stringBuilder.append(", GNOME");
        }
        if (OS.isKDE()) {
            stringBuilder.append(", KDE");
        }
        if (OS.isXfce()) {
            stringBuilder.append(", Xfce");
        }
        stringBuilder.append('\n');
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        stringBuilder.append(String.format("Java(tm) Runtime Environment %s (vendor: %s)", System.getProperty("java.runtime.version"), System.getProperty("java.vendor"))).append('\n').append('\n').append("JVM Name: ").append(runtimeMXBean.getVmName()).append('\n').append("JVM Arguments: ").append(runtimeMXBean.getInputArguments()).append('\n').append("Class Path: ").append(runtimeMXBean.getClassPath()).append('\n').append("Library Path: ").append(runtimeMXBean.getLibraryPath()).append('\n').append('\n').append(String.format("Locale: %s, %s (%s)", locale.getDisplayLanguage(), locale.getDisplayCountry(), locale)).append('\n');
        stringBuilder.append("Toolkit: ").append(Toolkit.getDefaultToolkit().getClass().getName()).append('\n');
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            stringBuilder.append("UI: ").append(lookAndFeel.getName()).append(" (").append(lookAndFeel.getClass().getName());
            if (UI.isSynth()) {
                stringBuilder.append(", Synth-based");
            }
            stringBuilder.append(")\n");
        }
        stringBuilder.append('\n').append(UI._("Configuration & Data Directory:")).append('\n');
        stringBuilder.append(FS.getConfigDir()).append('\n');
        if (!OS.isWebStart()) {
            stringBuilder.append('\n').append(UI._("Application Directory:")).append('\n');
            stringBuilder.append(FS.getBaseDir()).append('\n');
        }
        if (FS.getProfile() != null) {
            stringBuilder.append('\n').append(UI._("Profile: {0}", FS.getProfile())).append('\n');
        }
        if (bl && (string = OS.getDistroInfo()) != null) {
            stringBuilder.append("\nDistribution Info (lsb_release):\n").append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    public static String getUserName() {
        return userName;
    }

    public static String getVersion() {
        return version;
    }

    public static void init() {
        String string;
        String string2;
        int n;
        String string3 = System.getProperty("java.version");
        _javaVersion = 1.6f;
        try {
            n = string3.lastIndexOf(46);
            if (n != -1) {
                _javaVersion = Float.parseFloat(string3.substring(0, n));
            }
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            MLogger.warning("core", "Cannot parse Java Version info: %s", string3);
        }
        _javaUpdate = 0;
        try {
            n = string3.indexOf(95);
            if (n != -1) {
                int n2 = string3.indexOf(45);
                string2 = n2 != -1 ? string3.substring(n + 1, n2) : string3.substring(n + 1, string3.length());
                _javaUpdate = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            MLogger.warning("core", "Cannot parse Java Update info: %s", string3);
        }
        arch = System.getProperty("os.arch");
        arch = "i386".equals(arch) || "x86".equals(arch) ? "x86" : ("amd64".equals(arch) || "x86_64".equals(arch) ? "x86_64" : "unknown");
        name = System.getProperty("os.name");
        userName = System.getProperty("user.name");
        version = System.getProperty("os.version");
        String string4 = TK.toUpperCase(name);
        if (string4.startsWith("LINUX")) {
            linux = true;
        } else if (string4.startsWith("MAC")) {
            mac = true;
        } else if (string4.startsWith("SUNOS")) {
            solaris = true;
        } else if (string4.startsWith("WINDOWS")) {
            windows = true;
        }
        if (linux) {
            internalName = "linux";
            String string5 = System.getenv("DESKTOP_SESSION");
            boolean bl = kde = string5 != null && (string5.equalsIgnoreCase("KDE") || string5.equalsIgnoreCase("KDE4"));
            if (!kde) {
                string2 = System.getenv("KDE_FULL_SESSION");
                boolean bl2 = kde = string2 != null && string2.equalsIgnoreCase("true");
                if (!kde) {
                    boolean bl3 = gnome = System.getenv("GNOME_DESKTOP_SESSION_ID") != null;
                    if (!gnome) {
                        boolean bl4 = gnome = string5 != null && string5.equalsIgnoreCase("GNOME");
                    }
                    if (!gnome) {
                        xfce = string5 != null && string5.equalsIgnoreCase("XFCE");
                    }
                }
            }
        } else {
            internalName = mac ? "mac" : (solaris ? "solaris" : (windows ? "windows" : "unknown"));
        }
        unix = !windows;
        boolean bl = webStart = System.getProperty("javawebstart.version") != null;
        if (linux && !TK.isEmpty(string = System.getenv("MAKAGIGA_LANG"))) {
            int n3 = string.indexOf(95);
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (n3 == -1) {
                string6 = string;
                Locale.setDefault(new Locale(string6));
            } else {
                string6 = string.substring(0, n3);
                String string9 = string.substring(n3 + 1);
                if ((n3 = string9.indexOf(95)) == -1) {
                    string7 = OS.extractCountry(string9);
                    Locale.setDefault(new Locale(string6, string7));
                } else {
                    string7 = OS.extractCountry(string9.substring(0, n3));
                    string8 = string9.substring(n3 + 1);
                    Locale.setDefault(new Locale(string6, string7, string8));
                }
            }
        }
        locale = Locale.getDefault();
    }

    public static boolean isGNOME() {
        return gnome;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static boolean isKDE() {
        return kde;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isMac() {
        return mac;
    }

    public static boolean isOpenJDK() {
        String string = System.getProperty("java.runtime.name");
        return string != null && string.contains("OpenJDK");
    }

    public static boolean isSolaris() {
        return solaris;
    }

    public static boolean isSupported() {
        return linux || mac || solaris || windows;
    }

    public static boolean isUnix() {
        return unix;
    }

    public static boolean isWebStart() {
        return webStart;
    }

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isXfce() {
        return xfce;
    }

    public static boolean open(URI uRI) {
        TK.checkNull(uRI, "uri");
        String string = uRI.toString();
        if ("mailto".equals(uRI.getScheme())) {
            return OS.email(string.substring("mailto:".length()));
        }
        if (!windows && !TK.isEmpty(openCommand.get()) && OS.tryLaunch(openCommand.get(), string)) {
            return true;
        }
        if (OS.tryDefaultLaunch(Desktop.Action.BROWSE, uRI)) {
            return true;
        }
        String string2 = OS.locateXdgUtil("open");
        if (string2 != null && OS.tryLaunch(string2, string)) {
            return true;
        }
        MMessage.error(null, UI._("Could not open: {0}", uRI));
        return false;
    }

    private OS() {
    }

    private static String extractCountry(String string) {
        int n = string.indexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDistroInfo() {
        Object object = OS.class;
        synchronized (OS.class) {
            if (noDistroInfo) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (distroInfoCache != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return distroInfoCache;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (!OS.isLinux()) {
                return null;
            }
            try {
                object = new ByteArrayOutputStream();
                MProcess mProcess = new MProcess(null, (OutputStream)object, System.err, "lsb_release", "--codename", "--description", "--id", "--release");
                mProcess.getProcess().waitFor();
                ((ByteArrayOutputStream)object).close();
                Class<OS> clazz = OS.class;
                synchronized (OS.class) {
                    distroInfoCache = ((ByteArrayOutputStream)object).toString("UTF-8");
                    // ** MonitorExit[var2_6] (shouldn't be in output)
                    return distroInfoCache;
                }
            }
            catch (InterruptedException interruptedException) {
                MLogger.exception(interruptedException);
                return null;
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                Class<OS> clazz = OS.class;
                synchronized (OS.class) {
                    noDistroInfo = true;
                    // ** MonitorExit[var1_5] (shouldn't be in output)
                    return null;
                }
            }
        }
    }

    private static String locateXdgUtil(String string) {
        String string2 = "xdg-" + string;
        String string3 = FS.makePath(FS.getBaseDir(), string2);
        if (FS.exists(string3)) {
            return string3;
        }
        string3 = FS.makePath("/usr/bin", string2);
        if (FS.exists(string3)) {
            return string3;
        }
        String string4 = FS.getInstallPrefix("/usr");
        string3 = FS.makePath(string4 + "/share/makagiga", string2);
        if (FS.exists(string3)) {
            return string3;
        }
        return null;
    }

    private static boolean tryDefaultLaunch(Desktop.Action action, URI uRI) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(action)) {
            MLogger.debug("core", "Using default launcher...");
            try {
                switch (action) {
                    case BROWSE: {
                        desktop.browse(uRI);
                        break;
                    }
                    case MAIL: {
                        desktop.mail(uRI);
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean tryLaunch(String ... stringArray) {
        try {
            new MProcess(stringArray);
            return true;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
    }

    private static boolean tryLaunch(String string, String string2) {
        try {
            new MProcess(OS.withURL(string, string2));
            return true;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
    }

    private static String withURL(String string, String string2) {
        string2 = string2.replace(" ", "%20");
        if (string.contains("%u")) {
            return string.replace("%u", string2);
        }
        return string + " " + string2;
    }

    static {
        OS.init();
    }
}

