/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;

public final class Net {
    public static final int DOWNLOAD_NO_CACHE_UPDATE = 1;
    public static final int DOWNLOAD_USE_CACHE = 2;
    public static final int SETUP_COMPRESS = 4;
    public static final int SETUP_PACK200_GZIP = 8;

    public static URLConnection checkTemporaryRedirect(URLConnection uRLConnection, int n) throws IOException {
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return uRLConnection;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        if (httpURLConnection.getResponseCode() == 302) {
            httpURLConnection.disconnect();
            String string = uRLConnection.getHeaderField("Location");
            if (string == null) {
                return uRLConnection;
            }
            URLConnection uRLConnection2 = new URL(string).openConnection();
            Net.setupConnection(uRLConnection2, n);
            return uRLConnection2;
        }
        return uRLConnection;
    }

    public static String fixHttpURL(String string) {
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            return "http://" + string;
        }
        return string;
    }

    public static URI fixURI(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < 10; ++i) {
            try {
                return URI.create(stringBuilder.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                URISyntaxException uRISyntaxException = (URISyntaxException)illegalArgumentException.getCause();
                int n = uRISyntaxException.getIndex();
                if (n == -1) {
                    throw illegalArgumentException;
                }
                String string2 = uRISyntaxException.getReason();
                if (string2 != null && string2.startsWith("Illegal character in fragment") && stringBuilder.charAt(n) == '#') {
                    stringBuilder.deleteCharAt(n);
                    continue;
                }
                if (string2 != null && !string2.startsWith("Illegal character")) {
                    throw illegalArgumentException;
                }
                char c = stringBuilder.charAt(n);
                stringBuilder.deleteCharAt(n);
                stringBuilder.insert(n, TK.escapeURL(Character.toString(c)));
                continue;
            }
        }
        throw new IllegalArgumentException(new URISyntaxException(string, "Malformed link address"));
    }

    public static InputStream getInputStream(URLConnection uRLConnection) throws IOException {
        String string = uRLConnection.getContentEncoding();
        if (string != null) {
            if (string.contains("compress")) {
                return new ZipInputStream(uRLConnection.getInputStream());
            }
            if (string.contains("gzip")) {
                return new GZIPInputStream(uRLConnection.getInputStream());
            }
            if (string.contains("deflate")) {
                return new InflaterInputStream(uRLConnection.getInputStream());
            }
            if (string.contains("pack200-gzip")) {
                return new GZIPInputStream(uRLConnection.getInputStream());
            }
        }
        return uRLConnection.getInputStream();
    }

    public static String getUserAgent() {
        return String.format("Mozilla/5.0 (compatible; %s/%s)", MApplication.getFullName(), MApplication.getInternalVersion());
    }

    @Deprecated
    public static void init() {
        System.setProperty("http.agent", Net.getUserAgent());
    }

    public static boolean isHTTP(String string) {
        return string.startsWith("http://") || string.startsWith("https://");
    }

    public static boolean isLocal(String string) {
        return string.startsWith("file:/") || TK.startsWith(string, '/');
    }

    public static boolean isMail(String string) {
        return string.startsWith("mailto:");
    }

    public static boolean isSecureHttp(String string) {
        return string.startsWith("https://");
    }

    public static boolean isValidURL(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static void setupConnection(URLConnection uRLConnection, int n) {
        Flags flags = new Flags(n);
        String string = null;
        if (flags.isSet(4L)) {
            string = "gzip,deflate,compress";
        }
        if (flags.isSet(8L)) {
            string = string == null ? "pack200-gzip" : string + ",pack200-gzip";
        }
        if (string != null) {
            uRLConnection.setRequestProperty("Accept-Encoding", string);
        }
        uRLConnection.setConnectTimeout(30000);
        uRLConnection.setReadTimeout(30000);
    }

    public static void setupOutputProperties(URLConnection uRLConnection, String string, long l) {
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-type", string);
        uRLConnection.setRequestProperty("Content-length", Long.toString(l));
    }

    public static String unescapeHTML(String string) {
        return string == null ? null : string.replace("&amp;", "&");
    }

    private Net() {
    }

    public static final class DownloadInfo {
        private Class<? extends InputStream> inputType;
        private File destinationFile;
        private File file;
        private FS.ProgressListener progressListener;
        private InputStream input;
        private int flags;
        private long lastModified;
        private long length = -1L;
        private OutputStream output;
        private final String cacheSuffix;
        private final URL url;
        private URLConnection connection;

        @Deprecated
        public DownloadInfo(URL uRL, String string) {
            this.url = uRL;
            this.cacheSuffix = string;
        }

        public DownloadInfo(URL uRL, String string, int n) {
            this.url = uRL;
            this.cacheSuffix = string;
            this.flags = n;
        }

        public void cancelDownload() {
            this.shutDownConnection();
            FileCache.getInstance().removeItem(this.url);
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
        }

        public String getCacheSuffix() {
            return this.cacheSuffix;
        }

        public URLConnection getConnection() {
            return this.connection;
        }

        public File getDestinationFile() {
            return this.destinationFile;
        }

        public void setDestinationFile(File file) {
            this.destinationFile = file;
        }

        public File getFile() {
            return this.file;
        }

        public Class<? extends InputStream> getInputType() {
            return this.inputType;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getLength() {
            return this.length;
        }

        public URL getURL() {
            return this.url;
        }

        public void setProgressListener(FS.ProgressListener progressListener) {
            this.progressListener = progressListener;
        }

        public void shutDownConnection() {
            try {
                FS.close(this.input);
            }
            catch (NullPointerException nullPointerException) {
                MLogger.exception(nullPointerException);
            }
            FS.close(this.output);
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)HttpURLConnection.class.cast(this.connection)).disconnect();
                this.connection = null;
            }
        }

        public void startDownload() throws IOException {
            this.startDownload(this.flags);
        }

        @Deprecated
        public void startDownload(int n) throws IOException {
            Flags flags = new Flags(n);
            FileCache fileCache = flags.isSet(3L) ? FileCache.getInstance() : null;
            try {
                if (flags.isSet(1L)) {
                    this.file = fileCache.getFile(this.url);
                    if (this.file != null) {
                        this.length = this.file.length();
                        if (this.destinationFile != null) {
                            FS.copyFile(this.file, this.destinationFile);
                        }
                        return;
                    }
                }
                this.connection = this.url.openConnection();
                Net.setupConnection(this.connection, flags.intValue());
                this.connection = Net.checkTemporaryRedirect(this.connection, flags.intValue());
                this.lastModified = this.connection.getLastModified();
                if (flags.isSet(2L)) {
                    this.file = fileCache.getFile(this.url, this.lastModified);
                    if (this.file != null) {
                        MLogger.debug("cache", "Using file from cache: %s", this.file);
                        this.length = this.file.length();
                        if (this.destinationFile != null) {
                            FS.copyFile(this.file, this.destinationFile);
                        }
                        return;
                    }
                    this.file = this.lastModified == 0L ? fileCache.createFile(this.url, Long.MIN_VALUE, this.cacheSuffix, "download") : fileCache.createFile(this.url, this.lastModified, this.cacheSuffix, "download");
                    MLogger.debug("cache", "Creating new cache entry: %s", this.file);
                } else {
                    this.file = File.createTempFile("download", this.cacheSuffix);
                }
                MLogger.debug("cache", "Downloading \"%s\"...", this.url);
                this.input = Net.getInputStream(this.connection);
                this.inputType = this.input.getClass();
                this.input = new BufferedInputStream(this.input);
                this.output = new FS.BufferedFileOutput(this.file);
                this.length = this.connection.getContentLength();
                FS.copyStream(this.input, this.output, 4096, this.length, this.progressListener);
                FS.close(this.output);
                if (this.destinationFile != null) {
                    FS.copyFile(this.file, this.destinationFile);
                }
            }
            catch (IOException iOException) {
                if (fileCache != null) {
                    fileCache.removeItem(this.url);
                }
                throw iOException;
            }
            catch (Exception exception) {
                if (fileCache != null) {
                    fileCache.removeItem(this.url);
                }
                throw new IOException(exception);
            }
            finally {
                this.shutDownConnection();
            }
        }
    }
}

