/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.ContainerScanner;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MGraphics;
import org.makagiga.commons.MMenuBar;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class MWhatsThis
extends MGraphics {
    private boolean hintVisible = true;
    private static final Color DEFAULT_BG = new Color(50, 50, 50, 127);
    private static final Color DEFAULT_FG = Color.WHITE;
    private static final Font FONT = new Font("Dialog", 1, UI.getDefaultFontSize());
    private static KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(112, 1);
    private static MTimer hintTimer;
    private static final String INFO_PROPERTY = "org.makagiga.commons.MWhatsThis.info";
    private WeakReference<Window> windowRef;

    public MWhatsThis(Window window) {
        this.windowRef = new WeakReference<Window>(window);
    }

    public static MAction createAction(final Window window) {
        MAction mAction = new MAction(UI._("What's This?")){

            @Override
            public void onAction() {
                if (!((Boolean)Kiosk.actionWhatsThis.get()).booleanValue()) {
                    return;
                }
                if (window instanceof RootPaneContainer) {
                    RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
                    if (rootPaneContainer.getGlassPane() instanceof MWhatsThis) {
                        MWhatsThis.uninstall((RootPaneContainer)((Object)window), null);
                        return;
                    }
                    JMenuBar jMenuBar = rootPaneContainer.getRootPane().getJMenuBar();
                    if (jMenuBar != null) {
                        jMenuBar.getSelectionModel().clearSelection();
                        jMenuBar.getSelectionModel().addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent changeEvent) {
                                MWhatsThis.uninstall((RootPaneContainer)((Object)window), this);
                            }
                        });
                    }
                    MWhatsThis mWhatsThis = new MWhatsThis(window);
                    rootPaneContainer.setGlassPane(mWhatsThis);
                    mWhatsThis.setVisible(true);
                    hintTimer = new MTimer(MTimer.Format.SECONDS, 4){

                        @Override
                        protected boolean onTimeout() {
                            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
                            if (rootPaneContainer.getGlassPane() instanceof MWhatsThis) {
                                MWhatsThis mWhatsThis = (MWhatsThis)rootPaneContainer.getGlassPane();
                                mWhatsThis.hintVisible = false;
                                mWhatsThis.repaint();
                            }
                            return false;
                        }
                    };
                    hintTimer.start();
                }
            }
        };
        mAction.setAcceleratorKey(KEY_STROKE);
        mAction.setEnabled((Boolean)Kiosk.actionWhatsThis.get());
        return mAction;
    }

    public static List<Info> getAll(Container container) {
        final MArrayList<Info> mArrayList = MArrayList.create();
        new ContainerScanner(container){

            @Override
            public void processComponent(Container container, Component component) {
                JComponent jComponent;
                Info info;
                if (component instanceof JComponent && (info = (Info)UI.getClientProperty(jComponent = (JComponent)component, MWhatsThis.INFO_PROPERTY, null)) != null) {
                    mArrayList.add(info);
                }
            }
        };
        return mArrayList;
    }

    public static Info set(JComponent jComponent, String string) {
        return MWhatsThis.set(jComponent, string, DEFAULT_BG, DEFAULT_FG);
    }

    public static Info set(JComponent jComponent, String string, Color color, Color color2) {
        Info info = new Info(jComponent, string, color, color2);
        jComponent.putClientProperty(INFO_PROPERTY, info);
        return info;
    }

    @Override
    protected void onPaint(Graphics2D graphics2D) {
        Window window = (Window)this.windowRef.get();
        if (window == null) {
            return;
        }
        UI.setAntialiasing(graphics2D, true);
        UI.setTextAntialiasing(graphics2D, null);
        for (Info serializable : MWhatsThis.getAll(window)) {
            serializable.draw(this, graphics2D);
        }
        if (this.hintVisible) {
            String string = UI._("Press {0} to return...", TK.toString(KEY_STROKE));
            graphics2D.setFont(FONT);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle rectangle = fontMetrics.getStringBounds(string, graphics2D).getBounds();
            rectangle.width += 20;
            rectangle.height += 20;
            rectangle.x = this.getWidth() / 2 - rectangle.width / 2;
            rectangle.y = this.getHeight() / 2 - rectangle.height / 2;
            graphics2D.setColor(UI.TOOL_TIP_BACKGROUND_COLOR);
            graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 10, 10);
            graphics2D.setColor(UI.TOOL_TIP_FOREGROUND_COLOR);
            graphics2D.drawString(string, rectangle.x + 10, rectangle.y + 10 + fontMetrics.getAscent());
        }
    }

    private static void uninstall(RootPaneContainer rootPaneContainer, ChangeListener changeListener) {
        JMenuBar jMenuBar = rootPaneContainer.getRootPane().getJMenuBar();
        if (jMenuBar != null) {
            jMenuBar.getSelectionModel().removeChangeListener(changeListener);
        }
        MFrame.clearGlassPane(rootPaneContainer);
        if (hintTimer != null) {
            hintTimer.stop();
            hintTimer = null;
        }
    }

    public static final class Info
    extends MGraphics.Item {
        private static final BasicStroke BORDER_STROKE = new BasicStroke(1.0f);
        private Color background;
        private Color foreground;
        private static final Font KEYSTROKE_FONT = new Font("Dialog", 1, UI.getDefaultFontSize() + 2);
        private KeyStroke keyStroke;
        private String text;
        private WeakReference<JComponent> component;

        @Override
        public void draw(MGraphics mGraphics, Graphics2D graphics2D) {
            JComponent jComponent = (JComponent)this.component.get();
            if (jComponent == null) {
                return;
            }
            if (!jComponent.isVisible() || !jComponent.isShowing() || jComponent instanceof MMenuBar && ((MMenuBar)MMenuBar.class.cast(jComponent)).isMinimized()) {
                return;
            }
            MScrollPane mScrollPane = MScrollPane.getScrollPane(jComponent);
            Rectangle rectangle = SwingUtilities.convertRectangle(mScrollPane != null ? mScrollPane.getParent() : jComponent.getParent(), mScrollPane != null ? mScrollPane.getBounds() : jComponent.getBounds(), mGraphics);
            int n = 2;
            rectangle.x += n;
            rectangle.y += n;
            rectangle.width -= n * 2;
            rectangle.height -= n * 2;
            graphics2D.setColor(this.background);
            graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 5, 5);
            graphics2D.setFont(FONT);
            UI.paintText(0, graphics2D, rectangle, null, this.foreground, this.text.split("\n"));
            graphics2D.setColor(this.foreground);
            graphics2D.setStroke(BORDER_STROKE);
            graphics2D.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 5, 5);
            if (this.keyStroke != null) {
                int n2 = 2;
                graphics2D.setFont(KEYSTROKE_FONT);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = TK.toString(this.keyStroke);
                Rectangle rectangle2 = fontMetrics.getStringBounds(string, graphics2D).getBounds();
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 6;
                rectangle2.y = rectangle.y + 3;
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill3DRect(rectangle2.x, rectangle2.y, rectangle2.width + n2 * 2, rectangle2.height + n2 * 2, true);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(string, rectangle2.x + n2, rectangle2.y + fontMetrics.getAscent() + n2);
            }
        }

        public KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public void setKeyStroke(int n) {
            this.setKeyStroke(n, 0);
        }

        public void setKeyStroke(int n, int n2) {
            this.keyStroke = KeyStroke.getKeyStroke(n, n2);
        }

        public String getText() {
            return this.text;
        }

        private Info(JComponent jComponent, String string, Color color, Color color2) {
            this.component = new WeakReference<JComponent>(jComponent);
            this.text = string;
            this.background = color;
            this.foreground = color2;
        }
    }
}

