/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.Config;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTab;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MTabbedPane<T extends JComponent>
extends JTabbedPane
implements Config.IntRange,
Iterable<T>,
MouseWheelListener {
    public static final int BORDER_INSETS_SIZE = 1;
    private static Insets oldInsets;
    private Insets currentBorderContentInsets;
    private MTimer paintShortcutTimer;

    public MTabbedPane() {
        this.addMouseWheelListener(this);
        this.setDropTarget(new TabDropTarget());
    }

    public void addTab(MTab mTab) {
        this.addTab(mTab.tabTitle, (T)mTab);
        mTab.tabTitle = null;
    }

    public void addTab(String string, T t) {
        super.addTab(string, (Component)t);
    }

    public void addTab(String string, Icon icon, T t) {
        super.addTab(string, icon, (Component)t);
    }

    public void addTab(String string, String string2, T t) {
        this.addTab(string, (Icon)MIcon.stock(string2), t);
    }

    public void addTab(String string, String string2) {
        this.addTab(string, (Icon)MIcon.stock(string2), (T)null);
    }

    public static Insets createBorderContentInsetsForPlacement(int n) {
        switch (n) {
            case 2: {
                return new Insets(0, 4, 0, 0);
            }
            case 4: {
                return new Insets(0, 0, 0, 4);
            }
            case 1: {
                return new Insets(4, 0, 0, 0);
            }
            case 3: {
                return new Insets(0, 0, 4, 0);
            }
        }
        throw new IllegalArgumentException("Invalid \"placement\" value: " + n);
    }

    public T getSelectedTab() {
        return (T)((JComponent)this.getSelectedComponent());
    }

    public T getTabAt(int n) {
        try {
            return (T)((JComponent)this.getComponentAt(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    @Deprecated
    public void setComponentAt(int n, Component component) {
        super.setComponentAt(n, component);
    }

    public void setTabAt(int n, T t) {
        super.setComponentAt(n, (Component)t);
    }

    public int indexAtLocation(Point point) {
        return this.indexAtLocation(point.x, point.y);
    }

    public void insertTab(String string, Icon icon, T t, int n) {
        super.insertTab(string, icon, (Component)t, null, n);
    }

    public boolean isEmpty() {
        return this.getTabCount() == 0;
    }

    public boolean isTabHeaderVisible() {
        return !(this.ui instanceof HiddenTabsUI);
    }

    public void setTabHeaderVisible(boolean bl) {
        if (bl) {
            if (this.currentBorderContentInsets != null) {
                MTabbedPane.setBorderContentInsets(this.currentBorderContentInsets);
            }
            this.updateUI();
            if (this.currentBorderContentInsets != null) {
                this.restoreBorderContentInsets();
            }
        } else {
            if (this.ui instanceof HiddenTabsUI) {
                return;
            }
            this.setUI(new HiddenTabsUI());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){

            @Override
            public T getObjectAt(int n) {
                return MTabbedPane.this.getTabAt(n);
            }

            @Override
            public int getObjectCount() {
                return MTabbedPane.this.getTabCount();
            }
        };
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = this.indexAtLocation(mouseWheelEvent.getPoint());
        if (n == -1) {
            return;
        }
        if (mouseWheelEvent.getWheelRotation() < 0) {
            this.selectPreviousTab();
        } else {
            this.selectNextTab();
        }
        mouseWheelEvent.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restoreBorderContentInsets() {
        if (!UI.isMetal()) {
            return;
        }
        Insets insets = (Insets)UIManager.get("TabbedPane.contentBorderInsets");
        if (insets != null) {
            this.currentBorderContentInsets = (Insets)insets.clone();
        }
        Class<MTabbedPane> clazz = MTabbedPane.class;
        synchronized (MTabbedPane.class) {
            if (oldInsets != null) {
                UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void setBorderContentInsets(Insets insets) {
        if (!UI.isMetal()) {
            return;
        }
        oldInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        UIManager.put("TabbedPane.contentBorderInsets", insets);
    }

    @Override
    public void setTabLayoutPolicy(int n) {
        super.setTabLayoutPolicy(n == 1 && (UI.isA03() || UI.isGTK()) ? 0 : n);
    }

    @Override
    public void setTabPlacement(int n) {
        if (UI.isA03()) {
            super.setTabPlacement(1);
        } else if (UI.isSubstance() && (n == 2 || n == 4)) {
            super.setTabPlacement(1);
        } else {
            super.setTabPlacement(n);
        }
    }

    @Override
    public Config.IntInfo getIntInfo() {
        return new Config.IntInfo(0, this.getTabCount() - 1);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int[] nArray;
        int n2;
        this.paintShortcutTimer = TK.dispose(this.paintShortcutTimer);
        if (keyEvent.getKeyCode() == 18 && (n2 = Math.min((nArray = Mnemonic.getTabKeys()).length, this.getTabCount())) > 3) {
            boolean bl2 = false;
            String string = KeyEvent.getKeyModifiersText(8);
            for (int i = 0; i < n2; ++i) {
                String string2;
                Component component = this.getTabComponentAt(i);
                if (!(component instanceof TabComponent)) continue;
                if (bl) {
                    string2 = KeyEvent.getKeyText(nArray[i]);
                    if (i == 0) {
                        string2 = string + "+" + string2;
                    }
                } else {
                    string2 = null;
                }
                ((TabComponent)TabComponent.class.cast(component)).setPaintShortcut(string2);
                bl2 = true;
            }
            if (bl2 && bl) {
                this.paintShortcutTimer = new MTimer(TimeUnit.SECONDS, 2L){

                    @Override
                    protected boolean onTimeout() {
                        int n = MTabbedPane.this.getTabCount();
                        for (int i = 0; i < n; ++i) {
                            Component component = MTabbedPane.this.getTabComponentAt(i);
                            if (!(component instanceof TabComponent)) continue;
                            ((TabComponent)TabComponent.class.cast(component)).setPaintShortcut(null);
                        }
                        return false;
                    }
                };
                this.paintShortcutTimer.start();
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void selectNextTab() {
        int n = this.getTabCount();
        if (n < 2) {
            return;
        }
        int n2 = this.getSelectedIndex();
        if (n2 == -1) {
            n2 = 0;
        }
        int n3 = n2 + 1;
        while (true) {
            if (n3 > n - 1) {
                n3 = 0;
            }
            if (n3 == n2) {
                return;
            }
            if (this.isEnabledAt(n3)) break;
            ++n3;
        }
        this.setSelectedIndex(n3);
    }

    private void selectPreviousTab() {
        int n = this.getTabCount();
        if (n < 2) {
            return;
        }
        int n2 = this.getSelectedIndex();
        if (n2 == -1) {
            n2 = 0;
        }
        int n3 = n2 - 1;
        while (true) {
            if (n3 < 0) {
                n3 = n - 1;
            }
            if (n3 == n2) {
                return;
            }
            if (this.isEnabledAt(n3)) break;
            --n3;
        }
        this.setSelectedIndex(n3);
    }

    private static final class TabDropTarget
    extends DropTarget {
        @Override
        public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            super.dragEnter(dropTargetDragEvent);
            this.doSelectTab(dropTargetDragEvent);
        }

        @Override
        public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            super.dragOver(dropTargetDragEvent);
            this.doSelectTab(dropTargetDragEvent);
        }

        private TabDropTarget() {
        }

        private void doSelectTab(DropTargetDragEvent dropTargetDragEvent) {
            MTabbedPane mTabbedPane = (MTabbedPane)this.getComponent();
            int n = mTabbedPane.indexAtLocation(dropTargetDragEvent.getLocation());
            if (n != -1 && mTabbedPane.getSelectedIndex() != n) {
                mTabbedPane.setSelectedIndex(n);
            }
            dropTargetDragEvent.rejectDrag();
        }
    }

    private static final class HiddenTabsUI
    extends BasicTabbedPaneUI {
        private HiddenTabsUI() {
        }

        @Override
        protected int calculateMaxTabHeight(int n) {
            return 0;
        }

        @Override
        protected int calculateTabAreaHeight(int n, int n2, int n3) {
            return 0;
        }

        @Override
        protected int calculateTabHeight(int n, int n2, int n3) {
            return 0;
        }

        @Override
        protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
            return 0;
        }

        @Override
        protected Insets getContentBorderInsets(int n) {
            return UI.createInsets(0);
        }

        @Override
        protected Insets getSelectedTabPadInsets(int n) {
            return UI.createInsets(0);
        }

        @Override
        protected Insets getTabAreaInsets(int n) {
            return UI.createInsets(0);
        }

        @Override
        protected Insets getTabInsets(int n, int n2) {
            return UI.createInsets(0);
        }
    }

    public static class TabIcon
    extends MButton {
        private final TabComponent tabComponent;

        public TabIcon(TabComponent tabComponent) {
            this.tabComponent = TK.checkNull(tabComponent, "tabComponent");
            this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setRolloverEffectEnabled(false);
            this.setToolTipText(UI._("Close"));
            this.setSafeAction(true);
        }

        @Override
        public void updateUI() {
            this.setUI((ButtonUI)BasicButtonUI.createUI(this));
        }

        @Override
        protected final void onClick() {
            this.tabComponent.onClick();
        }
    }

    public static class TabComponent
    extends MPanel {
        private final MLabel text;
        private String paintShortcut;
        private final TabIcon icon;
        private final WeakReference<MTabbedPane<?>> tabs;

        public TabComponent(MTabbedPane<?> mTabbedPane) {
            this.tabs = new WeakReference(mTabbedPane);
            MLineBorder mLineBorder = new MLineBorder(MLineBorder.Position.TOP);
            MLineBorder.Style style = mLineBorder.getStyle(MLineBorder.Position.TOP);
            style.setColor(null);
            style.setSize(2);
            this.setBorder(mLineBorder);
            this.setOpaque(false);
            this.icon = new TabIcon(this);
            this.addWest(this.icon);
            this.text = new MLabel();
            this.text.setStyle("margin: 1 5 1 5");
            for (MouseListener mouseListener : this.text.getMouseListeners()) {
                this.text.removeMouseListener(mouseListener);
            }
            this.addCenter(this.text);
        }

        public TabIcon getTabIcon() {
            return this.icon;
        }

        public MLabel getTextLabel() {
            return this.text;
        }

        @Override
        public void paint(Graphics graphics) {
            MTabbedPane mTabbedPane = (MTabbedPane)this.tabs.get();
            if (mTabbedPane != null && mTabbedPane.isTabHeaderVisible()) {
                super.paint(graphics);
                if (this.paintShortcut != null) {
                    MGraphics2D mGraphics2D = MGraphics2D.copy(graphics);
                    mGraphics2D.setAntialiasing(true);
                    mGraphics2D.setFont(UI.getFont(this).deriveFont(1));
                    mGraphics2D.setTextAntialiasing(null);
                    mGraphics2D.setColor(new Color(50, 50, 50, 180));
                    int n = 5;
                    FontMetrics fontMetrics = mGraphics2D.getFontMetrics();
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = fontMetrics.stringWidth(this.paintShortcut);
                    int n5 = this.getHeight();
                    mGraphics2D.fillRoundRect(n2, n3, n4 + n * 2, n5, 16);
                    mGraphics2D.setColor(Color.WHITE);
                    mGraphics2D.drawString(this.paintShortcut, n2 + n, n3 + n5 / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
                    mGraphics2D.dispose(new Object[0]);
                }
            }
        }

        public void setColor(Color color) {
            this.setColor(color, null);
        }

        @Deprecated
        public void setColor(Color color, Color color2) {
            MLineBorder mLineBorder;
            MLineBorder.Style style;
            Border border = this.getBorder();
            if (border instanceof MLineBorder && TK.isChange((style = (mLineBorder = (MLineBorder)border).getStyle(MLineBorder.Position.TOP)).getColor(), color)) {
                style.setColor(color);
                this.repaint();
            }
        }

        public void setIcon(Icon icon) {
            this.icon.setIcon(icon);
        }

        public void setText(String string) {
            this.text.setText(string);
        }

        protected int getIndex() {
            MTabbedPane mTabbedPane = (MTabbedPane)this.tabs.get();
            return mTabbedPane == null ? -1 : mTabbedPane.indexOfTabComponent(this);
        }

        protected void onClick() {
        }

        private void setPaintShortcut(String string) {
            if (TK.isChange(string, this.paintShortcut)) {
                this.paintShortcut = string;
                this.repaint();
            }
        }
    }
}

