/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.makagiga.commons.FS;

public class MProperties
extends Properties {
    private boolean safeStore;
    private String comment;

    public MProperties() {
    }

    public MProperties(Properties properties) {
        super(properties);
    }

    public synchronized String getComment() {
        return this.comment;
    }

    public synchronized void setComment(String string) {
        this.comment = string;
    }

    public synchronized boolean isSafeStore() {
        return this.safeStore;
    }

    public synchronized void setSafeStore(boolean bl) {
        this.safeStore = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUTF8(File file) throws IOException {
        FS.TextReader textReader = null;
        try {
            textReader = FS.getUTF8Reader(file);
            this.load(textReader);
        }
        finally {
            FS.close(textReader);
        }
    }

    public void loadUTF8(String string) throws IOException {
        this.loadUTF8(new File(string));
    }

    public void loadUTF8(InputStream inputStream) throws IOException {
        this.load(FS.getUTF8Reader(inputStream));
    }

    @Override
    @Deprecated
    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends Object, ? extends Object> map) {
        super.putAll(map);
    }

    public synchronized void removeNonStringValues() {
        Iterator<Map.Entry<Object, Object>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() instanceof String) continue;
            iterator.remove();
        }
    }

    public Object setObject(String string, Object object) {
        return super.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setPropertyValue(String string, Object object) {
        if (object == null) {
            MProperties mProperties = this;
            synchronized (mProperties) {
                return this.remove(string);
            }
        }
        return this.setProperty(string, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUTF8(File file) throws IOException {
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(file);
            if (this.isSafeStore()) {
                Properties properties = new Properties();
                for (Map.Entry<Object, Object> entry : this.entrySet()) {
                    if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                properties.store(textWriter, this.comment);
            } else {
                this.store(textWriter, this.comment);
            }
        }
        finally {
            FS.close(textWriter);
        }
    }

    public void storeUTF8(String string) throws IOException {
        this.storeUTF8(new File(string));
    }

    public void storeUTF8(OutputStream outputStream) throws IOException {
        this.store(FS.getUTF8Writer(outputStream), this.comment);
    }

    @Override
    @Deprecated
    public Collection<Object> values() {
        return super.values();
    }
}

