/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.makagiga.commons.TK;

public class MProgressIcon
implements Icon {
    private boolean stringPainted = true;
    private Color barForegroundColor = Color.RED;
    private Color textColor = Color.WHITE;
    private float alpha = 0.5f;
    private Icon impl;
    private int arcAngle;
    private int maximum;
    private int percent;
    private int value;
    private WeakReference<ImageObserver> observerRef;

    public MProgressIcon(ImageObserver imageObserver) {
        this(imageObserver, null);
    }

    public MProgressIcon(ImageObserver imageObserver, Icon icon) {
        if (imageObserver == null) {
            throw new IllegalArgumentException("Null observer");
        }
        this.observerRef = new WeakReference<ImageObserver>(imageObserver);
        this.impl = icon;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        if (Float.compare(f, this.alpha) != 0) {
            this.alpha = f;
            this.repaint();
        }
    }

    public Color getBarForeground() {
        return this.barForegroundColor;
    }

    public void setBarForeground(Color color) {
        TK.checkNull(color, "barForegroundColor");
        if (!color.equals(this.barForegroundColor)) {
            this.barForegroundColor = color;
            this.repaint();
        }
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        if (n != this.maximum) {
            this.maximum = n;
            if (this.recalc()) {
                this.repaint();
            }
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        TK.checkNull(color, "textColor");
        if (!color.equals(this.textColor)) {
            this.textColor = color;
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        int n2 = Math.min(this.maximum, n);
        if (n2 != this.value) {
            this.value = n2;
            if (this.recalc()) {
                this.repaint();
            }
        }
    }

    public boolean isStringPainted() {
        return this.stringPainted;
    }

    public void setStringPainted(boolean bl) {
        if (bl != this.stringPainted) {
            this.stringPainted = bl;
            this.repaint();
        }
    }

    @Override
    public int getIconWidth() {
        return this.impl == null ? 32 : this.impl.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.impl == null ? 32 : this.impl.getIconHeight();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.impl != null) {
            this.impl.paintIcon(component, graphics, n, n2);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        graphics2D.setColor(this.barForegroundColor);
        graphics2D.fillArc(n, n2, n3, n4, -270, this.arcAngle);
        if (this.stringPainted) {
            graphics2D.setColor(this.textColor);
            graphics2D.setFont(new Font("Dialog", 1, Math.max(12, n4 / 4)));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = this.percent + "%";
            graphics2D.drawString(string, n + n3 / 2 - fontMetrics.stringWidth(string) / 2, n2 + n4 / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
        }
        graphics2D.dispose();
    }

    private boolean recalc() {
        int n = (int)((float)(this.value * 100) / (float)this.maximum);
        int n2 = -((int)((float)n * 3.6f));
        if (n2 != this.arcAngle || n != this.percent) {
            this.arcAngle = n2;
            this.percent = n;
            return true;
        }
        return false;
    }

    private void repaint() {
        ImageObserver imageObserver = (ImageObserver)this.observerRef.get();
        if (imageObserver instanceof Component) {
            ((Component)Component.class.cast(imageObserver)).repaint();
        }
    }
}

