/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.Config;
import org.makagiga.commons.MCellTip;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.Sortable;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MList<I>
extends JList
implements Config.IntRange,
Iterable<I>,
Sortable<I> {
    private ActionType actionType = ActionType.NONE;
    private InputEvent actionEvent;
    private String text;

    public MList() {
        this((ListModel)new DefaultListModel());
    }

    public MList(ListModel listModel) {
        super(listModel);
        StaticHandler staticHandler = new StaticHandler();
        this.addKeyListener(staticHandler);
        this.addMouseListener(staticHandler);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MList.this.onSelect();
            }
        });
        MCellTip.getInstance().install(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public void addAllItems(Collection<? extends I> collection) {
        for (I i : collection) {
            this.addItem(i);
        }
    }

    public void addAllItems(I ... IArray) {
        if (IArray.length > 0) {
            for (I i : IArray) {
                this.addItem(i);
            }
        }
    }

    public void addItem(I i) {
        this.getDefaultModel().addElement(i);
    }

    public void addItem(I i, int n) {
        this.getDefaultModel().add(n, i);
    }

    public void clear() {
        this.getDefaultModel().clear();
    }

    public void filter(MSearchPanel mSearchPanel, List<I> list, RowFilter<List<I>, Integer> rowFilter) {
        this.clear();
        if (list == null) {
            if (mSearchPanel != null) {
                mSearchPanel.setState(MTextFieldPanel.State.NORMAL);
            }
            this.setText(null);
            return;
        }
        if (rowFilter == null) {
            this.addAllItems((Collection<? extends I>)list);
            if (mSearchPanel != null) {
                mSearchPanel.setState(MTextFieldPanel.State.NORMAL);
            }
            this.setText(null);
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            I i2 = list.get(i);
            if (!rowFilter.include(new ItemRowFilterEntry(list, i, i2))) continue;
            this.addItem(i2);
        }
        if (this.isEmpty()) {
            if (mSearchPanel != null) {
                mSearchPanel.setState(MTextFieldPanel.State.ERROR);
                this.setText(UI._("No item found: \"{0}\"", mSearchPanel.getText()));
            } else {
                this.setText(UI._("No item found"));
            }
        } else {
            if (mSearchPanel != null) {
                if (this.getItemCount() == list.size()) {
                    mSearchPanel.setState(MTextFieldPanel.State.NORMAL);
                } else {
                    mSearchPanel.setState(MTextFieldPanel.State.OK);
                }
            }
            this.setText(null);
        }
    }

    public int findItem(I i) {
        ListModel listModel = this.getModel();
        int n = listModel.getSize();
        if (n == 0) {
            return -1;
        }
        for (int j = 0; j < n; ++j) {
            if (listModel.getElementAt(j) != i) continue;
            return j;
        }
        return -1;
    }

    public InputEvent getActionEvent() {
        return this.actionEvent;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public DefaultListModel getDefaultModel() {
        ListModel listModel = this.getModel();
        if (!(listModel instanceof DefaultListModel)) {
            throw new UnsupportedOperationException();
        }
        return (DefaultListModel)listModel;
    }

    public I getItemAt(int n) {
        return (I)this.getModel().getElementAt(n);
    }

    public I getItemAt(Point point) {
        int n = this.locationToIndex(point);
        if (n == -1) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle == null) {
            return null;
        }
        if (!rectangle.contains(point)) {
            return null;
        }
        return this.getItemAt(n);
    }

    public int getItemCount() {
        return this.getModel().getSize();
    }

    public I getSelectedItem() {
        return (I)this.getSelectedValue();
    }

    public void setSelectedIndex(int n, boolean bl) {
        this.setSelectedIndex(n);
        if (bl) {
            this.ensureIndexIsVisible(n);
        }
    }

    public void setSelectedItem(I i) {
        this.setSelectedValue(i, false);
    }

    public void setSelectedItem(I i, boolean bl) {
        this.setSelectedValue(i, bl);
    }

    public List<I> getSelectedItems() {
        return Arrays.asList(this.getSelectedValues());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (TK.isChange(this.text, string)) {
            this.text = string;
            this.repaint();
        }
    }

    public boolean isEmpty() {
        return this.getModel().getSize() == 0;
    }

    @Override
    public Iterator<I> iterator() {
        return new AbstractIterator<I>(){

            @Override
            public I getObjectAt(int n) {
                return MList.this.getItemAt(n);
            }

            @Override
            public int getObjectCount() {
                return MList.this.getItemCount();
            }
        };
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isEmpty()) {
            MList.paintListText(this, graphics, this.text, this.getSelectionBackground(), this.getSelectionForeground());
        }
    }

    public boolean removeItem(I i) {
        return this.getDefaultModel().removeElement(i);
    }

    public boolean removeRange(int n) {
        int n2 = this.getItemCount();
        if (n2 == 0) {
            return false;
        }
        if (n > n2 - 1) {
            return false;
        }
        try {
            this.getDefaultModel().removeRange(n, n2 - 1);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MLogger.exception(arrayIndexOutOfBoundsException);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MLogger.exception(illegalArgumentException);
            return false;
        }
    }

    public void repaintItem(I i) {
        int n = this.findItem(i);
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    public void replaceItem(I i, int n) {
        this.getDefaultModel().set(n, i);
    }

    public void selectRelativeIndex(int n, boolean bl) {
        int n2 = this.getSelectedIndex() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.getItemCount() - 1) {
            n2 = this.getItemCount() - 1;
        }
        this.setSelectedIndex(n2, bl);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer, I i) {
        this.setCellRenderer(listCellRenderer);
        this.setPrototypeCellValue(i);
    }

    public void setSingleSelectionMode() {
        this.setSelectionMode(0);
    }

    @Override
    public void sort() {
        this.sort((Comparator<I>)null);
    }

    @Override
    public void sort(Comparator<I> comparator) {
        ListModel listModel = this.getModel();
        if (listModel == null || listModel.getClass() != DefaultListModel.class) {
            throw new UnsupportedOperationException("\"DefaultListModel\" expected");
        }
        int n = listModel.getSize();
        if (n < 2) {
            return;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = listModel.getElementAt(i);
        }
        Arrays.sort(objectArray, comparator);
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
        this.setModel(defaultListModel);
    }

    @Override
    public Config.IntInfo getIntInfo() {
        return new Config.IntInfo(0, this.getItemCount() - 1);
    }

    protected void fireActionPerformed() {
        TK.fireActionPerformed(this, this.getActionListeners());
    }

    protected void onAction() {
    }

    protected void onSelect() {
    }

    private boolean canShowPopupMenu(I i) {
        if (i == null) {
            return false;
        }
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.getSelectionMode() != 0 || this.getSelectedItem() == i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(ActionType actionType, InputEvent inputEvent) {
        try {
            this.actionType = actionType;
            this.actionEvent = inputEvent;
            this.onAction();
            this.fireActionPerformed();
        }
        finally {
            this.actionType = ActionType.NONE;
            this.actionEvent = null;
        }
    }

    static void paintListText(Component component, Graphics graphics, String string, Color color, Color color2) {
        if (TK.isEmpty(string)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(new Font("Dialog", 1, UI.getDefaultFontSize() + 1));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        int n3 = component.getWidth() / 2 - n / 2;
        int n4 = (component.getHeight() - n2) / 2 + fontMetrics.getAscent();
        Object object = UI.setAntialiasing(graphics2D, true);
        Rectangle rectangle = new Rectangle(n3 - 5, (component.getHeight() - n2) / 2 - 5, n + 10, n2 + 10);
        if (color == null) {
            color = Color.WHITE;
        }
        graphics2D.setColor(MColor.getBrighter(color));
        graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 10, 10);
        graphics2D.setColor(color);
        graphics2D.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 10, 10);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        graphics2D.setColor(MColor.getBrighter(color2));
        graphics2D.drawString(string, n3, n4);
    }

    private static final class StaticHandler<I>
    extends MMouseAdapter
    implements KeyListener {
        private StaticHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            MList mList = (MList)keyEvent.getSource();
            if (UI.isPopupTrigger(keyEvent) && mList.canShowPopupMenu(mList.getSelectedItem())) {
                mList.doAction(ActionType.ITEM_POPUP_MENU, keyEvent);
                keyEvent.consume();
            } else if (TK.isKeyStroke(keyEvent, 32)) {
                mList.doAction(ActionType.TRIGGER, keyEvent);
                keyEvent.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MList mList;
            Object i;
            if (StaticHandler.isLeft(mouseEvent) && (i = (mList = (MList)mouseEvent.getSource()).getItemAt(mouseEvent.getPoint())) != null) {
                switch (mouseEvent.getClickCount()) {
                    case 1: {
                        mList.doAction(ActionType.SINGLE_CLICK, mouseEvent);
                        mouseEvent.consume();
                        break;
                    }
                    case 2: {
                        mList.doAction(ActionType.TRIGGER, mouseEvent);
                        mouseEvent.consume();
                    }
                }
            }
        }

        @Override
        public void popupTrigger(MouseEvent mouseEvent) {
            MList mList = (MList)mouseEvent.getSource();
            Object i = mList.getItemAt(mouseEvent.getPoint());
            if (i == null) {
                return;
            }
            if (mList.getSelectionMode() == 0 && mList.getSelectedItem() != i || mList.isSelectionEmpty()) {
                mList.setSelectedItem(i);
            }
            if (mList.canShowPopupMenu(i)) {
                mList.doAction(ActionType.ITEM_POPUP_MENU, mouseEvent);
                mouseEvent.consume();
            }
        }
    }

    private final class ItemRowFilterEntry
    extends RowFilter.Entry<List<I>, Integer> {
        private final I value;
        private final Integer identifier;
        private final List<I> model;

        @Override
        public Integer getIdentifier() {
            return this.identifier;
        }

        @Override
        public List<I> getModel() {
            return this.model;
        }

        @Override
        public Object getValue(int n) {
            return this.value;
        }

        @Override
        public int getValueCount() {
            return 1;
        }

        private ItemRowFilterEntry(List<I> list, int n, I i) {
            this.model = list;
            this.identifier = n;
            this.value = i;
        }
    }

    public static class SearchableFilter<I extends Searchable<F>, F>
    extends Filter<I, F> {
        private final EnumSet<Searchable.Matches> options;

        public SearchableFilter(F f) {
            this(f, Searchable.DEFAULT_SEARCH_OPTIONS);
        }

        public SearchableFilter(F f, EnumSet<Searchable.Matches> enumSet) {
            super(f);
            this.options = enumSet;
        }

        @Override
        public boolean include(I i) {
            return i.matches((Object)this.filter, this.options);
        }
    }

    public static abstract class Filter<I, F>
    extends RowFilter<List<I>, Integer> {
        protected F filter;

        public Filter(F f) {
            this.filter = f;
        }

        public abstract boolean include(I var1);

        @Override
        public boolean include(RowFilter.Entry<? extends List<I>, ? extends Integer> entry) {
            return this.include(entry.getValue(0));
        }
    }

    public static enum ActionType {
        NONE,
        ITEM_POPUP_MENU,
        TRIGGER,
        SINGLE_CLICK;

    }
}

