/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import java.util.EnumMap;
import org.makagiga.commons.MBorder;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.UI;

public class MLineBorder
extends MBorder {
    private final EnumMap<Position, Style> styles = new EnumMap(Position.class);

    public MLineBorder() {
        super(false, 0, 0, 0, 0);
        for (Position position : Position.values()) {
            this.styles.put(position, new Style(position));
        }
    }

    public MLineBorder(Position ... positionArray) {
        this();
        for (Style style : this.styles.values()) {
            style.setVisible(false);
        }
        for (Position position : positionArray) {
            this.getStyle(position).setVisible(true);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return super.getBorderInsets(component);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = this.getStyle(Position.TOP).getInset();
        insets.bottom = this.getStyle(Position.BOTTOM).getInset();
        boolean bl = component != null && UI.isRTL(component);
        insets.left = this.getStyle(bl ? Position.RIGHT : Position.LEFT).getInset();
        insets.right = this.getStyle(bl ? Position.LEFT : Position.RIGHT).getInset();
        return insets;
    }

    public Style getStyle(Position position) {
        return this.styles.get((Object)position);
    }

    @Override
    public boolean isBorderOpaque() {
        return super.isBorderOpaque();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        MGraphics2D mGraphics2D = new MGraphics2D(graphics);
        Style style = this.getStyle(Position.TOP);
        if (style.setup(mGraphics2D)) {
            mGraphics2D.drawHLine(n, n2 + style.getSize() / 2, n + n3 - 1);
        }
        if ((style = this.getStyle(Position.BOTTOM)).setup(mGraphics2D)) {
            mGraphics2D.drawHLine(n, n2 + n4 - Math.max(1, style.getSize() / 2), n + n3 - 1);
        }
        if ((style = this.getStyle((bl = component != null && UI.isRTL(component)) ? Position.RIGHT : Position.LEFT)).setup(mGraphics2D)) {
            mGraphics2D.drawVLine(n + style.getSize() / 2, n2, n2 + n4 - 1);
        }
        if ((style = this.getStyle(bl ? Position.LEFT : Position.RIGHT)).setup(mGraphics2D)) {
            mGraphics2D.drawVLine(n + n3 - Math.max(1, style.getSize() / 2), n2, n2 + n4 - 1);
        }
    }

    public static class Style
    implements Serializable {
        private boolean visible = true;
        private Color color = Color.BLACK;
        private int size = 1;
        private final Position position;

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Position getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        protected Style(Position position) {
            this.position = position;
        }

        private int getInset() {
            return this.visible ? this.size : 0;
        }

        private boolean setup(MGraphics2D mGraphics2D) {
            if (this.color == null) {
                return false;
            }
            if (this.visible) {
                mGraphics2D.setColor(this.color);
                mGraphics2D.setLineWidth(this.size);
            }
            return this.visible;
        }
    }

    public static enum Position {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;

    }
}

