/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTimeline;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.mv.FontRenderer;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestSource;
import org.makagiga.commons.swing.ValueChooser;
import org.makagiga.commons.validator.ListSelectionValidator;
import org.makagiga.commons.validator.ValidatorSupport;

public class MFontChooser
extends MPanel
implements ValueChooser<Font> {
    private boolean inUpdatePreview;
    private Font lastFont;
    private final HashSet<String> starredList = new HashSet();
    private int lastFontSize = -1;
    private JComponent preview;
    private final MList<Integer> fontSize;
    private final MList<Integer> fontStyle;
    private final MList<String> fontName;
    private final MNumberSpinner<Integer> fontSizeSpinner;
    private MSearchPanel filter;
    private MTimeline<JComponent> fontSizeAnimation;
    private static String filterText;
    private static String previewText;

    public MFontChooser(Font font, JComponent jComponent) {
        Config config = Config.getDefault();
        String string = config.read("FontChooser.starred", "");
        this.starredList.addAll(TK.fastSplit(string, ','));
        this.fontName = new MList<String>(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.ITEM_POPUP_MENU) {
                    MFontChooser.this.showFontNameMenu();
                }
            }
        };
        RequestSource<Font> requestSource = new RequestSource<Font>(){

            @Override
            public void requestDone(RequestInfo<Font> requestInfo, Font font) {
                if (font != null) {
                    MFontChooser.this.fontName.repaintItem(font.getName());
                }
            }
        };
        FontRenderer fontRenderer = new FontRenderer(requestSource){

            @Override
            protected void onRender(String string) {
                super.onRender(string);
                if (MFontChooser.this.starredList.contains(string)) {
                    this.setIcon(MActionInfo.SHOW_STARRED.getSmallIcon());
                } else {
                    this.setIcon(null);
                }
            }
        };
        this.fontName.setCellRenderer(fontRenderer);
        this.fontName.setFixedCellHeight(fontRenderer.getFont().getSize() + 8);
        this.fontName.setFixedCellWidth(200);
        this.fontName.setSingleSelectionMode();
        this.fontStyle = new MList();
        this.fontStyle.setCellRenderer((ListCellRenderer<Integer>)new MRenderer<Integer>(5){

            @Override
            protected void onRender(Integer n) {
                this.setFont(this.getFont().deriveFont(n));
                switch (n) {
                    case 0: {
                        this.setText(UI._("Normal"));
                        break;
                    }
                    case 2: {
                        this.setText(UI._("Italic"));
                        break;
                    }
                    case 1: {
                        this.setText(UI._("Bold"));
                        break;
                    }
                    case 3: {
                        this.setText(UI._("Bold") + " + " + UI._("Italic"));
                        break;
                    }
                    default: {
                        this.setText("?");
                    }
                }
            }
        });
        this.fontStyle.setSingleSelectionMode();
        this.fontStyle.addItem(0);
        this.fontStyle.addItem(2);
        this.fontStyle.addItem(1);
        this.fontStyle.addItem(3);
        final int[] nArray = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 22, 24, 26, 28, 32, 36, 40, 44, 48, 54, 60, 66, 72, 80, 88, 96, 106, 116, 128};
        this.fontSizeSpinner = new MNumberSpinner();
        this.fontSizeSpinner.setRange((Comparable<Integer>)nArray[0], (Comparable<Integer>)nArray[nArray.length - 1]);
        this.fontSize = new MList();
        this.fontSize.setCellRenderer((ListCellRenderer<Integer>)new MRenderer<Integer>(){

            @Override
            protected void onRender(Integer n) {
                float f = Math.max(10.0f, n.floatValue());
                f = Math.min(72.0f, f);
                this.setFont(this.getFont().deriveFont(f));
                this.setText(n.toString());
            }
        });
        this.fontSize.setSingleSelectionMode();
        this.fontSize.setToolTipText(UI._("Size"));
        for (int n : nArray) {
            this.fontSize.addItem(n);
        }
        Object object = MPanel.createHBoxPanel();
        ((MPanel)object).add(this.createFontNamePanel());
        ((MPanel)object).addContentGap();
        ((MPanel)object).add(MPanel.createVLabelPanel(this.fontStyle, UI._("Font Style")));
        ((MPanel)object).addContentGap();
        MPanel mPanel = MPanel.createBorderPanel(5);
        mPanel.addNorth(MPanel.createVLabelPanel(this.fontSizeSpinner, UI._("Size")));
        mPanel.addCenter(this.fontSize);
        ((MPanel)object).add(mPanel);
        this.addCenter((JComponent)object);
        if (jComponent == null) {
            MTextField mTextField = new MTextField();
            mTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), UI.createEmptyBorder(10)));
            mTextField.setHorizontalAlignment(0);
            mTextField.setStyle("background-color: white; color: black");
            if (TK.isEmpty(previewText)) {
                mTextField.setText(UI._("The quick brown fox jumps over the lazy dog"));
            } else {
                mTextField.setText(previewText);
            }
            this.preview = mTextField;
        } else {
            this.preview = jComponent;
        }
        if (this.preview.getToolTipText() == null) {
            this.preview.setToolTipText(UI._("Preview"));
        }
        MPanel mPanel2 = new MPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, nArray[nArray.length - 1] + 5);
            }
        };
        mPanel2.addCenter(this.preview);
        mPanel2.setStyle("margin-top: " + mPanel2.getContentMargin());
        this.addSouth(mPanel2);
        this.updateFontList();
        this.setSelectedFont(font);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!MFontChooser.this.inUpdatePreview && !listSelectionEvent.getValueIsAdjusting()) {
                    try {
                        MFontChooser.this.inUpdatePreview = true;
                        Integer n = (Integer)MFontChooser.this.fontSize.getSelectedItem();
                        if (n != null) {
                            MFontChooser.this.fontSizeSpinner.setNumber(n);
                        }
                    }
                    finally {
                        MFontChooser.this.inUpdatePreview = false;
                    }
                    MFontChooser.this.updatePreview();
                }
            }
        };
        this.fontName.addListSelectionListener(listSelectionListener);
        this.fontStyle.addListSelectionListener(listSelectionListener);
        this.fontSize.addListSelectionListener(listSelectionListener);
        ChangeListener changeListener = new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!MFontChooser.this.inUpdatePreview) {
                    try {
                        MFontChooser.this.inUpdatePreview = true;
                        Integer n = (Integer)MFontChooser.this.fontSizeSpinner.getNumber();
                        if (MFontChooser.this.fontSize.getDefaultModel().contains(n)) {
                            MFontChooser.this.fontSize.setSelectedItem(n, true);
                        } else {
                            MFontChooser.this.fontSize.clearSelection();
                        }
                    }
                    finally {
                        MFontChooser.this.inUpdatePreview = false;
                    }
                    MFontChooser.this.updatePreview();
                }
            }
        };
        this.fontSizeSpinner.addChangeListener(changeListener);
    }

    public static Font getFont(Window window, Font font) {
        return MFontChooser.getFont(window, font, null);
    }

    public static Font getFont(Window window, Font font, JComponent jComponent) {
        MDialog mDialog = new MDialog(window, UI._("Select a Font"), "ui/font");
        MFontChooser mFontChooser = new MFontChooser(font, jComponent);
        ValidatorSupport validatorSupport = mDialog.getValidatorSupport();
        validatorSupport.add(new ListSelectionValidator(mFontChooser.fontName));
        validatorSupport.add(new ListSelectionValidator(mFontChooser.fontStyle));
        mDialog.addCenter(mFontChooser);
        mDialog.setResizable(false);
        mDialog.setSize(UI.WindowSize.MEDIUM);
        if (mDialog.exec()) {
            if (mFontChooser.preview instanceof JTextComponent) {
                previewText = ((JTextComponent)JTextComponent.class.cast(mFontChooser.preview)).getText();
            }
            return mFontChooser.getSelectedFont();
        }
        return null;
    }

    public Font getSelectedFont() {
        String string = this.fontName.getSelectedItem();
        Integer n = this.fontStyle.getSelectedItem();
        Integer n2 = this.fontSizeSpinner.getNumber();
        if (string == null || n == null || n2 == null) {
            return null;
        }
        this.lastFont = new Font(string, (int)n, n2);
        return this.lastFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFont(Font font) {
        Font font2 = font == null ? this.getFont() : font;
        this.fontName.setSelectedItem(font2.getName(), true);
        this.fontStyle.setSelectedItem(font2.getStyle(), true);
        int n = font2.getSize();
        try {
            this.inUpdatePreview = true;
            this.fontSize.setSelectedItem(n, true);
            this.fontSizeSpinner.setNumber(n);
            this.updatePreview();
        }
        finally {
            this.inUpdatePreview = false;
        }
    }

    @Override
    public void addValueListener(ValueListener<Font> valueListener) {
        this.listenerList.add(ValueListener.class, valueListener);
    }

    @Override
    public void removeValueListener(ValueListener<Font> valueListener) {
        this.listenerList.remove(ValueListener.class, valueListener);
    }

    @Override
    public ValueListener<Font>[] getValueListeners() {
        return (ValueListener[])this.listenerList.getListeners(ValueListener.class);
    }

    @Override
    public Font getValue() {
        return this.getSelectedFont();
    }

    @Override
    public void setValue(Font font) {
        this.setSelectedFont(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePreview() {
        Font font;
        if (this.lastFont != null) {
            try {
                this.inUpdatePreview = true;
                if (this.fontName.isSelectionEmpty()) {
                    this.fontName.setSelectedItem(this.lastFont.getName());
                }
                if (this.fontStyle.isSelectionEmpty()) {
                    this.fontStyle.setSelectedItem(this.lastFont.getStyle());
                }
                if (this.fontSize.isSelectionEmpty()) {
                    this.fontSize.setSelectedItem(this.lastFont.getSize());
                }
            }
            finally {
                this.inUpdatePreview = false;
            }
        }
        if ((font = this.getSelectedFont()) != null) {
            if (this.fontSizeAnimation != null) {
                this.fontSizeAnimation.end();
            }
            if (!((Boolean)UI.animations.get()).booleanValue() || this.lastFontSize == -1) {
                this.lastFontSize = font.getSize();
                this.preview.setFont(font);
            } else if (font.getSize() != this.lastFontSize) {
                this.lastFontSize = font.getSize();
                this.fontSizeAnimation = new MTimeline<JComponent>(this.preview);
                this.fontSizeAnimation.addPropertyToInterpolate("font", (JComponent)((Object)this.preview.getFont()), (JComponent)((Object)font));
                this.fontSizeAnimation.play();
            } else {
                this.preview.setFont(font);
            }
        }
    }

    private MPanel createFontNamePanel() {
        MPanel mPanel = MPanel.createVLabelPanel(this.fontName, UI._("Font"));
        if (TK.isEmpty(filterText)) {
            filterText = null;
        }
        this.filter = new MSearchPanel(filterText, false, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                filterText = this.getText();
                MFontChooser.this.updateFontList();
            }
        };
        MSmallButton mSmallButton = this.filter.getMenuButton();
        mSmallButton.setPopupMenuEnabled(true);
        mSmallButton.setVisible(true);
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add("starred", new MAction(MActionInfo.SHOW_STARRED){

            @Override
            public void onAction() {
                MFontChooser.this.filter.setText("*");
            }
        });
        actionGroup.installPopupMenu(mSmallButton);
        mPanel.addSouth(this.filter);
        return mPanel;
    }

    private void showFontNameMenu() {
        final String string = this.fontName.getSelectedItem();
        if (string == null) {
            return;
        }
        MMenu mMenu = new MMenu();
        boolean bl = this.starredList.contains(string);
        MAction mAction = new MAction(bl ? MActionInfo.REMOVE_STAR : MActionInfo.ADD_STAR){

            @Override
            public void onAction() {
                if (this.isSelected()) {
                    MFontChooser.this.starredList.add(string);
                } else {
                    MFontChooser.this.starredList.remove(string);
                }
                Config config = Config.getDefault();
                String string2 = TK.join(MFontChooser.this.starredList, ",");
                config.write("FontChooser.starred", string2);
                config.sync();
                MFontChooser.this.fontName.repaintItem(string);
            }
        };
        mMenu.addCheckBox(mAction, bl);
        mMenu.showPopup(this.fontName.getActionEvent());
    }

    private void updateFontList() {
        StringList stringList = new StringList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        if (filterText == null) {
            this.fontName.filter(this.filter, stringList, null);
        } else {
            this.fontName.filter(this.filter, stringList, (RowFilter<List<String>, Integer>)new MList.Filter<String, String>(filterText){

                @Override
                public boolean include(String string) {
                    return "*".equals(this.filter) && MFontChooser.this.starredList.contains(string) || TK.containsIgnoreCase(string, (String)this.filter);
                }
            });
        }
    }
}

