/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;

public final class MClipboard {
    private static boolean historyEnabled;
    private static Clipboard localClipboard;
    private static LinkedList<Object> _history;

    public static void clear() throws ClipboardException {
        MClipboard.setString("");
    }

    public static synchronized void clearHistory() {
        if (_history != null) {
            MClipboard.checkPermission();
            _history.clear();
        }
    }

    @Deprecated
    public static DataFlavor getBestImageFlavor(DataFlavor[] dataFlavorArray) {
        return MDataTransfer.findBestImageFlavor(dataFlavorArray, "image/png");
    }

    public static synchronized Object getContents(DataFlavor dataFlavor) throws ClipboardException {
        return MClipboard.getContents(MClipboard.getDefault(), dataFlavor);
    }

    public static synchronized Object getContents(Clipboard clipboard, DataFlavor dataFlavor) throws ClipboardException {
        TK.checkNull(clipboard, "clipboard");
        TK.checkNull(dataFlavor, "flavor");
        try {
            if (clipboard.isDataFlavorAvailable(dataFlavor)) {
                return clipboard.getData(dataFlavor);
            }
            return null;
        }
        catch (Exception exception) {
            throw new ClipboardException(exception);
        }
    }

    public static synchronized void setContents(Transferable transferable) throws ClipboardException {
        TK.checkNull(transferable, "contents");
        Clipboard clipboard = MClipboard.getDefault();
        try {
            clipboard.setContents(transferable, transferable instanceof ClipboardOwner ? (ClipboardOwner)((Object)transferable) : null);
        }
        catch (Exception exception) {
            throw new ClipboardException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Clipboard getDefault() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException securityException) {
            MLogger.exception(securityException);
            MClipboard.checkPermission();
            Class<MClipboard> clazz = MClipboard.class;
            synchronized (MClipboard.class) {
                if (localClipboard == null) {
                    localClipboard = new Clipboard("Local Clipboard");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return localClipboard;
            }
        }
    }

    public synchronized List<Object> getHistory() {
        if (_history == null) {
            return Collections.emptyList();
        }
        MClipboard.checkPermission();
        return Collections.unmodifiableList(_history);
    }

    public static synchronized Image getImage() throws ClipboardException {
        try {
            return MDataTransfer.getImage(MClipboard.getDefault());
        }
        catch (Exception exception) {
            throw new ClipboardException(exception);
        }
    }

    public static String getString() throws ClipboardException {
        Object object = MClipboard.getContents(DataFlavor.stringFlavor);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public static synchronized void setString(String string) throws ClipboardException {
        MClipboard.setContents(new StringSelection(string));
        MClipboard.updateHistory(string);
    }

    public static String getURL() {
        try {
            String string = MClipboard.getString();
            if (string != null && Net.isValidURL(string = string.trim())) {
                return string;
            }
        }
        catch (ClipboardException clipboardException) {
            MLogger.exception(clipboardException);
        }
        return null;
    }

    public static boolean isDataFlavorAvailable(DataFlavor dataFlavor) throws ClipboardException {
        TK.checkNull(dataFlavor, "flavor");
        try {
            return MClipboard.getDefault().isDataFlavorAvailable(dataFlavor);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ClipboardException(illegalStateException);
        }
        catch (NullPointerException nullPointerException) {
            MLogger.exception(nullPointerException);
            return false;
        }
    }

    public static synchronized boolean isHistoryEnabled() {
        return historyEnabled;
    }

    public static synchronized void setHistoryEnabled(boolean bl) {
        MClipboard.checkPermission();
        historyEnabled = bl;
    }

    private MClipboard() {
    }

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
    }

    private static synchronized void updateHistory(Object object) throws ClipboardException {
        if (!historyEnabled || object == null) {
            return;
        }
        if (_history == null) {
            _history = new LinkedList();
        }
        if (_history.size() == 10) {
            _history.removeLast();
        }
        _history.addFirst(object);
    }
}

