/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import com.jhlabs.image.GammaFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.ConstructorProperties;
import java.beans.EventHandler;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.style.StyleSupport;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelinePropertyBuilder;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;

public class MButton
extends JButton
implements MIcon.Name,
StyleSupport {
    private boolean popupMenuArrowPainted = true;
    private boolean popupMenuEnabled;
    private boolean rolloverEffectEnabled = true;
    private int minimumWidth = -1;
    private static final StaticHandler staticHandler = new StaticHandler();
    private static final StaticHoverTimelineScenario hoverScenario = new StaticHoverTimelineScenario();
    private static final StaticRolloverHandler staticRolloverHandler = new StaticRolloverHandler();
    private static final StaticToolBarHandler staticToolBarHandler = new StaticToolBarHandler();
    private static final String ROLLOVER_ICON_PROPERTY = "org.makagiga.commons.MButton.rollover";
    private static final String SAFE_ACTION_PROPERTY = "org.makagiga.commons.MButton.safeAction";
    private static final String SAFE_ACTION_ICON_PROPERTY = "org.makagiga.commons.MButton.safeActionIcon";

    public MButton() {
        this(null, (Icon)null);
    }

    public MButton(Action action) {
        super(action);
        this.init();
    }

    public MButton(MActionInfo mActionInfo) {
        this(mActionInfo.getText(), mActionInfo.getIconName());
    }

    public MButton(Icon icon) {
        this(null, icon);
    }

    @ConstructorProperties(value={"text"})
    public MButton(String string) {
        this(string, (Icon)null);
    }

    public MButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    @ConstructorProperties(value={"text", "iconName"})
    public MButton(String string, String string2) {
        this(string, MIcon.stock(string2));
    }

    public boolean doPopupMenu() {
        if (this.popupMenuEnabled) {
            MMenu mMenu = this.onPopupMenu();
            if (mMenu != null) {
                mMenu.showPopup((Component)this.getParent(), this);
                return true;
            }
            JPopupMenu jPopupMenu = this.getComponentPopupMenu();
            if (jPopupMenu != null) {
                Rectangle rectangle = this.getBounds();
                MMenu.showPopup(jPopupMenu, this.getParent(), rectangle.x, rectangle.y + rectangle.height);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.getIcon());
    }

    @Override
    public void setIconName(String string) {
        this.setIcon(MIcon.stock(string));
    }

    public void setIconNameUI(String string) {
        if (((Boolean)UI.buttonIcons.get()).booleanValue()) {
            this.setIconName(string);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.minimumWidth == -1) {
            return dimension;
        }
        if (dimension.width < this.minimumWidth) {
            dimension.width = this.minimumWidth;
        }
        return dimension;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Action action = this.getAction();
        String string = super.getToolTipText();
        if ("".equals(string)) {
            string = this.getText();
            if (string == null && action != null && TK.isEmpty(string = (String)MAction.getValue(action, "Name", null))) {
                string = MAction.getToolTipText(action);
            }
        } else if (MObject.safeEquals(string, this.getText())) {
            string = null;
        }
        if ("".equals(string)) {
            string = null;
        }
        KeyStroke keyStroke = action == null ? null : (KeyStroke)MAction.getValue(action, "AcceleratorKey", null);
        KeyStroke keyStroke2 = action == null ? null : (KeyStroke)MAction.getValue(action, "org.makagiga.commons.MAction.ALTERNATE_ACCELERATOR_KEY", null);
        StringBuilder stringBuilder = null;
        if (keyStroke != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append('(').append(TK.toString(keyStroke));
            if (keyStroke2 != null && !keyStroke.equals(keyStroke2)) {
                stringBuilder.append(" | ").append(TK.toString(keyStroke2));
            }
            stringBuilder.append(')');
        }
        if (stringBuilder != null) {
            if (string == null) {
                return stringBuilder.toString();
            }
            int n = string.lastIndexOf("</body>");
            if (n == -1) {
                return string + " " + stringBuilder;
            }
            return string.substring(0, n) + "&nbsp;&nbsp;" + stringBuilder + string.substring(n);
        }
        return string;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int n) {
        if (n != this.minimumWidth) {
            this.minimumWidth = n;
            this.invalidate();
        }
    }

    public Window getWindowAncestor() {
        return SwingUtilities.getWindowAncestor(this);
    }

    public boolean isPopupMenuArrowPainted() {
        return this.popupMenuArrowPainted;
    }

    public void setPopupMenuArrowPainted(boolean bl) {
        if (bl != this.popupMenuArrowPainted) {
            this.popupMenuArrowPainted = bl;
            this.repaint();
        }
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean bl) {
        if (bl != this.popupMenuEnabled) {
            this.popupMenuEnabled = bl;
            this.repaint();
        }
    }

    @Deprecated
    public static void installRolloverEffect(AbstractButton abstractButton) {
        if (UI.isLipstik() || UI.isRetro()) {
            return;
        }
        abstractButton.setRolloverEnabled(true);
        abstractButton.addMouseListener(staticRolloverHandler);
    }

    @Deprecated
    public void installSpecialEffects() {
        MButton.installSpecialEffects(this);
    }

    @Deprecated
    public static void installSpecialEffects(AbstractButton abstractButton) {
        abstractButton.addMouseListener(staticToolBarHandler);
        abstractButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UI.getDarker(UI.getColor("TextField.selectionBackground"), Color.WHITE)), UI.createEmptyBorder(2)));
        MButton.staticToolBarHandler.setupButton(abstractButton, false);
    }

    public boolean isRolloverEffectEnabled() {
        return this.rolloverEffectEnabled;
    }

    public void setRolloverEffectEnabled(boolean bl) {
        this.rolloverEffectEnabled = bl;
    }

    public boolean isSafeAction() {
        return this.getClientProperty(SAFE_ACTION_PROPERTY) != null;
    }

    public void setSafeAction(boolean bl) {
        MButton.setSafeAction(this, bl);
    }

    public void onClick(Object object, String string) {
        this.addActionListener(EventHandler.create(ActionListener.class, object, string));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.popupMenuArrowPainted && this.popupMenuEnabled) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = this.getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            color = MColor.getContrast(color);
            graphics2D.setColor(color);
            int n = 7;
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            Object object = UI.setAntialiasing(graphics2D, true);
            graphics2D.fill(MGraphics2D.createTriangle(n2, n3 - n, n2 - n, n3, n2, n3));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        MButton.clearRollover(this);
    }

    public void setIconUI(Icon icon) {
        if (((Boolean)UI.buttonIcons.get()).booleanValue()) {
            this.setIcon(icon);
        }
    }

    @Deprecated
    public static void setSafeAction(AbstractButton abstractButton, boolean bl) {
        SafeActionHandler safeActionHandler = UI.getClientProperty(abstractButton, SAFE_ACTION_PROPERTY, null);
        if (bl) {
            if (safeActionHandler == null) {
                safeActionHandler = new SafeActionHandler();
                abstractButton.addMouseListener(safeActionHandler);
                abstractButton.putClientProperty(SAFE_ACTION_PROPERTY, safeActionHandler);
            }
        } else if (safeActionHandler != null) {
            abstractButton.removeMouseListener(safeActionHandler);
            abstractButton.putClientProperty(SAFE_ACTION_PROPERTY, null);
        }
    }

    @Deprecated
    public static void setSafeActionIcon(AbstractButton abstractButton, Icon icon) {
        abstractButton.putClientProperty(SAFE_ACTION_ICON_PROPERTY, icon);
    }

    @Deprecated
    public static void startRolloverEffect(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon instanceof MIcon && abstractButton.isRolloverEnabled() && MButton.isRolloverEffect(abstractButton) && ((MIcon)MIcon.class.cast(icon)).getImage() != null) {
            MButton.hoverScenario.play(abstractButton);
        }
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    @Override
    protected void actionPropertyChanged(Action action, String string) {
        Object object;
        super.actionPropertyChanged(action, string);
        if (action != null && "org.makagiga.commons.MAction.VISIBLE_KEY".equals(string) && (object = action.getValue("org.makagiga.commons.MAction.VISIBLE_KEY")) instanceof Boolean) {
            this.setVisible((Boolean)object);
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        Object object;
        super.configurePropertiesFromAction(action);
        if (action != null && (object = action.getValue("org.makagiga.commons.MAction.VISIBLE_KEY")) instanceof Boolean) {
            this.setVisible((Boolean)object);
        }
    }

    protected void onClick() {
    }

    protected MMenu onPopupMenu() {
        return null;
    }

    private static void clearRollover(AbstractButton abstractButton) {
        if (abstractButton instanceof MButton && !((MButton)MButton.class.cast(abstractButton)).isRolloverEffectEnabled()) {
            return;
        }
        if (UI.isLipstik() || UI.isRetro()) {
            return;
        }
        if (MButton.isRolloverEffect(abstractButton)) {
            MButton.hoverScenario.stop();
            abstractButton.setRolloverIcon(null);
            abstractButton.setRolloverSelectedIcon(null);
        }
    }

    private void init() {
        this.addActionListener(staticHandler);
        MButton.installRolloverEffect(this);
        this.putClientProperty(ROLLOVER_ICON_PROPERTY, true);
    }

    private static boolean isRolloverEffect(AbstractButton abstractButton) {
        return UI.getClientProperty(abstractButton, ROLLOVER_ICON_PROPERTY, false);
    }

    private void processClickEvent() {
        if (this.doPopupMenu()) {
            return;
        }
        this.onClick();
    }

    private static final class StaticToolBarHandler
    extends MMouseAdapter {
        private StaticToolBarHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            if (abstractButton.isEnabled()) {
                this.setupButton(abstractButton, true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            this.setupButton(abstractButton, false);
        }

        private void setupButton(AbstractButton abstractButton, boolean bl) {
            if (!(abstractButton instanceof JToggleButton)) {
                abstractButton.setBorderPainted(bl);
                abstractButton.setContentAreaFilled(bl);
            }
        }
    }

    private static final class StaticRolloverHandler
    extends MMouseAdapter {
        private StaticRolloverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            if (abstractButton instanceof MButton && !((MButton)MButton.class.cast(abstractButton)).isRolloverEffectEnabled()) {
                return;
            }
            if (!UI.isSubstance() || abstractButton instanceof MSmallButton) {
                MButton.startRolloverEffect(abstractButton);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            if (abstractButton.isRolloverEnabled()) {
                MButton.clearRollover(abstractButton);
            }
        }
    }

    private static final class StaticHoverTimelineScenario {
        private final GammaFilter filter = new GammaFilter();
        private final StaticHoverTimeline dec;
        private final StaticHoverTimeline inc = new StaticHoverTimeline(this, 250L, 1.0f, 2.5f);

        private StaticHoverTimelineScenario() {
            this.inc.addCallback(new TimelineCallbackAdapter(){

                @Override
                public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                    if (timelineState2 == Timeline.TimelineState.DONE) {
                        StaticHoverTimelineScenario.this.dec.play();
                    }
                }
            });
            this.dec = new StaticHoverTimeline(this, 250L, 2.5f, 1.5f);
        }

        private void play(AbstractButton abstractButton) {
            this.inc.abort();
            this.dec.abort();
            this.inc.setContext(abstractButton);
            this.dec.setContext(abstractButton);
            this.inc.play();
        }

        private void stop() {
            this.inc.abort();
            this.dec.abort();
            this.inc.setContext(null);
            this.dec.setContext(null);
        }
    }

    private static final class StaticHoverTimeline
    extends Timeline {
        private final Object lock = new Object();
        private WeakReference<AbstractButton> contextRef;

        private StaticHoverTimeline(StaticHoverTimelineScenario staticHoverTimelineScenario, long l, float f, float f2) {
            this.setDuration(l);
            this.addPropertyToInterpolate(Timeline.property("gamma").on(staticHoverTimelineScenario.filter).from(Float.valueOf(f)).to(Float.valueOf(f2)).setWith(new TimelinePropertyBuilder.PropertySetter<Float>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void set(Object object, String string, Float f) {
                    AbstractButton abstractButton;
                    final GammaFilter gammaFilter = (GammaFilter)object;
                    gammaFilter.setGamma(f.floatValue());
                    Object object2 = StaticHoverTimeline.this.lock;
                    synchronized (object2) {
                        abstractButton = StaticHoverTimeline.this.contextRef == null ? null : (AbstractButton)StaticHoverTimeline.this.contextRef.get();
                    }
                    if (abstractButton == null) {
                        return;
                    }
                    UI.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = abstractButton.getIcon();
                            if (icon == null) {
                                return;
                            }
                            MIcon mIcon = ((MIcon)MIcon.class.cast(icon)).getFilteredInstance(gammaFilter);
                            abstractButton.setRolloverIcon(mIcon);
                            if (abstractButton.getRolloverSelectedIcon() == null) {
                                abstractButton.setRolloverSelectedIcon(mIcon);
                            }
                        }
                    });
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setContext(AbstractButton abstractButton) {
            Object object = this.lock;
            synchronized (object) {
                if (abstractButton == null) {
                    if (this.contextRef != null) {
                        this.contextRef.clear();
                        this.contextRef = null;
                    }
                } else if (this.contextRef == null || this.contextRef.get() != null) {
                    this.contextRef = new WeakReference<AbstractButton>(abstractButton);
                }
            }
        }
    }

    private static final class StaticHandler
    implements ActionListener {
        private StaticHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MButton mButton = (MButton)actionEvent.getSource();
            mButton.processClickEvent();
        }
    }

    private static final class SafeActionHandler
    extends MMouseAdapter
    implements ActionListener {
        private boolean closeMode;
        private Icon buttonIcon;
        private MTimer buttonTimer;
        private WeakReference<AbstractButton> buttonRef;

        private SafeActionHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setCloseMode((AbstractButton)mouseEvent.getSource(), true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setCloseMode((AbstractButton)mouseEvent.getSource(), false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton;
            MTimer mTimer = (MTimer)actionEvent.getSource();
            mTimer.stop();
            AbstractButton abstractButton2 = abstractButton = this.buttonRef == null ? null : (AbstractButton)this.buttonRef.get();
            if (abstractButton != null) {
                this.buttonRef.clear();
                this.buttonRef = null;
                abstractButton.setEnabled(true);
            }
        }

        private void setCloseMode(AbstractButton abstractButton, boolean bl) {
            if (bl == this.closeMode) {
                return;
            }
            if (bl && !abstractButton.isEnabled()) {
                return;
            }
            this.closeMode = bl;
            if (this.closeMode) {
                this.buttonIcon = abstractButton.getIcon();
                abstractButton.setEnabled(false);
                Icon icon = (Icon)abstractButton.getClientProperty(MButton.SAFE_ACTION_ICON_PROPERTY);
                if (icon == null) {
                    if (this.buttonIcon == null) {
                        abstractButton.setIcon(MIcon.stock("ui/close"));
                    } else {
                        abstractButton.setIcon(MIcon.stock("ui/close", this.buttonIcon.getIconWidth()));
                    }
                } else {
                    abstractButton.setIcon(icon);
                }
                if (this.buttonTimer == null) {
                    this.buttonTimer = new MTimer(500, this);
                }
                this.buttonRef = TK.newWeakRef(abstractButton);
                this.buttonTimer.restart();
            } else {
                abstractButton.setEnabled(true);
                abstractButton.setIcon(this.buttonIcon);
                if (this.buttonTimer != null) {
                    this.buttonTimer.stop();
                }
            }
        }
    }
}

